/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.osc;

import com.illposed.osc.OSCBundle;
import com.illposed.osc.OSCMessage;
import com.illposed.osc.OSCPacket;
import com.illposed.osc.OSCSerializeException;
import com.illposed.osc.transport.OSCPortOut;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.osc.IOpenSoundControlClient;
import de.mossgrabers.framework.osc.IOpenSoundControlMessage;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.List;

public class OpenSoundControlClientImpl
implements IOpenSoundControlClient {
    private final IHost host;
    private OSCPortOut connection;
    private boolean isClosed = true;

    public OpenSoundControlClientImpl(IHost host, String serverAddress, int serverPort) {
        this.host = host;
        try {
            this.connection = new OSCPortOut(InetAddress.getByName(serverAddress), serverPort);
            this.isClosed = false;
        }
        catch (IOException ex) {
            this.connection = null;
            host.error("Could not connect to OSC server.", ex);
        }
    }

    @Override
    public void sendMessage(IOpenSoundControlMessage message) throws IOException {
        if (this.isClosed) {
            return;
        }
        try {
            String address = message.getAddress();
            Object[] values = message.getValues();
            this.connection.send((OSCPacket)new OSCMessage(address, Arrays.asList(values)));
        }
        catch (OSCSerializeException ex) {
            throw new IOException(ex);
        }
    }

    @Override
    public void sendBundle(List<IOpenSoundControlMessage> messages) throws IOException {
        if (this.isClosed) {
            return;
        }
        try {
            int pos = 0;
            OSCBundle oscBundle = new OSCBundle();
            for (IOpenSoundControlMessage message : messages) {
                String address = message.getAddress();
                Object[] values = message.getValues();
                oscBundle.addPacket((OSCPacket)new OSCMessage(address, Arrays.asList(values)));
                if (++pos <= 100) continue;
                pos = 0;
                this.connection.send((OSCPacket)oscBundle);
                oscBundle = new OSCBundle();
            }
            if (!oscBundle.getPackets().isEmpty()) {
                this.connection.send((OSCPacket)oscBundle);
            }
        }
        catch (OSCSerializeException ex) {
            throw new IOException(ex);
        }
    }

    public void close() {
        this.isClosed = true;
        if (this.connection == null) {
            return;
        }
        try {
            this.connection.close();
        }
        catch (IOException ex) {
            this.host.error("Could not close connection to OSC server.", ex);
        }
    }
}

