/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.daw;

import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.IProject;
import de.mossgrabers.framework.daw.data.bank.IParameterBank;
import de.mossgrabers.framework.daw.data.empty.EmptyParameter;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.reaper.communication.Processor;
import de.mossgrabers.reaper.framework.daw.BaseImpl;
import de.mossgrabers.reaper.framework.daw.DataSetupEx;
import de.mossgrabers.reaper.framework.daw.data.bank.ParameterBankImpl;
import de.mossgrabers.reaper.framework.daw.data.bank.TrackBankImpl;

public class ProjectImpl
extends BaseImpl
implements IProject {
    private final IModel model;
    private final Configuration configuration;
    private String name = "None";
    private boolean isDirtyFlag;
    private final ParameterBankImpl parameterBank;

    public ProjectImpl(DataSetupEx dataSetup, IModel model, Configuration configuration, int numParams) {
        super(dataSetup);
        this.model = model;
        this.configuration = configuration;
        this.parameterBank = numParams > 0 ? new ParameterBankImpl(dataSetup, Processor.MASTER, numParams, null) : null;
    }

    @Override
    public void enableObservers(boolean enable) {
        this.sender.enableUpdates(Processor.PROJECT, enable);
    }

    @Override
    public String getName() {
        return this.name != null && this.name.length() > 0 ? this.name : "None";
    }

    @Override
    public void previous() {
        this.invokeAction(40862);
    }

    @Override
    public void next() {
        this.invokeAction(40861);
    }

    @Override
    public void createSceneFromPlayingLauncherClips() {
        this.sendOSC("createSceneFromPlayingLauncherClips");
    }

    @Override
    public void createScene() {
        int newClipLenghthInBeats = this.configuration.getNewClipLenghthInBeats(this.model.getTransport().getQuartersPerMeasure());
        this.sendOSC("createScene", newClipLenghthInBeats);
    }

    public void setInternalName(String name) {
        this.name = name;
    }

    @Override
    public boolean isDirty() {
        return this.isDirtyFlag;
    }

    public void setDirty(boolean isDirty) {
        this.isDirtyFlag = isDirty;
    }

    @Override
    public void save() {
        this.sender.invokeAction(40026);
    }

    @Override
    public void load() {
        this.sender.invokeAction(40025);
    }

    @Override
    public IParameter getCueVolumeParameter() {
        return EmptyParameter.INSTANCE;
    }

    @Override
    public String getCueVolumeStr() {
        return "";
    }

    @Override
    public String getCueVolumeStr(int limit) {
        return "";
    }

    @Override
    public int getCueVolume() {
        return 0;
    }

    @Override
    public void changeCueVolume(int control) {
    }

    @Override
    public void setCueVolume(int value) {
    }

    @Override
    public void resetCueVolume() {
    }

    @Override
    public void touchCueVolume(boolean isBeingTouched) {
    }

    @Override
    public IParameter getCueMixParameter() {
        return EmptyParameter.INSTANCE;
    }

    @Override
    public String getCueMixStr() {
        return "";
    }

    @Override
    public String getCueMixStr(int limit) {
        return "";
    }

    @Override
    public int getCueMix() {
        return 0;
    }

    @Override
    public void changeCueMix(int control) {
    }

    @Override
    public void setCueMix(int value) {
    }

    @Override
    public void resetCueMix() {
    }

    @Override
    public void touchCueMix(boolean isBeingTouched) {
    }

    @Override
    public boolean hasSolo() {
        return ((TrackBankImpl)this.model.getTrackBank()).hasSolo();
    }

    @Override
    public boolean hasMute() {
        return ((TrackBankImpl)this.model.getTrackBank()).hasMute();
    }

    @Override
    public void clearSolo() {
        ((TrackBankImpl)this.model.getTrackBank()).clearSolo();
    }

    @Override
    public void clearMute() {
        ((TrackBankImpl)this.model.getTrackBank()).clearMute();
    }

    @Override
    protected Processor getProcessor() {
        return Processor.PROJECT;
    }

    @Override
    public IParameterBank getParameterBank() {
        return this.parameterBank;
    }
}

