/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.view;

import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.controller.grid.IPadGrid;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.featuregroup.AbstractView;

public abstract class AbstractNumberDisplayView<S extends IControlSurface<C>, C extends Configuration>
extends AbstractView<S, C> {
    private static final boolean[][] TWO_COLS_0 = new boolean[][]{{false, false}, {false, false}, {false, false}, {false, false}, {false, false}};
    private static final boolean[][] TWO_COLS_1 = new boolean[][]{{true, false}, {true, false}, {true, false}, {true, false}, {true, false}};
    private static final boolean[][] TWO_COLS_2 = new boolean[][]{{true, true}, {false, true}, {true, true}, {true, false}, {true, true}};
    private static final boolean[][] TWO_COLS_3 = new boolean[][]{{true, true}, {false, true}, {true, true}, {false, true}, {true, true}};
    private static final boolean[][] TWO_COLS_4 = new boolean[][]{{true, false}, {true, false}, {true, true}, {false, true}, {false, true}};
    private static final boolean[][] TWO_COLS_5 = new boolean[][]{{true, true}, {true, false}, {true, true}, {false, true}, {true, true}};
    private static final boolean[][] TWO_COLS_6 = new boolean[][]{{true, true}, {true, false}, {true, true}, {true, true}, {true, true}};
    private static final boolean[][] TWO_COLS_7 = new boolean[][]{{true, true}, {false, true}, {false, true}, {false, true}, {false, true}};
    private static final boolean[][] TWO_COLS_8 = new boolean[][]{{true, true}, {true, true}, {true, true}, {true, true}, {true, true}};
    private static final boolean[][] TWO_COLS_9 = new boolean[][]{{true, true}, {true, true}, {true, true}, {false, true}, {true, true}};
    private static final boolean[][] THREE_COLS_0 = new boolean[][]{{true, true, true}, {true, false, true}, {true, false, true}, {true, false, true}, {true, true, true}};
    private static final boolean[][] THREE_COLS_1 = new boolean[][]{{false, true, false}, {false, true, false}, {false, true, false}, {false, true, false}, {false, true, false}};
    private static final boolean[][] THREE_COLS_2 = new boolean[][]{{true, true, true}, {false, false, true}, {true, true, true}, {true, false, false}, {true, true, true}};
    private static final boolean[][] THREE_COLS_3 = new boolean[][]{{true, true, true}, {false, false, true}, {true, true, true}, {false, false, true}, {true, true, true}};
    private static final boolean[][] THREE_COLS_4 = new boolean[][]{{true, false, false}, {true, false, false}, {true, true, true}, {false, true, false}, {false, true, false}};
    private static final boolean[][] THREE_COLS_5 = new boolean[][]{{true, true, true}, {true, false, false}, {true, true, true}, {false, false, true}, {true, true, true}};
    private static final boolean[][] THREE_COLS_6 = new boolean[][]{{true, true, true}, {true, false, false}, {true, true, true}, {true, false, true}, {true, true, true}};
    private static final boolean[][] THREE_COLS_7 = new boolean[][]{{true, true, true}, {false, false, true}, {false, false, true}, {false, false, true}, {false, false, true}};
    private static final boolean[][] THREE_COLS_8 = new boolean[][]{{true, true, true}, {true, false, true}, {true, true, true}, {true, false, true}, {true, true, true}};
    private static final boolean[][] THREE_COLS_9 = new boolean[][]{{true, true, true}, {true, false, true}, {true, true, true}, {false, false, true}, {true, true, true}};
    private static final boolean[][][] TWO_COLS = new boolean[][][]{TWO_COLS_0, TWO_COLS_1, TWO_COLS_2, TWO_COLS_3, TWO_COLS_4, TWO_COLS_5, TWO_COLS_6, TWO_COLS_7, TWO_COLS_8, TWO_COLS_9};
    private static final boolean[][][] THREE_COLS = new boolean[][][]{THREE_COLS_0, THREE_COLS_1, THREE_COLS_2, THREE_COLS_3, THREE_COLS_4, THREE_COLS_5, THREE_COLS_6, THREE_COLS_7, THREE_COLS_8, THREE_COLS_9};
    protected final IPadGrid padGrid;
    private final int textColor1;
    private final int textColor2;
    private final int backgroundColor;

    protected AbstractNumberDisplayView(String name, S surface, IModel model, int textColor1, int textColor2, int backgroundColor) {
        super(name, surface, model);
        this.textColor1 = textColor1;
        this.textColor2 = textColor2;
        this.backgroundColor = backgroundColor;
        this.padGrid = this.surface.getPadGrid();
    }

    @Override
    public void drawGrid() {
        int value = Math.min(999, Math.max(0, this.getNumber()));
        int digit1 = value / 100;
        boolean[][] first = TWO_COLS[digit1];
        for (int x = 0; x < 2; ++x) {
            for (int y = 0; y < 5; ++y) {
                this.padGrid.lightEx(x, y, first[y][x] ? this.textColor1 : this.backgroundColor);
            }
        }
        int digit2 = value % 100 / 10;
        boolean[][] second = THREE_COLS[digit2];
        boolean show2ndDigit = digit1 > 0 || digit2 > 0;
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 5; ++y) {
                this.padGrid.lightEx(2 + x, y, show2ndDigit && second[y][x] ? this.textColor2 : this.backgroundColor);
            }
        }
        boolean[][] third = THREE_COLS[value % 10];
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 5; ++y) {
                this.padGrid.lightEx(5 + x, y, third[y][x] ? this.textColor1 : this.backgroundColor);
            }
        }
        this.fillBottom();
    }

    protected void fillBottom() {
        for (int x = 0; x < this.padGrid.getCols(); ++x) {
            for (int y = 5; y < this.padGrid.getRows(); ++y) {
                this.padGrid.lightEx(x, y, this.backgroundColor);
            }
        }
    }

    @Override
    public void onGridNote(int note, int velocity) {
        if (velocity == 0) {
            this.surface.getViewManager().restore();
        }
    }

    protected abstract int getNumber();
}

