/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.scale;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public enum Scale {
    MAJOR("Major", new int[]{0, 2, 4, 5, 7, 9, 11}),
    MINOR("Minor", new int[]{0, 2, 3, 5, 7, 8, 10}),
    DORIAN("Dorian", new int[]{0, 2, 3, 5, 7, 9, 10}),
    MIXOLYDIAN("Mixolydian", new int[]{0, 2, 4, 5, 7, 9, 10}),
    LYDIAN("Lydian", new int[]{0, 2, 4, 6, 7, 9, 11}),
    PHRYGIAN("Phrygian", new int[]{0, 1, 3, 5, 7, 8, 10}),
    LOCRIAN("Locrian", new int[]{0, 1, 3, 5, 6, 8, 10}),
    WHOLE_TONE("Whole Tone", new int[]{0, 2, 4, 6, 8, 10}),
    HALF_WHOLE("Half-whole Dim.", new int[]{0, 1, 3, 4, 6, 7, 9, 10}),
    WHOLE_HALF("Whole-half Dim.", new int[]{0, 2, 3, 5, 6, 8, 9, 11}),
    MINOR_BLUES("Minor Blues", new int[]{0, 3, 5, 6, 7, 10}),
    MINOR_PENTATONIC("Minor Pentatonic", new int[]{0, 3, 5, 7, 10}),
    MAJOR_PENTATONIC("Major Pentatonic", new int[]{0, 2, 4, 7, 9}),
    HARMONIC_MINOR("Harmonic Minor", new int[]{0, 2, 3, 5, 7, 8, 11}),
    HARMONIC_MAJOR("Harmonic Major", new int[]{0, 2, 4, 5, 7, 8, 11}),
    DORIAN_NR_4("Dorian #4", new int[]{0, 2, 3, 6, 7, 9, 10}),
    PHRYGIAN_DOMINANT("Phrygian Dominant", new int[]{0, 1, 4, 5, 7, 8, 10}),
    MELODIC_MINOR("Melodic Minor", new int[]{0, 2, 3, 5, 7, 9, 11}),
    LYDIAN_AUGMENTED("Lydian Augmented", new int[]{0, 2, 4, 6, 8, 9, 11}),
    LYDIAN_DOMINANT("Lydian Dominant", new int[]{0, 2, 4, 6, 7, 9, 10}),
    SUPER_LOCRIAN("Super Locrian", new int[]{0, 1, 3, 4, 6, 8, 10}),
    SPANISH("Spanish", new int[]{0, 1, 4, 5, 7, 9, 10}),
    TONE8_SPANISH("8-Tone Spanish", new int[]{0, 1, 3, 4, 5, 6, 8, 10}),
    BHAIRAV("Bhairav", new int[]{0, 1, 4, 5, 7, 8, 11}),
    HUNGARIAN_MINOR("Hungarian Minor", new int[]{0, 2, 3, 6, 7, 8, 11}),
    HIROJOSHI("Hirojoshi", new int[]{0, 2, 3, 7, 8}),
    IN_SEN("In-Sen", new int[]{0, 1, 5, 7, 10}),
    IWATO("Iwato", new int[]{0, 1, 5, 6, 10}),
    KUMOI("Kumoi", new int[]{0, 2, 3, 7, 9}),
    PELOG("Pelog", new int[]{0, 1, 3, 4, 7, 8}),
    PELOG_SELISIR("Pelog Selisir", new int[]{0, 1, 3, 7, 8}),
    PELOG_TEMBUNG("Pelog Tembung", new int[]{0, 1, 5, 7, 8}),
    MESSIAEN_3("Messiaen 3", new int[]{0, 2, 3, 4, 6, 7, 8, 10, 11}),
    MESSIAEN_4("Messiaen 4", new int[]{0, 1, 2, 5, 6, 7, 8, 11}),
    MESSIAEN_5("Messiaen 5", new int[]{0, 1, 5, 6, 7, 11}),
    MESSIAEN_6("Messiaen 6", new int[]{0, 2, 4, 5, 6, 8, 10, 11}),
    MESSIAEN_7("Messiaen 7", new int[]{0, 1, 2, 3, 5, 6, 7, 8, 9, 11});

    private final String name;
    private final int[] intervals;
    private final Set<Integer> scaleKeys = new HashSet<Integer>(7);
    private final Map<Integer, Integer> indexInScale = new HashMap<Integer, Integer>(7);
    private static final String[] SCALE_NAMES;

    private Scale(String name, int[] intervals) {
        this.name = name;
        this.intervals = intervals;
        for (int i = 0; i < this.intervals.length; ++i) {
            Integer key = this.intervals[i];
            this.scaleKeys.add(key);
            this.indexInScale.put(key, i);
        }
    }

    public String getName() {
        return this.name;
    }

    public int[] getIntervals() {
        return this.intervals;
    }

    public boolean isInScale(int key) {
        return this.scaleKeys.contains(key);
    }

    public int getIndexInScale(int note) {
        Integer index = this.indexInScale.get(note % 12);
        return index == null ? -1 : index;
    }

    public static String[] getNames() {
        return SCALE_NAMES;
    }

    public static Scale getByName(String name) {
        for (Scale scale : Scale.values()) {
            if (!scale.getName().equals(name)) continue;
            return scale;
        }
        return null;
    }

    static {
        Scale[] values = Scale.values();
        SCALE_NAMES = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            Scale.SCALE_NAMES[i] = values[i].name;
        }
    }
}

