/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.controller.hardware;

import de.mossgrabers.framework.command.core.ContinuousCommand;
import de.mossgrabers.framework.command.core.PitchbendCommand;
import de.mossgrabers.framework.command.core.TriggerCommand;
import de.mossgrabers.framework.controller.hardware.AbstractHwInputControl;
import de.mossgrabers.framework.controller.hardware.IHwContinuousControl;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.utils.ButtonEvent;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;

public abstract class AbstractHwContinuousControl
extends AbstractHwInputControl
implements IHwContinuousControl {
    private static final int BUTTON_STATE_INTERVAL = 400;
    protected ContinuousCommand command;
    protected TriggerCommand touchCommand;
    protected PitchbendCommand pitchbendCommand;
    protected ButtonEvent state;
    protected IntSupplier supplier;
    protected IntConsumer consumer;
    protected int outputValue = -1;

    protected AbstractHwContinuousControl(IHost host, String label) {
        super(host, label);
    }

    @Override
    public void bind(ContinuousCommand command) {
        this.command = command;
    }

    @Override
    public void bind(PitchbendCommand command) {
        this.pitchbendCommand = command;
    }

    @Override
    public boolean isBound() {
        return this.command != null || this.touchCommand != null || this.pitchbendCommand != null;
    }

    @Override
    public ContinuousCommand getCommand() {
        return this.command;
    }

    @Override
    public TriggerCommand getTouchCommand() {
        return this.touchCommand;
    }

    @Override
    public PitchbendCommand getPitchbendCommand() {
        return this.pitchbendCommand;
    }

    @Override
    public void triggerTouch(boolean isDown) {
        if (this.touchCommand == null) {
            return;
        }
        this.host.scheduleTask(this::checkButtonState, 400L);
        this.state = isDown ? ButtonEvent.DOWN : ButtonEvent.UP;
        this.touchCommand.execute(this.state, isDown ? 127 : 0);
    }

    @Override
    public boolean isTouched() {
        return this.state == ButtonEvent.DOWN || this.state == ButtonEvent.LONG;
    }

    @Override
    public boolean isLongTouched() {
        return this.state == ButtonEvent.LONG;
    }

    @Override
    public void addOutput(IntSupplier supplier, IntConsumer consumer) {
        this.supplier = supplier;
        this.consumer = consumer;
    }

    @Override
    public void forceFlush() {
        this.outputValue = -1;
    }

    @Override
    public void turnOff() {
        this.supplier = null;
        this.outputValue = -1;
        if (this.consumer != null) {
            this.consumer.accept(0);
        }
    }

    @Override
    public void update() {
        if (this.supplier == null) {
            return;
        }
        int value = this.supplier.getAsInt();
        if (value == this.outputValue) {
            return;
        }
        this.outputValue = value;
        this.consumer.accept(this.outputValue);
    }

    private void checkButtonState() {
        if (!this.isTouched()) {
            return;
        }
        this.state = ButtonEvent.LONG;
        if (this.touchCommand != null) {
            this.touchCommand.execute(ButtonEvent.LONG, 127);
        }
    }
}

