/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.oxi.one.mode;

import de.mossgrabers.controller.oxi.one.OxiOneConfiguration;
import de.mossgrabers.controller.oxi.one.controller.OxiOneControlSurface;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.controller.display.IGraphicDisplay;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.clip.NotePosition;
import de.mossgrabers.framework.daw.data.IItem;
import de.mossgrabers.framework.graphics.canvas.component.simple.TitleValueMenuComponent;
import de.mossgrabers.framework.mode.AbstractNoteParameterMode;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.parameter.NoteAttribute;
import de.mossgrabers.framework.parameter.NoteParameter;
import de.mossgrabers.framework.parameterprovider.special.FixedParameterProvider;
import de.mossgrabers.framework.parameterprovider.special.FourKnobProvider;
import de.mossgrabers.framework.scale.Scales;
import java.util.List;

public class OxiOneNoteEditMode
extends AbstractNoteParameterMode<OxiOneControlSurface, OxiOneConfiguration, IItem> {
    protected static final List<ContinuousID> KNOB_IDS = ContinuousID.createSequentialList(ContinuousID.KNOB1, 4);
    private static final String[] MENU = new String[]{"Gain", "Pan", "Dura", "Vel"};
    private static final String[] SHIFTED_MENU = new String[]{"Press", "Timb", "Chnc", "VelS"};
    private int selectedIndex = 0;

    public OxiOneNoteEditMode(OxiOneControlSurface surface, IModel model) {
        super("Note Edit", surface, model, false, null, KNOB_IDS);
        IValueChanger valueChanger = model.getValueChanger();
        this.setParameterProvider(new FourKnobProvider(surface, new FixedParameterProvider(new NoteParameter(NoteAttribute.GAIN, null, model, this.noteEditor, valueChanger), new NoteParameter(NoteAttribute.PANNING, null, model, this.noteEditor, valueChanger), new NoteParameter(NoteAttribute.DURATION, null, model, this.noteEditor, valueChanger), new NoteParameter(NoteAttribute.VELOCITY, null, model, this.noteEditor, valueChanger), new NoteParameter(NoteAttribute.PRESSURE, null, model, this.noteEditor, valueChanger), new NoteParameter(NoteAttribute.TIMBRE, null, model, this.noteEditor, valueChanger), new NoteParameter(NoteAttribute.CHANCE, null, model, this.noteEditor, valueChanger), new NoteParameter(NoteAttribute.VELOCITY_SPREAD, null, model, this.noteEditor, valueChanger)), ButtonID.SHIFT));
    }

    @Override
    public void updateDisplay() {
        Object desc;
        this.updateMode();
        List<NotePosition> notes = this.noteEditor.getNotes();
        if (notes.isEmpty()) {
            desc = "Select a note";
        } else if (notes.size() > 1) {
            desc = notes.size() + " notes selected";
        } else {
            NotePosition notePosition = notes.get(0);
            desc = "Step: " + (notePosition.getStep() + 1) + " - " + Scales.formatNoteAndOctave(notePosition.getNote(), -3);
        }
        Object paramLine = "";
        int value = -1;
        IParameter parameter = this.getParameterProvider().get(this.selectedIndex % 4);
        if (parameter != null) {
            value = parameter.getValue();
            paramLine = parameter.getName() + ": " + parameter.getDisplayedValue();
        }
        IGraphicDisplay display = ((OxiOneControlSurface)this.surface).getGraphicsDisplay();
        display.addElement(new TitleValueMenuComponent((String)desc, (String)paramLine, ((OxiOneControlSurface)this.surface).isShiftPressed() ? SHIFTED_MENU : MENU, value, 0, 0, false));
        display.send();
    }

    @Override
    public void onKnobTouch(int index, boolean isTouched) {
        this.selectedIndex = ((OxiOneControlSurface)this.surface).isPressed(ButtonID.SHIFT) ? index + 4 : index;
    }

    private void updateMode() {
        if (((OxiOneControlSurface)this.surface).isShiftPressed()) {
            if (this.selectedIndex < 4) {
                this.selectedIndex += 4;
            }
        } else if (this.selectedIndex >= 4) {
            this.selectedIndex -= 4;
        }
    }
}

