/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.oxi.one.command.trigger;

import de.mossgrabers.controller.oxi.one.OxiOneConfiguration;
import de.mossgrabers.controller.oxi.one.controller.OxiOneControlSurface;
import de.mossgrabers.controller.oxi.one.mode.IOxiModeDisplay;
import de.mossgrabers.framework.command.trigger.mode.ModeMultiSelectCommand;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.featuregroup.IMode;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.utils.ButtonEvent;

public class OxiOneBackCommand
extends ModeMultiSelectCommand<OxiOneControlSurface, OxiOneConfiguration> {
    private boolean hasKnobBeenUsed = false;
    private final boolean isMk2;

    public OxiOneBackCommand(IModel model, OxiOneControlSurface surface, boolean isMk2) {
        super(model, surface, Modes.TRACK, Modes.DEVICE_LAYER, Modes.DEVICE_PARAMS);
        this.isMk2 = isMk2;
    }

    public void setHasKnobBeenUsed(boolean hasKnobBeenUsed) {
        this.hasKnobBeenUsed = hasKnobBeenUsed;
    }

    @Override
    public void execute(ButtonEvent event, int velocity) {
        if (((OxiOneControlSurface)this.surface).isShiftPressed()) {
            IMode active;
            if (event == ButtonEvent.DOWN && (active = (IMode)((OxiOneControlSurface)this.surface).getModeManager().getActive()) instanceof IOxiModeDisplay) {
                IOxiModeDisplay modeDisplay = (IOxiModeDisplay)((Object)active);
                modeDisplay.toggleDisplay();
            }
            return;
        }
        switch (event) {
            case DOWN: {
                ((OxiOneControlSurface)this.surface).setKnobSensitivityIsSlow(true);
                if (this.isMk2) break;
                this.hasKnobBeenUsed = false;
                break;
            }
            case UP: {
                ((OxiOneControlSurface)this.surface).setKnobSensitivityIsSlow(false);
                if (this.isMk2) break;
                if (this.hasKnobBeenUsed) {
                    this.hasKnobBeenUsed = false;
                    break;
                }
                ModeManager modeManager = ((OxiOneControlSurface)this.surface).getModeManager();
                if (modeManager.isTemporary()) {
                    modeManager.restore();
                    break;
                }
                this.switchMode(!((OxiOneControlSurface)this.surface).isShiftPressed(), event);
                break;
            }
        }
    }
}

