/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.oxi.one;

import de.mossgrabers.framework.controller.DefaultControllerDefinition;
import de.mossgrabers.framework.utils.OperatingSystem;
import de.mossgrabers.framework.utils.Pair;
import java.util.List;
import java.util.UUID;

public class OxiOneMk1ControllerDefinition
extends DefaultControllerDefinition {
    private static final UUID EXTENSION_ID = UUID.fromString("85593F1C-52FD-423F-BCAC-80D90EEB9ACA");

    public OxiOneMk1ControllerDefinition() {
        super(EXTENSION_ID, "One Mk1", "OXI", 1, 1);
    }

    @Override
    public List<Pair<String[], String[]>> getMidiDiscoveryPairs(OperatingSystem os) {
        List<Pair<String[], String[]>> midiDiscoveryPairs = super.getMidiDiscoveryPairs(os);
        switch (os) {
            case WINDOWS: {
                midiDiscoveryPairs.addAll(this.createDeviceDiscoveryPairs("OXI ONE"));
                break;
            }
            case LINUX: {
                midiDiscoveryPairs.add(this.addDeviceDiscoveryPair("OXI ONE MIDI 1", "OXI ONE MIDI 1"));
                midiDiscoveryPairs.addAll(this.createLinuxDeviceDiscoveryPairs("OXI ONE Jack 1", "OXI ONE Jack 1"));
                break;
            }
            case MAC: 
            case MAC_ARM: {
                midiDiscoveryPairs.add(this.addDeviceDiscoveryPair("OXI ONE Jack 1", "OXI ONE Jack 1"));
                midiDiscoveryPairs.add(this.addDeviceDiscoveryPair("OXI ONE Anschluss 1", "OXI ONE Anschluss 1"));
                break;
            }
        }
        return midiDiscoveryPairs;
    }
}

