/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.slmkiii.mode;

import de.mossgrabers.controller.novation.slmkiii.SLMkIIIConfiguration;
import de.mossgrabers.controller.novation.slmkiii.controller.SLMkIIIControlSurface;
import de.mossgrabers.controller.novation.slmkiii.controller.SLMkIIIDisplay;
import de.mossgrabers.controller.novation.slmkiii.mode.BaseMode;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.daw.clip.INoteClip;
import de.mossgrabers.framework.daw.data.IItem;
import de.mossgrabers.framework.daw.data.IMasterTrack;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.StringUtils;

public class OptionsMode
extends BaseMode<IItem> {
    public OptionsMode(SLMkIIIControlSurface surface, IModel model) {
        super("Options", surface, model);
    }

    @Override
    public void onKnobValue(int index, int value) {
        switch (index) {
            case 0: {
                this.model.getMasterTrack().changeVolume(value);
                break;
            }
            case 1: {
                this.model.getMasterTrack().changePan(value);
                break;
            }
            case 4: {
                this.model.getTransport().changeTempo(this.model.getValueChanger().isIncrease(value), ((SLMkIIIControlSurface)this.surface).isKnobSensitivitySlow());
                break;
            }
            case 5: {
                this.model.getTransport().changeMetronomeVolume(value);
                break;
            }
        }
    }

    @Override
    public int getKnobValue(int index) {
        ITransport transport = this.model.getTransport();
        IMasterTrack master = this.model.getMasterTrack();
        switch (index) {
            case 0: {
                return master.getVolume();
            }
            case 1: {
                return master.getPan();
            }
            case 4: {
                return (int)transport.scaleTempo(transport.getTempo(), this.model.getValueChanger().getUpperBound());
            }
            case 5: {
                return transport.getMetronomeVolume();
            }
        }
        return 0;
    }

    @Override
    public void onButton(int row, int index, ButtonEvent event) {
        if (event != ButtonEvent.UP) {
            return;
        }
        switch (index) {
            case 0: {
                this.model.getApplication().undo();
                break;
            }
            case 1: {
                this.model.getApplication().redo();
                break;
            }
            case 2: {
                this.model.getProject().previous();
                break;
            }
            case 3: {
                this.model.getProject().next();
                break;
            }
            case 4: {
                this.model.getTransport().tapTempo();
                break;
            }
            case 5: {
                this.model.getTransport().toggleMetronome();
                break;
            }
            case 6: {
                this.model.getApplication().toggleEngineActive();
                break;
            }
            case 7: {
                INoteClip clip = this.model.getCursorClip();
                if (!clip.doesExist()) break;
                clip.quantize((double)((SLMkIIIConfiguration)((SLMkIIIControlSurface)this.surface).getConfiguration()).getQuantizeAmount() / 100.0);
                break;
            }
        }
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        switch (buttonID) {
            case ROW1_6: {
                return this.model.getTransport().isMetronomeOn() ? 61 : 10;
            }
            case ROW1_7: {
                return this.model.getApplication().isEngineActive() ? 61 : 10;
            }
        }
        return 10;
    }

    @Override
    public void updateDisplay() {
        ITransport transport = this.model.getTransport();
        SLMkIIIDisplay d = ((SLMkIIIControlSurface)this.surface).getDisplay();
        d.clear();
        d.setCell(3, 0, "Undo");
        d.setPropertyColor(0, 2, 61);
        d.setPropertyValue(0, 1, 0);
        d.setCell(3, 1, "Redo");
        d.setPropertyColor(1, 2, 61);
        d.setPropertyValue(1, 1, 0);
        d.setCell(3, 2, "<<Project");
        d.setPropertyColor(2, 2, 61);
        d.setPropertyValue(2, 1, 0);
        d.setCell(3, 3, "Project>>");
        d.setPropertyColor(3, 2, 61);
        d.setPropertyValue(3, 1, 0);
        d.setCell(3, 4, "Tap");
        d.setPropertyColor(4, 2, 61);
        d.setPropertyValue(4, 1, 0);
        d.setCell(3, 5, transport.isMetronomeOn() ? "On" : "Off");
        d.setPropertyColor(5, 2, 61);
        d.setPropertyValue(5, 1, transport.isMetronomeOn() ? 1 : 0);
        d.setCell(3, 6, "Engine");
        d.setPropertyColor(6, 2, 61);
        d.setPropertyValue(6, 1, this.model.getApplication().isEngineActive() ? 1 : 0);
        d.setCell(3, 7, "Quantize");
        d.setPropertyColor(7, 2, 61);
        d.setPropertyValue(7, 1, 0);
        IMasterTrack master = this.model.getMasterTrack();
        d.setCell(0, 0, StringUtils.fixASCII("Mstr Vol")).setCell(1, 0, master.getVolumeStr(9));
        d.setPropertyColor(0, 0, 61);
        d.setPropertyColor(0, 1, 61);
        d.setCell(0, 1, StringUtils.fixASCII("Mstr Pan")).setCell(1, 1, master.getPanStr(9));
        d.setPropertyColor(1, 0, 61);
        d.setPropertyColor(1, 1, 61);
        d.setCell(0, 4, StringUtils.fixASCII("Tempo")).setCell(1, 4, transport.formatTempo(transport.getTempo()));
        d.setPropertyColor(4, 0, 61);
        d.setPropertyColor(4, 1, 61);
        d.setCell(0, 5, StringUtils.fixASCII("Metronome")).setCell(1, 5, transport.getMetronomeVolumeStr());
        d.setPropertyColor(5, 0, 61);
        d.setPropertyColor(5, 1, 61);
        d.setCell(0, 8, "Master");
        this.setButtonInfo(d);
        d.allDone();
    }

    @Override
    public int getModeColor() {
        return 61;
    }
}

