/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.maschine.jam.view;

import de.mossgrabers.controller.ni.maschine.core.command.trigger.EncoderMode;
import de.mossgrabers.controller.ni.maschine.core.view.IMaschineView;
import de.mossgrabers.controller.ni.maschine.jam.MaschineJamConfiguration;
import de.mossgrabers.controller.ni.maschine.jam.controller.MaschineJamControlSurface;
import de.mossgrabers.framework.controller.grid.IPadGrid;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.featuregroup.AbstractView;
import de.mossgrabers.framework.featuregroup.IView;
import de.mossgrabers.framework.featuregroup.ViewManager;
import de.mossgrabers.framework.view.Views;

public class AccentView
extends AbstractView<MaschineJamControlSurface, MaschineJamConfiguration>
implements IMaschineView {
    private static final int BLOCK_SIZE = 4;

    public AccentView(MaschineJamControlSurface surface, IModel model) {
        super("Accent", surface, model);
    }

    @Override
    public void drawGrid() {
        int i;
        IPadGrid padGrid = ((MaschineJamControlSurface)this.surface).getPadGrid();
        for (i = 36; i < 40; ++i) {
            padGrid.light(i, 0);
        }
        for (i = 44; i < 48; ++i) {
            padGrid.light(i, 0);
        }
        for (i = 52; i < 56; ++i) {
            padGrid.light(i, 0);
        }
        for (i = 60; i < 64; ++i) {
            padGrid.light(i, 0);
        }
        for (i = 68; i < 100; ++i) {
            padGrid.light(i, 0);
        }
        MaschineJamConfiguration configuration = (MaschineJamConfiguration)((MaschineJamControlSurface)this.surface).getConfiguration();
        int selectedPad = 15 - configuration.getFixedAccentValue() / 8;
        int selY = selectedPad / 4;
        int selX = selectedPad % 4;
        selectedPad = selY * 4 + 3 - selX;
        for (int pad = 0; pad < 16; ++pad) {
            int x = 4 + pad % 4;
            int y = 4 + pad / 4;
            padGrid.lightEx(x, y, pad == selectedPad ? 30 : 33);
        }
    }

    @Override
    public void onGridNote(int note, int velocity) {
        if (velocity == 0) {
            return;
        }
        int index = note - 36;
        int x = index % 8;
        int y = index / 8;
        if (x < 4 || y >= 4) {
            return;
        }
        int pad = (3 - y) * 4 + x - 4;
        int selPad = (3 - pad / 4) * 4 + pad % 4;
        ((MaschineJamConfiguration)((MaschineJamControlSurface)this.surface).getConfiguration()).setFixedAccentValue((selPad + 1) * 8 - 1);
    }

    @Override
    public void changeOption(EncoderMode temporaryEncoderMode, int control) {
        ViewManager viewManager = ((MaschineJamControlSurface)this.surface).getViewManager();
        Views activeID = (Views)((Object)viewManager.getActiveIDIgnoreTemporary());
        if (activeID == Views.CONTROL) {
            return;
        }
        IView view = (IView)viewManager.get(activeID);
        if (view instanceof IMaschineView) {
            IMaschineView maschineView = (IMaschineView)((Object)view);
            maschineView.changeOption(temporaryEncoderMode, control);
        }
    }

    @Override
    public boolean wasAlternateInteractionUsed() {
        return false;
    }

    @Override
    public void setAlternateInteractionUsed(boolean wasUsed) {
    }
}

