/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.mackie.mcu.mode.track;

import de.mossgrabers.controller.mackie.mcu.controller.MCUControlSurface;
import de.mossgrabers.controller.mackie.mcu.mode.track.AbstractTrackMode;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.parameterprovider.IParameterProvider;
import de.mossgrabers.framework.parameterprovider.special.RangeFilterParameterProvider;
import de.mossgrabers.framework.parameterprovider.track.SendParameterProvider;
import de.mossgrabers.framework.parameterprovider.track.VolumeParameterProvider;
import de.mossgrabers.framework.utils.StringUtils;

public class SendMode
extends AbstractTrackMode {
    private final int sendIndex;

    public SendMode(MCUControlSurface surface, IModel model, int sendIndex) {
        super("Sends", surface, model);
        IParameterProvider parameterProvider;
        this.sendIndex = sendIndex;
        if (this.pinFXtoLastDevice) {
            parameterProvider = new VolumeParameterProvider(model.getEffectTrackBank());
        } else {
            int surfaceID = surface.getSurfaceID();
            parameterProvider = new RangeFilterParameterProvider(new SendParameterProvider(model, sendIndex, 0), surfaceID * 8, 8);
        }
        this.setParameterProvider(parameterProvider);
    }

    @Override
    protected void drawTrackNameHeader() {
        ITrackBank tb = this.getTrackBank();
        int extenderOffset = this.getExtenderOffset();
        ITextDisplay d = ((MCUControlSurface)this.surface).getTextDisplay().clear();
        int textLength = this.getTextLength();
        for (int i = 0; i < 8; ++i) {
            ITrack t = (ITrack)tb.getItem(extenderOffset + i);
            if (!t.doesExist()) continue;
            String text = "S" + (this.sendIndex + 1) + ": ";
            d.setCell(0, i, text + StringUtils.shortenAndFixASCII(t.getName(), textLength - text.length()));
        }
        d.done(0);
    }

    @Override
    public void updateKnobLEDs() {
        if (this.model.isEffectTrackBankActive()) {
            ((MCUControlSurface)this.surface).getModeManager().setActive(Modes.TRACK);
            return;
        }
        super.updateKnobLEDs();
    }
}

