/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.mackie.mcu.controller;

import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.controller.color.ColorManager;

public class MCUColorManager
extends ColorManager {
    public MCUColorManager() {
        this.registerColorIndex("BUTTON_COLOR_OFF", 0);
        this.registerColorIndex("BUTTON_COLOR_ON", 0);
        this.registerColorIndex("BUTTON_COLOR_HI", 127);
        this.registerColorIndex("BUTTON_STATE_OFF", 0);
        this.registerColorIndex("BUTTON_STATE_ON", 0);
        this.registerColorIndex("BUTTON_STATE_HI", 127);
    }

    @Override
    public ColorEx getColor(int colorIndex, ButtonID buttonID) {
        if (colorIndex <= 0) {
            return ColorEx.BLACK;
        }
        if (buttonID == null) {
            return ColorEx.RED;
        }
        switch (buttonID) {
            case PLAY: {
                return ColorEx.GREEN;
            }
            case STOP: {
                return ColorEx.GRAY;
            }
            case RECORD: {
                return ColorEx.RED;
            }
            case LOOP: {
                return ColorEx.YELLOW;
            }
            case REWIND: 
            case FORWARD: 
            case ZOOM: {
                return ColorEx.BLUE;
            }
            case ROW3_1: 
            case ROW3_2: 
            case ROW3_3: 
            case ROW3_4: 
            case ROW3_5: 
            case ROW3_6: 
            case ROW3_7: 
            case ROW3_8: {
                return ColorEx.GREEN;
            }
            case ROW4_1: 
            case ROW4_2: 
            case ROW4_3: 
            case ROW4_4: 
            case ROW4_5: 
            case ROW4_6: 
            case ROW4_7: 
            case ROW4_8: {
                return ColorEx.BLUE;
            }
        }
        return ColorEx.RED;
    }
}

