/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.mode.configuration;

import de.mossgrabers.controller.ableton.push.PushConfiguration;
import de.mossgrabers.controller.ableton.push.PushVersion;
import de.mossgrabers.controller.ableton.push.controller.PushControlSurface;
import de.mossgrabers.controller.ableton.push.mode.BaseMode;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IItem;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.utils.ButtonEvent;

public abstract class AbstractConfigurationMode
extends BaseMode<IItem> {
    protected final String[] menu = new String[]{"Info", "Setup", "MPE", "Audio"};
    private final Modes[] modesPush2 = new Modes[]{Modes.INFO, Modes.SETUP};
    private final Modes[] modesPush3 = new Modes[]{Modes.INFO, Modes.SETUP, Modes.CONFIGURATION, Modes.AUDIO};
    private final Modes[] modes;
    private final int page;

    protected AbstractConfigurationMode(int page, String name, PushControlSurface surface, IModel model) {
        super(name, surface, model);
        this.page = page;
        if (((PushConfiguration)surface.getConfiguration()).getPushVersion() != PushVersion.VERSION_3) {
            this.menu[2] = " ";
            this.menu[3] = " ";
            this.modes = this.modesPush2;
        } else {
            this.modes = this.modesPush3;
        }
    }

    @Override
    public String getButtonColorID(ButtonID buttonID) {
        int index = this.isButtonRow(1, buttonID);
        if (index < 0 || index >= this.modes.length) {
            return "BUTTON_COLOR_OFF";
        }
        return index == this.page ? "BUTTON_COLOR_HI" : "BUTTON_COLOR_ON";
    }

    @Override
    public void onSecondRow(int index, ButtonEvent event) {
        if (event == ButtonEvent.UP && index >= 0 && index < this.modes.length) {
            ((PushControlSurface)this.surface).getModeManager().setTemporary(this.modes[index]);
        }
    }

    @Override
    public void updateDisplay1(ITextDisplay display) {
    }
}

