/*
 * Decompiled with CFR 0.152.
 */
package purejavahidapi.hidparser;

import java.util.LinkedList;
import purejavahidapi.hidparser.Collection;
import purejavahidapi.hidparser.Field;
import purejavahidapi.hidparser.HidParserTestData;
import purejavahidapi.hidparser.Report;

public class HidParser {
    public static final boolean TRACE = true;
    private Collection m_RootCollection;
    private Collection m_TopCollection;
    private LinkedList<Global> m_GlobalStack;
    private int m_DelemiterDepth;
    private int m_ParseIndex;
    private byte[] m_Descritor;
    private int m_DescritorLength;
    private Local m_Local;
    private Global m_Global;
    private LinkedList<Report> m_Reports;
    static final int HID_MAX_FIELDS = 256;
    private static final int HID_MAX_IDS = 256;
    private static final int HID_MAX_APPLICATIONS = 16;
    private static final int HID_MAX_USAGES = 12288;
    private static final int HID_INPUT_REPORT = 0;
    private static final int HID_OUTPUT_REPORT = 1;
    private static final int HID_FEATURE_REPORT = 2;
    private static final int HID_COLLECTION_PHYSICAL = 0;
    private static final int HID_COLLECTION_APPLICATION = 1;
    private static final int HID_COLLECTION_LOGICAL = 2;
    private static final int HID_MAIN_ITEM_CONSTANT = 1;
    private static final int HID_MAIN_ITEM_VARIABLE = 2;
    private static final int HID_MAIN_ITEM_RELATIVE = 4;
    private static final int HID_MAIN_ITEM_WRAP = 8;
    private static final int HID_MAIN_ITEM_NONLINEAR = 16;
    private static final int HID_MAIN_ITEM_NO_PREFERRED = 32;
    private static final int HID_MAIN_ITEM_NULL_STATE = 64;
    private static final int HID_MAIN_ITEM_VOLATILE = 128;
    private static final int HID_MAIN_ITEM_BUFFERED_BYTE = 256;
    private static final int HID_LONG_ITEM_PREFIX = 254;

    static void printf(String format, Object ... args) {
        System.out.printf(format, args);
    }

    private Report registerReport(int type, int id) {
        Report r2;
        for (Report r2 : this.m_Reports) {
            if (r2.m_Type != type || r2.m_Id != id) continue;
            return r2;
        }
        r2 = new Report(type, id, this.m_TopCollection);
        this.m_Reports.add(r2);
        return r2;
    }

    private Field registerField(Report report, int values) {
        if (report.m_MaxField == 256) {
            throw new IllegalStateException("too many fields in report");
        }
        Field field = new Field(this.m_TopCollection);
        report.m_Fields[report.m_MaxField++] = field;
        field.m_Report = report;
        return field;
    }

    private int lookUpCollection(int type) {
        Collection c = this.m_TopCollection;
        while (c.m_Parent != null) {
            if (c.m_Type == type) {
                return c.m_Usage;
            }
            c = c.m_Parent;
        }
        return 0;
    }

    private void addUsage(int usage) {
        if (this.m_Local.m_UsageIndex >= this.m_Local.m_Usages.length) {
            throw new IllegalStateException("usage index exceeded");
        }
        this.m_Local.m_Usages[this.m_Local.m_UsageIndex++] = usage;
    }

    private void addField(int reportType, int flags) {
        Report report = null;
        report = this.registerReport(reportType, this.m_Global.m_ReportId);
        if (report == null) {
            throw new IllegalStateException("failed to register report");
        }
        int j = 0;
        int i = 0;
        while (i < this.m_Global.m_ReportCount) {
            if (i < this.m_Local.m_UsageIndex) {
                j = i;
            }
            int offset = report.m_Size;
            report.m_Size += this.m_Global.m_ReportSize;
            Field field = this.registerField(report, this.m_Global.m_ReportCount);
            if (field == null) {
                throw new IllegalStateException("failed to register field");
            }
            field.m_Physical = this.lookUpCollection(0);
            field.m_Logical = this.lookUpCollection(2);
            field.m_Application = this.lookUpCollection(1);
            field.m_Usage = this.m_Local.m_Usages[j];
            field.m_Flags = flags;
            field.m_ReportOffset = offset;
            field.m_ReportType = reportType;
            field.m_ReportSize = this.m_Global.m_ReportSize;
            field.m_LogicalMinimum = this.m_Global.m_LogicalMinimum;
            field.m_LogicalMaximum = this.m_Global.m_LogicalMaximum;
            field.m_PhysicalMinimum = this.m_Global.m_PhysicalMinimum;
            field.m_PhysicalMaximum = this.m_Global.m_PhysicalMaximum;
            field.m_UnitExponent = this.m_Global.m_UnitExponent;
            field.m_Unit = this.m_Global.m_Unit;
            ++i;
        }
    }

    private void parseGlobalItem(Item item) {
        switch (item.m_GTag) {
            case PUSH: {
                this.m_GlobalStack.push((Global)this.m_Global.clone());
                break;
            }
            case POP: {
                if (this.m_GlobalStack.isEmpty()) {
                    throw new IllegalStateException("global enviroment stack underflow");
                }
                this.m_Global = this.m_GlobalStack.pop();
                break;
            }
            case USAGE_PAGE: {
                this.m_Global.m_UsagePage = item.m_UValue;
                break;
            }
            case LOGICAL_MINIMUM: {
                this.m_Global.m_LogicalMinimum = item.m_SValue;
                break;
            }
            case LOGICAL_MAXIMUM: {
                this.m_Global.m_LogicalMaximum = item.m_SValue;
                break;
            }
            case PHYSICAL_MINIMUM: {
                this.m_Global.m_PhysicalMinimum = item.m_SValue;
                break;
            }
            case PHYSICAL_MAXIMUM: {
                this.m_Global.m_PhysicalMaximum = item.m_SValue;
                System.out.println("m_Global.m_PhysicalMaximum " + this.m_Global.m_PhysicalMaximum);
                break;
            }
            case UNIT_EXPONENT: {
                this.m_Global.m_UnitExponent = item.m_SValue;
                break;
            }
            case UNIT: {
                this.m_Global.m_Unit = item.m_UValue;
                break;
            }
            case REPORT_SIZE: {
                if (item.m_UValue < 0 || item.m_UValue > 32) {
                    throw new IllegalStateException(String.format("invalid report size %d", item.m_UValue));
                }
                this.m_Global.m_ReportSize = item.m_UValue;
                break;
            }
            case REPORT_COUNT: {
                if (item.m_UValue < 0 || item.m_UValue > 12288) {
                    throw new IllegalStateException(String.format("invalid report count %d", item.m_UValue));
                }
                this.m_Global.m_ReportCount = item.m_UValue;
                break;
            }
            case REPORT_ID: {
                if (item.m_UValue == 0) {
                    throw new IllegalStateException("report_id 0 is invalid");
                }
                this.m_Global.m_ReportId = item.m_UValue;
                break;
            }
            default: {
                throw new IllegalStateException("unsupported global tag");
            }
        }
    }

    private void parseMainItem(Item item) {
        switch (item.m_MTag) {
            case COLLECTION: {
                this.m_TopCollection = new Collection(this.m_TopCollection, this.m_Local.m_Usages[0], item.m_UValue & 3);
                break;
            }
            case ENDCOLLECTION: {
                if (this.m_TopCollection.m_Parent == null) {
                    throw new IllegalStateException("collection stack underflow");
                }
                this.m_TopCollection = this.m_TopCollection.m_Parent;
                this.m_Local.reset();
                break;
            }
            case INPUT: {
                this.addField(0, item.m_UValue);
                this.m_Local.reset();
                break;
            }
            case OUTPUT: {
                this.addField(1, item.m_UValue);
                this.m_Local.reset();
                break;
            }
            case FEATURE: {
                this.addField(2, item.m_UValue);
                this.m_Local.reset();
                break;
            }
            default: {
                throw new IllegalStateException("unsupported main tag");
            }
        }
    }

    private void parseLocalItem(Item item) {
        if (item.m_Size == 0) {
            throw new IllegalStateException("item data expected for local item");
        }
        int usage = item.m_UValue;
        if (item.m_Size <= 2) {
            usage = (this.m_Global.m_UsagePage << 16) + usage;
        }
        switch (item.m_LTag) {
            case DELIMITER: {
                if (item.m_UValue > 0) {
                    if (this.m_Local.m_DelimiterDepth != 0) {
                        throw new IllegalStateException("nested delimiters");
                    }
                    ++this.m_Local.m_DelimiterDepth;
                    ++this.m_Local.m_DelimiterBranch;
                    break;
                }
                if (this.m_Local.m_DelimiterDepth < 1) {
                    throw new IllegalStateException("extra delimiters");
                }
                --this.m_Local.m_DelimiterDepth;
                break;
            }
            case USAGE: {
                if (this.m_Local.m_DelimiterBranch > 1) break;
                this.addUsage(usage);
                break;
            }
            case USAGE_MINIMUM: {
                if (this.m_Local.m_DelimiterDepth <= 1) break;
                this.m_Local.m_UsageMinimum = usage;
                break;
            }
            case USAGE_MAXIMUM: {
                if (this.m_Local.m_DelimiterBranch <= 1) break;
                int n = this.m_Local.m_UsageMinimum;
                while (n <= item.m_UValue) {
                    this.addUsage(n);
                    ++n;
                }
                break;
            }
            case DESIGNATOR_INDEX: {
                break;
            }
            case DESIGNATOR_MAXIMUM: {
                break;
            }
            case DESIGNATOR_MINIMUM: {
                break;
            }
            case STRING_INDEX: {
                break;
            }
            case STRING_MAXIMUM: {
                break;
            }
            case STRING_MINIMUM: {
                break;
            }
            default: {
                throw new IllegalStateException("unsupported local tag");
            }
        }
    }

    private Item getNextItem() {
        int preb;
        if (this.m_ParseIndex >= this.m_DescritorLength) {
            return null;
        }
        Item item = null;
        int at = this.m_ParseIndex;
        if ((preb = this.m_Descritor[this.m_ParseIndex++] & 0xFF) == 254) {
            if (this.m_ParseIndex >= this.m_DescritorLength) {
                throw new IllegalStateException("unexpected end of data white fetching long item size");
            }
            int size = this.m_Descritor[this.m_ParseIndex++] & 0xFF;
            if (this.m_ParseIndex >= this.m_DescritorLength) {
                throw new IllegalStateException("unexpected end of data white fetching long item tag");
            }
            int tag = this.m_Descritor[this.m_ParseIndex++] & 0xFF;
            if (this.m_ParseIndex + size - 1 >= this.m_DescritorLength) {
                throw new IllegalStateException("unexpected end of data white fetching long item");
            }
            this.m_ParseIndex += size;
            item = new Item(size, ItemType.LONG, tag, 0);
        } else {
            int type = preb >> 2 & 3;
            int tag = preb >> 4 & 0xF;
            int size = preb & 3;
            int value = 0;
            switch (size) {
                case 0: {
                    break;
                }
                case 1: {
                    if (this.m_ParseIndex >= this.m_DescritorLength) {
                        throw new IllegalStateException("unexpected end of data white fetching item size==1");
                    }
                    value = this.m_Descritor[this.m_ParseIndex++] & 0xFF;
                    break;
                }
                case 2: {
                    if (this.m_ParseIndex + 1 >= this.m_DescritorLength) {
                        throw new IllegalStateException("unexpected end of data white fetching item size==1");
                    }
                    value = this.m_Descritor[this.m_ParseIndex++] & 0xFF | (this.m_Descritor[this.m_ParseIndex++] & 0xFF) << 8;
                    break;
                }
                case 3: {
                    ++size;
                    if (this.m_ParseIndex + 1 >= this.m_DescritorLength) {
                        throw new IllegalStateException("unexpected end of data white fetching item size==1");
                    }
                    value = this.m_Descritor[this.m_ParseIndex++] & 0xFF | (this.m_Descritor[this.m_ParseIndex++] & 0xFF) << 8 | (this.m_Descritor[this.m_ParseIndex++] & 0xFF) << 16 | this.m_Descritor[this.m_ParseIndex++] << 24;
                }
            }
            if (type < 0 || type >= ItemType.values().length) {
                throw new IllegalStateException(String.format("illegal/unsupported type %d", type));
            }
            item = new Item(size, ItemType.values()[type], tag, value);
        }
        String tags = "?";
        if (item.m_GTag != null) {
            tags = item.m_GTag.toString();
        }
        if (item.m_MTag != null) {
            tags = item.m_MTag.toString();
        }
        if (item.m_LTag != null) {
            tags = item.m_LTag.toString();
        }
        HidParser.printf("[%3d] = 0x%02X:  size %d  type %-8s  tag %-20s  value 0x%08X (%d)\n", new Object[]{at, preb, item.m_Size, item.m_Type, tags, item.m_SValue, item.m_SValue});
        return item;
    }

    private void resetParser() {
        this.m_TopCollection = this.m_RootCollection = new Collection(null, 0, 0);
        this.m_GlobalStack = new LinkedList();
        this.m_DelemiterDepth = 0;
        this.m_ParseIndex = 0;
        this.m_Descritor = null;
        this.m_DescritorLength = 0;
        this.m_Local = new Local();
        this.m_Global = new Global();
        this.m_Reports = new LinkedList();
    }

    public void dump(String tab) {
        for (Report r : this.m_Reports) {
            r.dump(tab);
        }
    }

    public void parse(byte[] descriptor, int length) {
        Item item;
        this.resetParser();
        this.m_Descritor = descriptor;
        this.m_DescritorLength = length;
        while ((item = this.getNextItem()) != null) {
            switch (item.m_Type) {
                case MAIN: {
                    this.parseMainItem(item);
                    break;
                }
                case LOCAL: {
                    this.parseLocalItem(item);
                    break;
                }
                case GLOBAL: {
                    this.parseGlobalItem(item);
                    break;
                }
                case LONG: {
                    throw new IllegalStateException("unexpected long global item");
                }
                default: {
                    throw new IllegalStateException("unknown global item type (bug)");
                }
            }
        }
        if (this.m_TopCollection.m_Parent != null) {
            throw new IllegalStateException("unbalanced collection at end of report description");
        }
        if (this.m_DelemiterDepth > 0) {
            throw new IllegalStateException("unbalanced delimiter at end of report description");
        }
        this.m_RootCollection.dump("");
    }

    public static void main(String ... args) {
        try {
            int[] testData = HidParserTestData.cheapGamepad;
            byte[] descriptor = new byte[testData.length];
            int i = 0;
            while (i < descriptor.length) {
                descriptor[i] = (byte)testData[i];
                ++i;
            }
            HidParser parser = new HidParser();
            parser.parse(descriptor, descriptor.length);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final class Global {
        int m_UsagePage;
        int m_LogicalMinimum;
        int m_LogicalMaximum;
        int m_PhysicalMinimum;
        int m_PhysicalMaximum;
        int m_UnitExponent;
        int m_Unit;
        int m_ReportId;
        int m_ReportSize;
        int m_ReportCount;

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
                return 0;
            }
        }
    }

    static enum GlobalTag {
        USAGE_PAGE,
        LOGICAL_MINIMUM,
        LOGICAL_MAXIMUM,
        PHYSICAL_MINIMUM,
        PHYSICAL_MAXIMUM,
        UNIT_EXPONENT,
        UNIT,
        REPORT_SIZE,
        REPORT_ID,
        REPORT_COUNT,
        PUSH,
        POP;

    }

    public static final class Item {
        int m_Size;
        ItemType m_Type;
        MainTag m_MTag;
        GlobalTag m_GTag;
        LocalTag m_LTag;
        int m_UValue;
        int m_SValue;

        public Item(int size, ItemType type, int tag, int value) {
            this.m_Size = size;
            this.m_Type = type;
            if (this.m_Type == ItemType.MAIN) {
                if (tag < 8 || tag >= MainTag.values().length) {
                    throw new IllegalStateException(String.format("illegal/unsupported main tag %d", tag));
                }
                this.m_MTag = MainTag.values()[tag];
            }
            if (this.m_Type == ItemType.GLOBAL) {
                if (tag < 0 || tag >= GlobalTag.values().length) {
                    throw new IllegalStateException(String.format("illegal/unsupported global tag %d", tag));
                }
                this.m_GTag = GlobalTag.values()[tag];
            }
            if (this.m_Type == ItemType.LOCAL) {
                if (tag < 0 || tag >= LocalTag.values().length) {
                    throw new IllegalStateException(String.format("illegal/unsupported local tag %d", tag));
                }
                this.m_LTag = LocalTag.values()[tag];
            }
            this.m_UValue = value;
            this.m_SValue = value;
            switch (size) {
                case 1: {
                    if ((value & 0xFFFFFF80) == 0) break;
                    this.m_SValue |= 0xFFFFFF00;
                    break;
                }
                case 2: {
                    if ((value & Short.MIN_VALUE) == 0) break;
                    this.m_SValue |= 0xFFFF0000;
                    break;
                }
            }
        }
    }

    static enum ItemType {
        MAIN,
        GLOBAL,
        LOCAL,
        RESERVED,
        LONG;

    }

    private static final class Local {
        public int[] m_Usages = new int[12288];
        public int[] m_CollectionIndex = new int[12288];
        public int m_UsageIndex;
        public int m_UsageMinimum;
        public int m_DelimiterDepth;
        public int m_DelimiterBranch;

        private Local() {
        }

        public void reset() {
            this.m_UsageIndex = 0;
            this.m_UsageMinimum = 0;
            this.m_DelimiterDepth = 0;
            this.m_DelimiterBranch = 0;
            int i = 0;
            while (i < this.m_Usages.length) {
                this.m_Usages[i] = 0;
                ++i;
            }
            i = 0;
            while (i < this.m_CollectionIndex.length) {
                this.m_CollectionIndex[i] = 0;
                ++i;
            }
        }
    }

    static enum LocalTag {
        USAGE,
        USAGE_MINIMUM,
        USAGE_MAXIMUM,
        DESIGNATOR_INDEX,
        DESIGNATOR_MINIMUM,
        DESIGNATOR_MAXIMUM,
        STRING_INDEX,
        STRING_MINIMUM,
        STRING_MAXIMUM,
        DELIMITER;

    }

    static enum MainTag {
        PADDING_0,
        PADDING_1,
        PADDING_2,
        PADDING_3,
        PADDING_4,
        PADDING_5,
        PADDING_6,
        PADDING_7,
        INPUT,
        OUTPUT,
        COLLECTION,
        FEATURE,
        ENDCOLLECTION;

    }
}

