/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.midi;

import de.mossgrabers.framework.daw.midi.AbstractMidiOutput;
import de.mossgrabers.framework.utils.FrameworkException;
import de.mossgrabers.reaper.framework.midi.MidiConnection;

class MidiOutputImpl
extends AbstractMidiOutput {
    private final MidiConnection midiConnection;

    public MidiOutputImpl(MidiConnection midiConnection) {
        this.midiConnection = midiConnection;
    }

    @Override
    public void sendSysex(String data) {
        String[] parts = data.split(" ");
        byte[] bytes = new byte[parts.length];
        try {
            for (int i = 0; i < parts.length; ++i) {
                bytes[i] = (byte)Integer.parseInt(parts[i], 16);
            }
        }
        catch (NumberFormatException ex) {
            throw new FrameworkException(String.format("Broken Sysex string: '%s'", data), ex);
        }
        this.sendSysex(new byte[][]{bytes});
    }

    @Override
    public void sendSysex(byte[] ... data) {
        this.midiConnection.sendSysex(MidiOutputImpl.concatArrays(data));
    }

    @Override
    protected void sendMidiShort(int status, int data1, int data2) {
        this.midiConnection.sendRaw(status, data1, data2);
    }
}

