/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.hardware;

import de.mossgrabers.framework.command.core.TriggerCommand;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.controller.hardware.BindType;
import de.mossgrabers.framework.controller.hardware.IHwFader;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.graphics.IGraphicsContext;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.reaper.framework.daw.data.parameter.IParameterEx;
import de.mossgrabers.reaper.framework.hardware.AbstractHwAbsoluteControl;
import de.mossgrabers.reaper.framework.hardware.Bounds;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.ShortMessage;

public class HwFaderImpl
extends AbstractHwAbsoluteControl
implements IHwFader {
    private final boolean isVertical;

    public HwFaderImpl(String id, IHost host, String label, boolean isVertical) {
        super(id, host, label);
        this.isVertical = isVertical;
    }

    @Override
    public void bindTouch(TriggerCommand command, IMidiInput input, BindType type, int channel, int control) {
        this.touchCommand = command;
        input.bindTouch(this, type, channel, control);
    }

    @Override
    public void draw(IGraphicsContext gc, double scale) {
        double factor;
        Bounds bounds = this.layout.getBounds();
        if (bounds == null) {
            return;
        }
        double left = bounds.x() * scale;
        double top = bounds.y() * scale;
        double width = bounds.width() * scale;
        double height = bounds.height() * scale;
        gc.fillRectangle(left, top, width, height, ColorEx.BLACK);
        double d = factor = this.type == null || this.type == BindType.CC ? 127.0 : 16383.0;
        if (this.isVertical) {
            double scaledHeight = height / factor * (double)this.currentValue;
            gc.fillRectangle(left, top + height - scaledHeight, width, scaledHeight, ColorEx.WHITE);
            IParameter iParameter = this.parameter;
            if (iParameter instanceof IParameterEx) {
                IParameterEx pi = (IParameterEx)iParameter;
                double paramValue = pi.getInternalValue();
                double valueHeight = height * paramValue;
                gc.fillRectangle(left + 1.0, top + height - valueHeight, width - 2.0, 2.0, ColorEx.RED);
            }
        } else {
            double scaledWidth = width / factor * (double)this.currentValue;
            gc.fillRectangle(left, top, scaledWidth, height, ColorEx.WHITE);
            IParameter paramValue = this.parameter;
            if (paramValue instanceof IParameterEx) {
                IParameterEx pi = (IParameterEx)paramValue;
                double paramValue2 = pi.getInternalValue();
                double valueWidth = width * paramValue2;
                gc.fillRectangle(left + width - valueWidth, top + 1.0, 2.0, height - 2.0, ColorEx.RED);
            }
        }
    }

    @Override
    public void mouse(int mouseEvent, double x, double y, double scale) {
        Bounds bounds = this.layout.getBounds();
        if (bounds == null) {
            return;
        }
        double scaleX = x / scale;
        double scaleY = y / scale;
        if (mouseEvent == 501 && bounds.contains(scaleX, scaleY)) {
            this.isPressed = true;
            return;
        }
        if (!this.isPressed) {
            return;
        }
        if (mouseEvent == 502) {
            this.isPressed = false;
            return;
        }
        try {
            if (mouseEvent == 506) {
                double value = this.isVertical ? 1.0 - (scaleY - bounds.y()) / bounds.height() : (scaleX - bounds.x()) / bounds.width();
                value = Math.max(0.0, Math.min(1.0, value));
                if (this.inputImpl == null) {
                    if (this.command != null) {
                        this.currentValue = (int)Math.max(0L, Math.round(value * 127.0));
                        this.command.execute(this.currentValue);
                    } else if (this.pitchbendCommand != null) {
                        this.currentValue = (int)Math.max(0L, Math.round(value * 16383.0));
                        int data1 = (int)Math.min(127L, Math.round((double)this.currentValue % 128.0));
                        int data2 = (int)Math.min(127L, Math.round((double)this.currentValue / 128.0));
                        this.pitchbendCommand.onPitchbend(data1, data2);
                    }
                    return;
                }
                if (this.type == BindType.CC) {
                    this.currentValue = (int)Math.max(0L, Math.round(value * 127.0));
                    this.inputImpl.handleMidiMessage(new ShortMessage(176, this.channel, this.control, this.currentValue));
                } else if (this.type == BindType.PITCHBEND) {
                    this.currentValue = (int)Math.max(0L, Math.round(value * 16383.0));
                    int data1 = (int)Math.min(127L, Math.round((double)this.currentValue % 128.0));
                    int data2 = (int)Math.min(127L, Math.round((double)this.currentValue / 128.0));
                    this.inputImpl.handleMidiMessage(new ShortMessage(224, this.channel, data1, data2));
                }
            }
        }
        catch (InvalidMidiDataException ex) {
            this.host.error("Invalid MIDI message.", ex);
        }
    }
}

