/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.graphics;

import de.mossgrabers.framework.graphics.IBitmap;
import de.mossgrabers.framework.graphics.IEncoder;
import de.mossgrabers.framework.graphics.IRenderer;
import de.mossgrabers.reaper.framework.graphics.GraphicsContextImpl;
import de.mossgrabers.reaper.ui.WindowManager;
import de.mossgrabers.reaper.ui.dialog.BasicDialog;
import de.mossgrabers.reaper.ui.widget.BoxPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.nio.ByteBuffer;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.Timer;

public class BitmapImpl
implements IBitmap {
    private final WindowManager windowManager;
    private final BufferedImage bufferedImage;
    private final ByteBuffer imageBuffer;
    private final Object windowLock = new Object();
    private BitmapWindow window;
    private String windowTitle = "";

    public BitmapImpl(WindowManager windowManager, int width, int height) {
        this.windowManager = windowManager;
        this.bufferedImage = new BufferedImage(width, height, 2);
        this.imageBuffer = ByteBuffer.allocateDirect(width * height * 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encode(IEncoder encoder) {
        BufferedImage bufferedImage = this.bufferedImage;
        synchronized (bufferedImage) {
            this.imageBuffer.clear();
            WritableRaster raster = this.bufferedImage.getRaster();
            int[] pixel = new int[4];
            int h = this.bufferedImage.getHeight();
            int w = this.bufferedImage.getWidth();
            for (int y = 0; y < h; ++y) {
                for (int x = 0; x < w; ++x) {
                    raster.getPixel(x, y, pixel);
                    this.imageBuffer.put((byte)pixel[2]);
                    this.imageBuffer.put((byte)pixel[1]);
                    this.imageBuffer.put((byte)pixel[0]);
                    this.imageBuffer.put((byte)0);
                }
            }
            this.imageBuffer.rewind();
            encoder.encode(this.imageBuffer, w, h);
        }
    }

    @Override
    public void setDisplayWindowTitle(String title) {
        this.windowTitle = title;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void showDisplayWindow() {
        Object object = this.windowLock;
        synchronized (object) {
            if (this.window == null) {
                this.window = new BitmapWindow(this.windowManager.getMainFrame());
            }
        }
        this.window.setTitle(this.windowTitle);
        this.window.showWindow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(boolean enableAntialias, IRenderer renderer) {
        BufferedImage bufferedImage = this.bufferedImage;
        synchronized (bufferedImage) {
            renderer.render(new GraphicsContextImpl(this.bufferedImage.createGraphics(), "SansSerif", enableAntialias));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawScaledImage(Graphics gc, int x, int y, int width, int height) {
        BufferedImage bufferedImage = this.bufferedImage;
        synchronized (bufferedImage) {
            gc.drawImage(this.bufferedImage, x, y, width, height, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawImage(Graphics gc) {
        BufferedImage bufferedImage = this.bufferedImage;
        synchronized (bufferedImage) {
            gc.drawImage(this.bufferedImage, 0, 0, this.bufferedImage.getWidth(), this.bufferedImage.getHeight(), null);
        }
    }

    private class BitmapWindow
    extends BasicDialog {
        private static final int BITMAP_REDRAW_RATE = 200;
        private static final long serialVersionUID = -6034592629355700876L;
        private final Timer animationTimer;
        private final JPanel canvas;

        public BitmapWindow(JFrame owner) {
            super(owner, "", true, false);
            this.canvas = new JPanel(){
                private static final long serialVersionUID = 971155807100338380L;

                @Override
                public void paintComponent(Graphics gc) {
                    super.paintComponent(gc);
                    BitmapImpl.this.drawImage(gc);
                }
            };
            this.animationTimer = new Timer(200, event -> this.canvas.repaint());
            this.canvas.setPreferredSize(new Dimension(BitmapImpl.this.bufferedImage.getWidth(), BitmapImpl.this.bufferedImage.getHeight()));
            this.basicInit();
        }

        @Override
        protected Container init() {
            JPanel contentPane = new JPanel(new BorderLayout());
            contentPane.add((Component)this.canvas, "Center");
            BoxPanel buttons = new BoxPanel(0, true);
            buttons.createSpace(-1);
            this.setButtons(null, buttons.createButton("Close", null, 0));
            contentPane.add((Component)buttons, "South");
            return contentPane;
        }

        public void showWindow() {
            if (this.isShowing()) {
                return;
            }
            this.animationTimer.start();
            this.setVisible(true);
            this.animationTimer.stop();
        }
    }
}

