/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.utils;

public class NoteGenerator {
    public static boolean[] generateEuclideanPattern(int pulse, int length, int rotation, double density) {
        if (length <= 0) {
            throw new IllegalArgumentException("Length must be > 0");
        }
        if (pulse < 0 || pulse > length) {
            throw new IllegalArgumentException("Pulse must be in range [0, Length]");
        }
        if (density < 0.0 || density > 1.0) {
            throw new IllegalArgumentException("Density must be in range [0.0, 1.0]");
        }
        int effectivePulses = (int)Math.floor((double)pulse * density);
        if (effectivePulses == 0) {
            return new boolean[length];
        }
        final int[] pattern = new int[length];
        final int[] counts = new int[length];
        final int[] remainders = new int[length];
        int divisor = length - effectivePulses;
        remainders[0] = effectivePulses;
        int level = 0;
        do {
            counts[level] = divisor / remainders[level];
            remainders[level + 1] = divisor % remainders[level];
            divisor = remainders[level];
        } while (remainders[++level] > 1);
        counts[level] = divisor;
        class Builder {
            int index = 0;

            Builder() {
            }

            void build(int lvl) {
                if (lvl == -1) {
                    pattern[this.index++] = 0;
                } else if (lvl == -2) {
                    pattern[this.index++] = 1;
                } else {
                    for (int i = 0; i < counts[lvl]; ++i) {
                        this.build(lvl - 1);
                    }
                    if (remainders[lvl] != 0) {
                        this.build(lvl - 2);
                    }
                }
            }
        }
        new Builder().build(level);
        boolean[] result = new boolean[length];
        for (int i = 0; i < length; ++i) {
            result[i] = pattern[i] == 1;
        }
        boolean[] rotated = new boolean[length];
        int r = ((rotation + 1) % length + length) % length;
        for (int i = 0; i < length; ++i) {
            rotated[(i + r) % length] = result[i];
        }
        return rotated;
    }
}

