/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.parameterprovider.track;

import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.observer.IBankPageObserver;
import de.mossgrabers.framework.observer.IParametersAdjustObserver;
import de.mossgrabers.framework.observer.IValueObserver;
import de.mossgrabers.framework.parameterprovider.AbstractParameterProvider;
import java.util.Optional;

public abstract class AbstractTrackParameterProvider
extends AbstractParameterProvider
implements IBankPageObserver,
IValueObserver<ITrackBank> {
    protected final IModel model;
    protected ITrackBank bank;

    protected AbstractTrackParameterProvider(ITrackBank bank) {
        this(null, bank);
    }

    protected AbstractTrackParameterProvider(IModel model) {
        this(model, model.getCurrentTrackBank());
    }

    private AbstractTrackParameterProvider(IModel model, ITrackBank bank) {
        this.bank = bank;
        this.model = model;
        if (this.model != null) {
            this.model.addTrackBankObserver(this);
        }
    }

    @Override
    public int size() {
        return this.bank.getPageSize();
    }

    @Override
    public void addParametersObserver(IParametersAdjustObserver observer) {
        super.addParametersObserver(observer);
        if (this.model == null) {
            this.bank.addPageObserver(this);
            return;
        }
        this.model.getTrackBank().addPageObserver(this);
        ITrackBank effectTrackBank = this.model.getEffectTrackBank();
        if (effectTrackBank != null) {
            effectTrackBank.addPageObserver(this);
        }
    }

    @Override
    public void removeParametersObserver(IParametersAdjustObserver observer) {
        super.removeParametersObserver(observer);
        if (this.hasObservers()) {
            return;
        }
        if (this.model == null) {
            this.bank.removePageObserver(this);
            return;
        }
        this.model.getTrackBank().removePageObserver(this);
        ITrackBank effectTrackBank = this.model.getEffectTrackBank();
        if (effectTrackBank != null) {
            effectTrackBank.removePageObserver(this);
        }
    }

    @Override
    public void pageAdjusted() {
        this.notifyParametersObservers();
    }

    @Override
    public void update(ITrackBank bank) {
        this.bank = bank;
        this.notifyParametersObservers();
    }

    @Override
    public Optional<ColorEx> getColor(int index) {
        return Optional.of(((ITrack)this.bank.getItem(index)).getColor());
    }
}

