/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.controller.hardware;

import de.mossgrabers.framework.command.core.TriggerCommand;
import de.mossgrabers.framework.controller.hardware.AbstractHwInputControl;
import de.mossgrabers.framework.controller.hardware.ButtonEventHandler;
import de.mossgrabers.framework.controller.hardware.IHwButton;
import de.mossgrabers.framework.controller.hardware.IHwLight;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.TimeoutOptimizer;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractHwButton
extends AbstractHwInputControl
implements IHwButton {
    private static final int BUTTON_STATE_INTERVAL = 300;
    private final TimeoutOptimizer optimizer;
    protected TriggerCommand command;
    protected IHwLight light;
    private ButtonEvent state;
    private boolean isConsumed;
    private int pressedVelocity = 0;
    private final List<ButtonEventHandler> downEventHandlers = new ArrayList<ButtonEventHandler>();
    private final List<ButtonEventHandler> upEventHandlers = new ArrayList<ButtonEventHandler>();

    protected AbstractHwButton(IHost host, String label) {
        super(host, label);
        this.optimizer = new TimeoutOptimizer(host, 300);
    }

    @Override
    public boolean isBound() {
        return this.command != null;
    }

    @Override
    public void clearState() {
        this.state = null;
    }

    protected void handleButtonPressed(double value) {
        if (value == 0.0) {
            return;
        }
        this.state = ButtonEvent.DOWN;
        this.isConsumed = false;
        this.host.scheduleTask(this::checkButtonState, this.optimizer.getTimeout());
        this.pressedVelocity = (int)(value * 127.0);
        if (this.command != null) {
            this.command.execute(ButtonEvent.DOWN, this.pressedVelocity);
        }
        this.downEventHandlers.forEach(handler -> handler.handle(ButtonEvent.DOWN));
    }

    protected void handleButtonRelease() {
        if (!this.isBound()) {
            return;
        }
        this.state = ButtonEvent.UP;
        if (this.command != null && !this.isConsumed) {
            this.command.execute(ButtonEvent.UP, 0);
        }
        this.upEventHandlers.forEach(handler -> handler.handle(ButtonEvent.UP));
    }

    @Override
    public void addLight(IHwLight light) {
        this.light = light;
    }

    @Override
    public IHwLight getLight() {
        return this.light;
    }

    @Override
    public boolean isPressed() {
        return this.state == ButtonEvent.DOWN || this.state == ButtonEvent.LONG;
    }

    @Override
    public boolean isLongPressed() {
        return this.state == ButtonEvent.LONG;
    }

    @Override
    public void addEventHandler(ButtonEvent event, ButtonEventHandler eventHandler) {
        if (event == ButtonEvent.DOWN) {
            this.downEventHandlers.add(eventHandler);
        } else if (event == ButtonEvent.UP) {
            this.upEventHandlers.add(eventHandler);
        }
    }

    @Override
    public void removeEventHandler(ButtonEvent event, ButtonEventHandler eventHandler) {
        if (event == ButtonEvent.DOWN) {
            this.downEventHandlers.remove(eventHandler);
        } else if (event == ButtonEvent.UP) {
            this.upEventHandlers.remove(eventHandler);
        }
    }

    @Override
    public void setConsumed() {
        this.isConsumed = true;
    }

    @Override
    public boolean isConsumed() {
        return this.isConsumed;
    }

    @Override
    public void trigger() {
        this.trigger(ButtonEvent.DOWN);
        this.trigger(ButtonEvent.UP);
    }

    @Override
    public void trigger(ButtonEvent event) {
        this.trigger(event, 1.0);
    }

    @Override
    public void trigger(ButtonEvent event, double velocity) {
        if (event == ButtonEvent.DOWN) {
            this.handleButtonPressed(velocity);
        } else if (event == ButtonEvent.UP) {
            this.handleButtonRelease();
        }
    }

    @Override
    public int getPressedVelocity() {
        return this.pressedVelocity;
    }

    @Override
    public TriggerCommand getCommand() {
        return this.command;
    }

    private void checkButtonState() {
        if (!this.isPressed()) {
            return;
        }
        this.state = ButtonEvent.LONG;
        if (this.command != null) {
            this.command.execute(ButtonEvent.LONG, this.pressedVelocity);
        }
    }
}

