/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.controller.color;

public class ColorEx {
    public static final ColorEx BLACK = ColorEx.fromRGB(0, 0, 0);
    public static final ColorEx WHITE = ColorEx.fromRGB(255, 255, 255);
    public static final ColorEx LIGHT_GRAY = ColorEx.fromRGB(182, 182, 182);
    public static final ColorEx GRAY = ColorEx.fromRGB(128, 128, 128);
    public static final ColorEx DARK_GRAY = ColorEx.fromRGB(89, 89, 89);
    public static final ColorEx DARKER_GRAY = ColorEx.fromRGB(63, 63, 63);
    public static final ColorEx RED = ColorEx.fromRGB(255, 0, 0);
    public static final ColorEx DARK_RED = ColorEx.fromRGB(128, 0, 0);
    public static final ColorEx DARKER_RED = ColorEx.fromRGB(32, 0, 0);
    public static final ColorEx GREEN = ColorEx.fromRGB(0, 255, 0);
    public static final ColorEx DARK_GREEN = ColorEx.fromRGB(0, 128, 0);
    public static final ColorEx DARKER_GREEN = ColorEx.fromRGB(0, 63, 0);
    public static final ColorEx BLUE = ColorEx.fromRGB(0, 0, 255);
    public static final ColorEx DARK_BLUE = ColorEx.fromRGB(0, 0, 128);
    public static final ColorEx DARKER_BLUE = ColorEx.fromRGB(0, 0, 32);
    public static final ColorEx YELLOW = ColorEx.fromRGB(255, 255, 0);
    public static final ColorEx DARK_YELLOW = ColorEx.fromRGB(128, 128, 0);
    public static final ColorEx DARKER_YELLOW = ColorEx.fromRGB(32, 32, 0);
    public static final ColorEx ORANGE = ColorEx.fromRGB(255, 80, 0);
    public static final ColorEx DARK_ORANGE = ColorEx.fromRGB(128, 65, 0);
    public static final ColorEx DARKER_ORANGE = ColorEx.fromRGB(32, 16, 0);
    public static final ColorEx PINK = ColorEx.fromRGB(255, 0, 220);
    public static final ColorEx DARK_PINK = ColorEx.evenDarker(PINK);
    public static final ColorEx ROSE = ColorEx.fromRGB(255, 127, 127);
    public static final ColorEx BROWN = ColorEx.fromRGB(183, 73, 0);
    public static final ColorEx DARK_BROWN = ColorEx.fromRGB(127, 0, 0);
    public static final ColorEx MINT = ColorEx.fromRGB(170, 240, 209);
    public static final ColorEx DARK_MINT = ColorEx.evenDarker(MINT);
    public static final ColorEx OLIVE = ColorEx.fromRGB(128, 128, 0);
    public static final ColorEx SKY_BLUE = ColorEx.fromRGB(97, 238, 255);
    public static final ColorEx PURPLE = ColorEx.fromRGB(116, 80, 164);
    public static final ColorEx DARK_PURPLE = ColorEx.evenDarker(PURPLE);
    public static final ColorEx RED_WINE = ColorEx.fromRGB(123, 42, 57);
    public static final ColorEx CYAN = ColorEx.fromRGB(0, 255, 255);
    private static final double FACTOR = 0.7;
    private static final double FACTOR2 = 0.4;
    private final double redValue;
    private final double greenValue;
    private final double blueValue;

    public ColorEx(double[] color) {
        this(color[0], color[1], color[2]);
    }

    public ColorEx(double red, double green, double blue) {
        this.redValue = red;
        this.greenValue = green;
        this.blueValue = blue;
    }

    public static ColorEx fromRGB(int red, int green, int blue) {
        return new ColorEx((double)red / 255.0, (double)green / 255.0, (double)blue / 255.0);
    }

    public static ColorEx fromHSB(float hue, float saturation, float brightness) {
        if (saturation == 0.0f) {
            int value = (int)(brightness * 255.0f + 0.5f);
            return ColorEx.fromRGB(value, value, value);
        }
        float h = (hue - (float)Math.floor(hue)) * 6.0f;
        float f = h - (float)Math.floor(h);
        float p = brightness * (1.0f - saturation);
        float q = brightness * (1.0f - saturation * f);
        float t = brightness * (1.0f - saturation * (1.0f - f));
        switch ((int)h) {
            case 0: {
                return ColorEx.fromRGB((int)(brightness * 255.0f + 0.5f), (int)(t * 255.0f + 0.5f), (int)(p * 255.0f + 0.5f));
            }
            case 1: {
                return ColorEx.fromRGB((int)(q * 255.0f + 0.5f), (int)(brightness * 255.0f + 0.5f), (int)(p * 255.0f + 0.5f));
            }
            case 2: {
                return ColorEx.fromRGB((int)(p * 255.0f + 0.5f), (int)(brightness * 255.0f + 0.5f), (int)(t * 255.0f + 0.5f));
            }
            case 3: {
                return ColorEx.fromRGB((int)(p * 255.0f + 0.5f), (int)(q * 255.0f + 0.5f), (int)(brightness * 255.0f + 0.5f));
            }
            case 4: {
                return ColorEx.fromRGB((int)(t * 255.0f + 0.5f), (int)(p * 255.0f + 0.5f), (int)(brightness * 255.0f + 0.5f));
            }
            case 5: {
                return ColorEx.fromRGB((int)(brightness * 255.0f + 0.5f), (int)(p * 255.0f + 0.5f), (int)(q * 255.0f + 0.5f));
            }
        }
        return BLACK;
    }

    public int[] toIntRGB255() {
        return new int[]{(int)Math.round(this.redValue * 255.0), (int)Math.round(this.greenValue * 255.0), (int)Math.round(this.blueValue * 255.0)};
    }

    public int[] toIntRGB127() {
        return new int[]{(int)Math.round(this.redValue * 127.0), (int)Math.round(this.greenValue * 127.0), (int)Math.round(this.blueValue * 127.0)};
    }

    public double[] toDoubleRGB() {
        return new double[]{this.redValue, this.greenValue, this.blueValue};
    }

    public float[] toHSB() {
        float hue;
        int cmin;
        int cmax;
        int[] rgb = this.toIntRGB255();
        int r = rgb[0];
        int g = rgb[1];
        int b = rgb[2];
        int n = cmax = r > g ? r : g;
        if (b > cmax) {
            cmax = b;
        }
        int n2 = cmin = r < g ? r : g;
        if (b < cmin) {
            cmin = b;
        }
        float brightness = (float)cmax / 255.0f;
        float saturation = cmax != 0 ? (float)(cmax - cmin) / (float)cmax : 0.0f;
        if (saturation == 0.0f) {
            hue = 0.0f;
        } else {
            float redc = (float)(cmax - r) / (float)(cmax - cmin);
            float greenc = (float)(cmax - g) / (float)(cmax - cmin);
            float bluec = (float)(cmax - b) / (float)(cmax - cmin);
            hue = r == cmax ? bluec - greenc : (g == cmax ? 2.0f + redc - bluec : 4.0f + greenc - redc);
            if ((hue /= 6.0f) < 0.0f) {
                hue += 1.0f;
            }
        }
        return new float[]{hue, saturation, brightness};
    }

    public static ColorEx brighter(ColorEx c) {
        double r = c.getRed();
        double g = c.getGreen();
        double b = c.getBlue();
        double i = 0.0130718954248366;
        if (r == 0.0 && g == 0.0 && b == 0.0) {
            return new ColorEx(0.0130718954248366, 0.0130718954248366, 0.0130718954248366);
        }
        if (r > 0.0 && r < 0.0130718954248366) {
            r = 0.0130718954248366;
        }
        if (g > 0.0 && g < 0.0130718954248366) {
            g = 0.0130718954248366;
        }
        if (b > 0.0 && b < 0.0130718954248366) {
            b = 0.0130718954248366;
        }
        return new ColorEx(Math.min(r / 0.7, 1.0), Math.min(g / 0.7, 1.0), Math.min(b / 0.7, 1.0));
    }

    public static ColorEx darker(ColorEx color) {
        return new ColorEx(Math.max(color.getRed() * 0.7, 0.0), Math.max(color.getGreen() * 0.7, 0.0), Math.max(color.getBlue() * 0.7, 0.0));
    }

    public static ColorEx evenDarker(ColorEx color) {
        return new ColorEx(Math.max(color.getRed() * 0.4, 0.0), Math.max(color.getGreen() * 0.4, 0.0), Math.max(color.getBlue() * 0.4, 0.0));
    }

    public ColorEx dim(double hue) {
        return new ColorEx(this.redValue * hue, this.greenValue * hue, this.blueValue * hue);
    }

    public static ColorEx dimToGray(ColorEx color) {
        double red = color.getRed();
        double green = color.getGreen();
        double blue = color.getBlue();
        if (red != green || green != blue) {
            double v = (red + green + blue) / 3.0;
            return ColorEx.evenDarker(new ColorEx(v, v, v));
        }
        return ColorEx.evenDarker(color);
    }

    public ColorEx scale(double brightness, double saturation) {
        float[] hsb = this.toHSB();
        return ColorEx.fromHSB(hsb[0], (float)Math.min(1.0, (double)(hsb[1] * 2.0f) * saturation), (float)Math.max((double)hsb[2] * brightness, 0.1));
    }

    public static ColorEx getClosestColor(ColorEx color, ColorEx[] palette) {
        return palette[ColorEx.getClosestColorIndex(color, palette)];
    }

    public static int getClosestColorIndex(ColorEx color, ColorEx[] palette) {
        return ColorEx.getClosestColorIndex(color, palette, true);
    }

    public static int getClosestColorIndex(ColorEx color, ColorEx[] palette, boolean useColorMetric) {
        double minError = 5.0;
        int closest = 0;
        for (int i = 0; i < palette.length; ++i) {
            double error = ColorEx.calcDistance(palette[i], color, useColorMetric);
            if (!(error < minError)) continue;
            closest = i;
            minError = error;
        }
        return closest;
    }

    public static double calcDistance(ColorEx color1, ColorEx color2, boolean useColorMetric) {
        return ColorEx.calcDistance(color1.toDoubleRGB(), color2.toDoubleRGB(), useColorMetric);
    }

    public static double calcDistance(double[] color1, double[] color2, boolean useColorMetric) {
        double deltaR = color1[0] - color2[0];
        double deltaG = color1[1] - color2[1];
        double deltaB = color1[2] - color2[2];
        if (useColorMetric) {
            double rmean = (color1[0] + color2[0]) / 2.0;
            return Math.sqrt((2.0 + rmean) * deltaR * deltaR + 4.0 * deltaG * deltaG + (2.99609375 - rmean) * deltaB * deltaB);
        }
        return Math.abs(deltaR) + Math.abs(deltaG) + Math.abs(deltaB);
    }

    public static ColorEx calcContrastColor(ColorEx c) {
        double l = 0.2126 * c.getRed() + 0.7152 * c.getGreen() + 0.0722 * c.getBlue();
        return l > 0.179 ? BLACK : WHITE;
    }

    public int encode() {
        int[] c = this.toIntRGB255();
        return c[0] + (c[1] << 8) + (c[2] << 16);
    }

    public static ColorEx decode(int encodedColor) {
        int red = encodedColor & 0xFF;
        int green = encodedColor >> 8 & 0xFF;
        int blue = encodedColor >> 16 & 0xFF;
        return ColorEx.fromRGB(red, green, blue);
    }

    public double getRed() {
        return this.redValue;
    }

    public double getGreen() {
        return this.greenValue;
    }

    public double getBlue() {
        return this.blueValue;
    }

    public boolean isGrayscale() {
        return this.redValue == this.greenValue && this.greenValue == this.blueValue;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.blueValue);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.greenValue);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.redValue);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ColorEx other = (ColorEx)obj;
        if (Double.doubleToLongBits(this.blueValue) != Double.doubleToLongBits(other.blueValue) || Double.doubleToLongBits(this.greenValue) != Double.doubleToLongBits(other.greenValue)) {
            return false;
        }
        return Double.doubleToLongBits(this.redValue) == Double.doubleToLongBits(other.redValue);
    }
}

