/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.oxi.one.view;

import de.mossgrabers.controller.oxi.one.OxiOneConfiguration;
import de.mossgrabers.controller.oxi.one.controller.OxiOneControlSurface;
import de.mossgrabers.controller.oxi.one.mode.OxiOneGeneratorMode;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.clip.INoteClip;
import de.mossgrabers.framework.daw.clip.IStepInfo;
import de.mossgrabers.framework.daw.clip.NoteOccurrenceType;
import de.mossgrabers.framework.daw.clip.NotePosition;
import de.mossgrabers.framework.daw.clip.StepState;
import de.mossgrabers.framework.daw.constants.Resolution;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.NoteGenerator;
import de.mossgrabers.framework.view.sequencer.AbstractNoteSequencerView;

public class OxiOneSequencerView
extends AbstractNoteSequencerView<OxiOneControlSurface, OxiOneConfiguration> {
    private final ModeManager modeManager;

    public OxiOneSequencerView(OxiOneControlSurface surface, IModel model) {
        super("Sequencer", surface, model, 16, 8, true);
        this.numDisplayRows = 8;
        this.modeManager = ((OxiOneControlSurface)this.surface).getModeManager();
    }

    @Override
    public void onGridNote(int note, int velocity) {
        if (this.modeManager.isActive(new Modes[]{Modes.GENERATOR})) {
            if (velocity > 0) {
                OxiOneGeneratorMode generatorMode = (OxiOneGeneratorMode)this.modeManager.get(Modes.GENERATOR);
                int pulse = generatorMode.getPulse();
                int rotation = generatorMode.getRotation();
                double density = generatorMode.getDensity();
                INoteClip clip = this.getClip();
                int length = Math.min(generatorMode.getLength(), clip.getNumSteps());
                boolean[] euclideanPattern = NoteGenerator.generateEuclideanPattern(pulse, length, rotation, density);
                int index = note - ((OxiOneControlSurface)this.surface).getPadGrid().getStartNote();
                int x = index % this.numDisplayCols;
                int y = index / this.numDisplayCols;
                int mappedY = this.keyManager.map(y);
                NotePosition notePosition = new NotePosition(this.configuration.getMidiEditChannel(), x, mappedY);
                for (int step = 0; step < euclideanPattern.length; ++step) {
                    notePosition.setStep(step);
                    if (euclideanPattern[step]) {
                        clip.setStep(notePosition, 127, clip.getStepLength());
                        continue;
                    }
                    clip.clearStep(notePosition);
                }
            }
            return;
        }
        boolean init = ((OxiOneControlSurface)this.surface).isPressed(ButtonID.PUNCH_IN);
        boolean end = ((OxiOneControlSurface)this.surface).isPressed(ButtonID.PUNCH_OUT);
        if (init || end) {
            if (velocity == 0) {
                INoteClip clip = this.getClip();
                int lengthOfOnePage = this.getLengthOfOnePage(this.numDisplayCols);
                int offset = clip.getEditPage() * lengthOfOnePage;
                int index = note - ((OxiOneControlSurface)this.surface).getPadGrid().getStartNote();
                int x = index % this.numDisplayCols;
                double lengthOfOnePad = Resolution.getValueAt(this.getResolutionIndex());
                double pos = (double)offset + (double)x * lengthOfOnePad;
                double newStart = init ? pos : clip.getLoopStart();
                double newLength = end ? Math.max(pos - newStart + lengthOfOnePad, lengthOfOnePad) : clip.getLoopLength();
                clip.setLoopStart(newStart);
                clip.setLoopLength(newLength);
                clip.setPlayRange(newStart, newStart + newLength);
            }
            return;
        }
        super.onGridNote(note, velocity);
    }

    @Override
    public void onGridNoteLongPress(int note) {
        if (!this.isActive()) {
            return;
        }
        int index = note - ((OxiOneControlSurface)this.surface).getPadGrid().getStartNote();
        ((OxiOneControlSurface)this.surface).getButton(ButtonID.get(ButtonID.PAD1, index)).setConsumed();
        int y = index / this.numDisplayCols;
        int x = index % this.numDisplayCols;
        int mappedY = this.keyManager.map(y);
        NotePosition notePosition = new NotePosition(this.configuration.getMidiEditChannel(), x, mappedY);
        this.editNote(this.getClip(), notePosition, false);
    }

    @Override
    public void onButton(ButtonID buttonID, ButtonEvent event, int velocity) {
        if (ButtonID.isSceneButton(buttonID)) {
            this.onSceneButton(buttonID, event);
        }
    }

    @Override
    protected boolean handleSequencerAreaButtonCombinations(INoteClip clip, NotePosition notePosition, int row, int velocity) {
        if (((OxiOneControlSurface)this.surface).isPressed(ButtonID.REPEAT) || ((OxiOneControlSurface)this.surface).isPressed(ButtonID.ACCENT)) {
            if (velocity > 0) {
                this.handleSequencerAreaRepeatOperator(clip, notePosition, velocity, ((OxiOneControlSurface)this.surface).isPressed(ButtonID.REPEAT));
            }
            return true;
        }
        if (this.isButtonCombination(ButtonID.GROOVE)) {
            if (velocity > 0) {
                IStepInfo step = clip.getStep(notePosition);
                if (step.getState() != StepState.START) {
                    return true;
                }
                switch (step.getOccurrence()) {
                    case FILL: {
                        clip.setStepOccurrence(notePosition, NoteOccurrenceType.NOT_FILL);
                        ((OxiOneControlSurface)this.surface).getDisplay().notify("Not Fill");
                        break;
                    }
                    case NOT_FILL: {
                        clip.setStepOccurrence(notePosition, NoteOccurrenceType.ALWAYS);
                        ((OxiOneControlSurface)this.surface).getDisplay().notify("Always");
                        break;
                    }
                    default: {
                        clip.setStepOccurrence(notePosition, NoteOccurrenceType.FILL);
                        ((OxiOneControlSurface)this.surface).getDisplay().notify("Fill");
                    }
                }
            }
            return true;
        }
        return super.handleSequencerAreaButtonCombinations(clip, notePosition, row, velocity);
    }
}

