/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.oxi.one.mode;

import de.mossgrabers.controller.oxi.one.OxiOneConfiguration;
import de.mossgrabers.controller.oxi.one.controller.OxiOneControlSurface;
import de.mossgrabers.controller.oxi.one.mode.IOxiModeReset;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.controller.display.IGraphicDisplay;
import de.mossgrabers.framework.daw.GrooveParameterID;
import de.mossgrabers.framework.daw.IGroove;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.empty.EmptyParameter;
import de.mossgrabers.framework.featuregroup.AbstractParameterMode;
import de.mossgrabers.framework.graphics.canvas.component.simple.TitleValueMenuComponent;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.parameterprovider.special.FixedParameterProvider;
import de.mossgrabers.framework.parameterprovider.special.FourKnobProvider;

public class OxiOneGrooveMode
extends AbstractParameterMode<OxiOneControlSurface, OxiOneConfiguration, IParameter>
implements IOxiModeReset {
    private static final String[] MENU = new String[]{"Enbl", "", "ShfA", "ShfR"};
    private static final String[] SHIFTED_MENU = new String[]{"", "AccP", "AccA", "AccR"};
    private final IGroove groove;
    private final IParameter[] params = new IParameter[8];
    private int selectedIndex = 0;

    public OxiOneGrooveMode(OxiOneControlSurface surface, IModel model) {
        super("Groove", surface, model, false);
        this.groove = this.model.getGroove();
        this.params[0] = this.groove.getParameter(GrooveParameterID.ENABLED);
        this.params[1] = EmptyParameter.INSTANCE;
        this.params[2] = this.groove.getParameter(GrooveParameterID.SHUFFLE_AMOUNT);
        this.params[3] = this.groove.getParameter(GrooveParameterID.SHUFFLE_RATE);
        this.params[4] = EmptyParameter.INSTANCE;
        this.params[5] = this.groove.getParameter(GrooveParameterID.ACCENT_PHASE);
        this.params[6] = this.groove.getParameter(GrooveParameterID.ACCENT_AMOUNT);
        this.params[7] = this.groove.getParameter(GrooveParameterID.ACCENT_RATE);
        this.setControls(ContinuousID.createSequentialList(ContinuousID.KNOB1, 4));
        this.setParameterProvider(new FourKnobProvider(surface, new FixedParameterProvider(this.params), ButtonID.SHIFT));
    }

    @Override
    public void updateDisplay() {
        this.updateSelectedIndex();
        IGraphicDisplay display = ((OxiOneControlSurface)this.surface).getGraphicsDisplay();
        IParameter p = this.params[this.selectedIndex];
        String label = p.doesExist() ? p.getName(12) + ": " + p.getDisplayedValue(8) : "";
        int value = p.doesExist() ? p.getValue() : -1;
        display.addElement(new TitleValueMenuComponent("", label, ((OxiOneControlSurface)this.surface).isShiftPressed() ? SHIFTED_MENU : MENU, value, 0, 0, false));
        display.send();
    }

    private void updateSelectedIndex() {
        if (((OxiOneControlSurface)this.surface).isPressed(ButtonID.SHIFT)) {
            if (this.selectedIndex < 4) {
                this.selectedIndex += 4;
            }
        } else if (this.selectedIndex >= 4) {
            this.selectedIndex -= 4;
        }
    }

    @Override
    public void onKnobTouch(int index, boolean isTouched) {
        this.selectedIndex = ((OxiOneControlSurface)this.surface).isPressed(ButtonID.SHIFT) ? index + 4 : index;
    }

    @Override
    public void onKnobValue(int index, int value) {
        this.params[this.selectedIndex].changeValue(value);
    }

    @Override
    public void resetValue(int index) {
        this.params[this.selectedIndex].resetValue();
    }
}

