/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.oxi.one.controller;

import de.mossgrabers.controller.oxi.one.OxiOneConfiguration;
import de.mossgrabers.controller.oxi.one.controller.OxiOnePadGrid;
import de.mossgrabers.framework.controller.AbstractControlSurface;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.controller.display.IGraphicDisplay;
import de.mossgrabers.framework.controller.hardware.BindType;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import de.mossgrabers.framework.graphics.canvas.component.LabelComponent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OxiOneControlSurface
extends AbstractControlSurface<OxiOneConfiguration> {
    public static final int KNOB1_VELOCITY = 0;
    public static final int KNOB2_OCTAVE = 1;
    public static final int KNOB3_GATE = 2;
    public static final int KNOB4_MODULATION = 3;
    public static final int MK1_BUTTON_ARP = 0;
    public static final int MK1_BUTTON_SEQUENCER4 = 1;
    public static final int MK1_BUTTON_16_LEFT = 2;
    public static final int MK1_BUTTON_END = 3;
    public static final int MK1_BUTTON_KEYBOARD = 4;
    public static final int MK1_BUTTON_SEQUENCER3 = 5;
    public static final int MK1_BUTTON_32_UP = 6;
    public static final int MK1_BUTTON_INIT = 7;
    public static final int MK1_BUTTON_ARRANGER = 8;
    public static final int MK1_BUTTON_SEQUENCER2 = 9;
    public static final int MK1_BUTTON_48_DOWN = 10;
    public static final int MK1_BUTTON_SAVE = 11;
    public static final int MK1_BUTTON_BACK = 12;
    public static final int MK1_BUTTON_SEQUENCER1 = 13;
    public static final int MK1_BUTTON_64_RIGHT = 14;
    public static final int MK1_BUTTON_LOAD = 15;
    public static final int MK1_BUTTON_ENCODER1 = 16;
    public static final int MK1_BUTTON_SHIFT = 17;
    public static final int MK1_BUTTON_MOD = 18;
    public static final int MK1_BUTTON_COPY = 19;
    public static final int MK1_BUTTON_ENCODER2 = 20;
    public static final int MK1_BUTTON_STOP = 21;
    public static final int MK1_BUTTON_DIVISION = 22;
    public static final int MK1_BUTTON_PASTE = 23;
    public static final int MK1_BUTTON_ENCODER3 = 24;
    public static final int MK1_BUTTON_PLAY = 25;
    public static final int MK1_BUTTON_LFO = 26;
    public static final int MK1_BUTTON_UNDO = 27;
    public static final int MK1_BUTTON_ENCODER4 = 28;
    public static final int MK1_BUTTON_REC = 29;
    public static final int MK1_BUTTON_STEP_CHORD = 30;
    public static final int MK1_BUTTON_RANDOM = 31;
    public static final int MK1_BUTTON_MUTE = 32;
    public static final int MK2_BUTTON_ARP = 0;
    public static final int MK2_BUTTON_FLOW = 1;
    public static final int MK2_BUTTON_16_LEFT = 2;
    public static final int MK2_BUTTON_END = 3;
    public static final int MK2_BUTTON_KEYBOARD = 4;
    public static final int MK2_BUTTON_GEN = 5;
    public static final int MK2_BUTTON_32_UP = 6;
    public static final int MK2_BUTTON_INIT = 7;
    public static final int MK2_BUTTON_ARRANGER = 8;
    public static final int MK2_BUTTON_MOD = 9;
    public static final int MK2_BUTTON_48_DOWN = 10;
    public static final int MK2_BUTTON_SAVE = 11;
    public static final int MK2_BUTTON_BACK = 12;
    public static final int MK2_BUTTON_PERF = 13;
    public static final int MK2_BUTTON_64_RIGHT = 14;
    public static final int MK2_BUTTON_LOAD = 15;
    public static final int MK2_BUTTON_ENCODER1 = 16;
    public static final int MK2_BUTTON_SHIFT = 17;
    public static final int MK2_BUTTON_PAGE = 18;
    public static final int MK2_BUTTON_COPY = 19;
    public static final int MK2_BUTTON_ENCODER2 = 20;
    public static final int MK2_BUTTON_STOP = 21;
    public static final int MK2_BUTTON_TRACK = 22;
    public static final int MK2_BUTTON_PASTE = 23;
    public static final int MK2_BUTTON_ENCODER3 = 24;
    public static final int MK2_BUTTON_PLAY = 25;
    public static final int MK2_BUTTON_LFO = 26;
    public static final int MK2_BUTTON_UNDO = 27;
    public static final int MK2_BUTTON_ENCODER4 = 28;
    public static final int MK2_BUTTON_REC = 29;
    public static final int MK2_BUTTON_STEP_CHORD = 30;
    public static final int MK2_BUTTON_RANDOM = 31;
    public static final int MK2_BUTTON_MUTE = 32;
    public static final int MK2_BUTTON_SEQUENCER1 = 33;
    public static final int MK2_BUTTON_SEQUENCER2 = 34;
    public static final int MK2_BUTTON_SEQUENCER3 = 35;
    public static final int MK2_BUTTON_SEQUENCER4 = 36;
    public static final int MK2_BUTTON_SEQUENCER5 = 37;
    public static final int MK2_BUTTON_SEQUENCER6 = 38;
    public static final int MK2_BUTTON_SEQUENCER7 = 39;
    public static final int MK2_BUTTON_SEQUENCER8 = 40;
    private static final int MK1_LEDS_BACK = 0;
    private static final int MK1_LEDS_CONFIG = 1;
    private static final int MK1_LEDS_ARRANGER_SHOW = 2;
    private static final int MK1_LEDS_ARRANGER_STATE = 3;
    private static final int MK1_LEDS_KEYBOARD = 4;
    private static final int MK1_LEDS_PREVIEW = 5;
    private static final int MK1_LEDS_ARP = 6;
    private static final int MK1_LEDS_ARP_HOLD = 7;
    private static final int MK1_LEDS_SHIFT = 8;
    private static final int MK1_LEDS_STOP = 9;
    private static final int MK1_LEDS_SEQ_1 = 10;
    private static final int MK1_LEDS_REC = 11;
    private static final int MK1_LEDS_PLAY = 12;
    private static final int MK1_LEDS_SEQ_3 = 13;
    private static final int MK1_LEDS_NUDGE = 14;
    private static final int MK1_LEDS_SYNC = 15;
    private static final int MK1_LEDS_SEQ_1_SEL = 16;
    private static final int MK1_LEDS_SEQ_2 = 17;
    private static final int MK1_LEDS_SEQ_2_SEL = 18;
    private static final int MK1_LEDS_MUTE = 19;
    private static final int MK1_LEDS_LOAD = 20;
    private static final int MK1_LEDS_SEQ_4 = 21;
    private static final int MK1_LEDS_SEQ_4_SEL = 22;
    private static final int MK1_LEDS_SEQ_3_SEL = 23;
    private static final int MK1_LEDS_SAVE = 24;
    private static final int MK1_LEDS_CLEAR = 25;
    private static final int MK1_LEDS_DUPLICATE = 26;
    private static final int MK1_LEDS_PASTE = 27;
    private static final int MK1_LEDS_COPY = 28;
    private static final int MK1_LEDS_UNDO = 29;
    private static final int MK1_LEDS_RANDOM = 30;
    private static final int MK1_LEDS_REDO = 31;
    private static final int MK1_LEDS_RANDOM2 = 32;
    private static final int MK1_LEDS_INIT = 33;
    private static final int MK1_LEDS_X2 = 34;
    private static final int MK1_LEDS_END = 35;
    private static final int MK1_LEDS_2 = 36;
    private static final int MK1_LEDS_MOD = 37;
    private static final int MK1_LEDS_DIVISION = 38;
    private static final int MK1_LEDS_FOLLOW = 39;
    private static final int MK1_LEDS_LFO = 40;
    private static final int MK1_LEDS_CONDENSE = 41;
    private static final int MK1_LEDS_CVOUT = 42;
    private static final int MK1_LEDS_STEP_CHORD = 43;
    private static final int MK1_LEDS_EXPAND = 44;
    private static final int MK1_LEDS_16 = 45;
    private static final int MK1_LEDS_LEFT = 46;
    private static final int MK1_LEDS_32 = 47;
    private static final int MK1_LEDS_UP = 48;
    private static final int MK1_LEDS_48 = 49;
    private static final int MK1_LEDS_RIGHT = 50;
    private static final int MK1_LEDS_64 = 51;
    private static final int MK1_LEDS_DOWN = 52;
    private static final int MK1_LEDS_NO_LED = 53;
    private static final int MK1_LEDS_PLAY2 = 54;
    private static final int MK2_LEDS_BACK = 0;
    private static final int MK2_LEDS_CONFIG = 1;
    private static final int MK2_LEDS_ARRANGER_SHOW = 2;
    private static final int MK2_LEDS_ARRANGER_STATE = 3;
    private static final int MK2_LEDS_KEYBOARD = 4;
    private static final int MK2_LEDS_PREVIEW = 5;
    private static final int MK2_LEDS_ARP = 6;
    private static final int MK2_LEDS_ARP_HOLD = 7;
    private static final int MK2_LEDS_SHIFT_2 = 8;
    private static final int MK2_LEDS_SHIFT = 9;
    private static final int MK2_LEDS_STOP = 10;
    private static final int MK2_LEDS_SYNC = 11;
    private static final int MK2_LEDS_REC = 12;
    private static final int MK2_LEDS_REC_2 = 13;
    private static final int MK2_LEDS_PLAY = 14;
    private static final int MK2_LEDS_TAP = 15;
    private static final int MK2_LEDS_MUTE = 16;
    private static final int MK2_LEDS_NUDGE = 17;
    private static final int MK2_LEDS_FLOW = 18;
    private static final int MK2_LEDS_GROOVE = 19;
    private static final int MK2_LEDS_GEN = 20;
    private static final int MK2_LEDS_CVOUT = 21;
    private static final int MK2_LEDS_MOD = 22;
    private static final int MK2_LEDS_EXT_MOD = 23;
    private static final int MK2_LEDS_PERF = 24;
    private static final int MK2_LEDS_PROJ = 25;
    private static final int MK2_LEDS_UNDO = 26;
    private static final int MK2_LEDS_REDO = 27;
    private static final int MK2_LEDS_COPY = 28;
    private static final int MK2_LEDS_DUPLICATE = 29;
    private static final int MK2_LEDS_LOAD = 30;
    private static final int MK2_LEDS_LOAD_2 = 31;
    private static final int MK2_LEDS_SAVE = 32;
    private static final int MK2_LEDS_SAVE_2 = 33;
    private static final int MK2_LEDS_PASTE = 34;
    private static final int MK2_LEDS_CLEAR = 35;
    private static final int MK2_LEDS_RANDOM = 36;
    private static final int MK2_LEDS_RANDOM2 = 37;
    private static final int MK2_LEDS_LFO = 38;
    private static final int MK2_LEDS_CONDENSE = 39;
    private static final int MK2_LEDS_PAGE = 40;
    private static final int MK2_LEDS_EXPAND = 41;
    private static final int MK2_LEDS_INIT = 42;
    private static final int MK2_LEDS_X2 = 43;
    private static final int MK2_LEDS_END = 44;
    private static final int MK2_LEDS_2 = 45;
    private static final int MK2_LEDS_TRACK = 46;
    private static final int MK2_LEDS_FOLLOW = 47;
    private static final int MK2_LEDS_STEP = 48;
    private static final int MK2_LEDS_CHORD = 49;
    private static final int MK2_LEDS_64 = 50;
    private static final int MK2_LEDS_RIGHT = 51;
    private static final int MK2_LEDS_48 = 52;
    private static final int MK2_LEDS_DOWN = 53;
    private static final int MK2_LEDS_32 = 54;
    private static final int MK2_LEDS_UP = 55;
    private static final int MK2_LEDS_16 = 56;
    private static final int MK2_LEDS_LEFT = 57;
    private static final int MK2_LEDS_SEQ_1 = 58;
    private static final int MK2_LEDS_SEQ_2 = 59;
    private static final int MK2_LEDS_SEQ_3 = 60;
    private static final int MK2_LEDS_SEQ_4 = 61;
    private static final int MK2_LEDS_SEQ_5 = 62;
    private static final int MK2_LEDS_SEQ_6 = 63;
    private static final int MK2_LEDS_SEQ_7 = 64;
    private static final int MK2_LEDS_SEQ_8 = 65;
    private static final int MK2_LEDS_SEQ_1_SEL = 66;
    private static final int MK2_LEDS_SEQ_2_SEL = 67;
    private static final int MK2_LEDS_SEQ_3_SEL = 68;
    private static final int MK2_LEDS_SEQ_4_SEL = 69;
    private static final int MK2_LEDS_SEQ_5_SEL = 70;
    private static final int MK2_LEDS_SEQ_6_SEL = 71;
    private static final int MK2_LEDS_SEQ_7_SEL = 72;
    private static final int MK2_LEDS_SEQ_8_SEL = 73;
    private static final List<Integer> MK1_NORMAL_LEDS = new ArrayList<Integer>();
    private static final List<Integer> MK2_NORMAL_LEDS = new ArrayList<Integer>();
    private static final List<Integer> MK1_SHIFTED_LEDS = new ArrayList<Integer>();
    private static final List<Integer> MK2_SHIFTED_LEDS = new ArrayList<Integer>();
    private static final Map<Integer, Integer> MK1_BUTTON_LEDS = new HashMap<Integer, Integer>();
    private static final Map<Integer, Integer> MK2_BUTTON_LEDS = new HashMap<Integer, Integer>();
    private static final Map<Integer, Integer> MK1_SHIFTED_BUTTON_LEDS = new HashMap<Integer, Integer>();
    private static final Map<Integer, Integer> MK2_SHIFTED_BUTTON_LEDS = new HashMap<Integer, Integer>();
    private static final byte[] ENTER_REMOTE_MODE;
    private static final byte[] EXIT_REMOTE_MODE;
    private final byte[] sysexHeader = new byte[]{-16, 0, 33, 91, 0, 1};
    private final byte[] ledUpdate = new byte[]{2, 0, 0, 0, 0, -9};
    private String acknowledge = "f000215b00010653f7";
    private final boolean[] buttonStates;
    private final List<Integer> normalLEDS;
    private final List<Integer> shiftedLEDS;
    private final Map<Integer, Integer> buttonLEDS;
    private final Map<Integer, Integer> shiftedButtonLEDS;

    public OxiOneControlSurface(IHost host, ColorManager colorManager, OxiOneConfiguration configuration, IMidiOutput output, IMidiInput input, boolean isMk2) {
        super(host, configuration, colorManager, output, input, new OxiOnePadGrid(colorManager, output, configuration, isMk2), 290.0, 140.0);
        this.acknowledge = isMk2 ? "f000215b01010653f7" : "f000215b00010653f7";
        this.normalLEDS = isMk2 ? MK2_NORMAL_LEDS : MK1_NORMAL_LEDS;
        this.shiftedLEDS = isMk2 ? MK2_SHIFTED_LEDS : MK1_SHIFTED_LEDS;
        this.buttonLEDS = isMk2 ? MK2_BUTTON_LEDS : MK1_BUTTON_LEDS;
        this.shiftedButtonLEDS = isMk2 ? MK2_SHIFTED_BUTTON_LEDS : MK1_SHIFTED_BUTTON_LEDS;
        this.buttonStates = new boolean[isMk2 ? 74 : 55];
        this.sysexHeader[4] = (byte)(isMk2 ? 1 : 0);
        this.input.setSysexCallback(this::handleSysEx);
    }

    public void enterRemoteMode() {
        this.output.sendSysex(this.sysexHeader, ENTER_REMOTE_MODE);
    }

    public void exitRemoteMode() {
        this.output.sendSysex(this.sysexHeader, EXIT_REMOTE_MODE);
    }

    @Override
    protected void flushHardware() {
        super.flushHardware();
        ((OxiOnePadGrid)this.padGrid).flush();
    }

    @Override
    protected void internalShutdown() {
        IGraphicDisplay display = this.getGraphicsDisplay();
        display.addElement(new LabelComponent("Goodbye", null, ColorEx.BLACK, false, false, LabelComponent.LabelLayout.PLAIN));
        display.send();
        this.exitRemoteMode();
        super.internalShutdown();
    }

    @Override
    public OxiOnePadGrid getPadGrid() {
        return (OxiOnePadGrid)this.padGrid;
    }

    @Override
    public boolean isDeletePressed() {
        boolean pressed = this.isPressed(ButtonID.BANK_RIGHT);
        if (pressed) {
            this.setTriggerConsumed(ButtonID.BANK_RIGHT);
        }
        return pressed;
    }

    public void updateFunctionButtonLEDs() {
        boolean isShifted = this.isShiftPressed();
        for (int i = 0; i < this.buttonStates.length; ++i) {
            if (this.normalLEDS.contains(i) && this.buttonStates[i]) {
                this.updateLED(i, !isShifted);
                continue;
            }
            if (!this.shiftedLEDS.contains(i) || !this.buttonStates[i]) continue;
            this.updateLED(i, isShifted);
        }
    }

    @Override
    public void setTrigger(BindType bindType, int channel, int cc, int value) {
        Integer integerCC = cc;
        Integer normalLedCC = this.buttonLEDS.get(integerCC);
        Integer shiftedLedCC = this.shiftedButtonLEDS.get(integerCC);
        if (normalLedCC == null) {
            return;
        }
        int intNormalLedCCValue = normalLedCC;
        boolean bl = this.buttonStates[intNormalLedCCValue] = (value & 1) > 0;
        if (shiftedLedCC != null) {
            boolean bl2 = this.buttonStates[shiftedLedCC.intValue()] = (value & 2) > 0;
        }
        if (this.isShiftPressed()) {
            if (shiftedLedCC != null) {
                this.updateLED(shiftedLedCC, this.buttonStates[shiftedLedCC]);
            }
        } else {
            this.updateLED(intNormalLedCCValue, this.buttonStates[intNormalLedCCValue]);
        }
    }

    private void updateLED(int ledID, boolean enabled) {
        this.ledUpdate[1] = (byte)(ledID / 16);
        this.ledUpdate[2] = (byte)(ledID % 16);
        this.ledUpdate[4] = (byte)(enabled ? 1 : 0);
        this.output.sendSysex(this.sysexHeader, this.ledUpdate);
    }

    private void handleSysEx(String data) {
        if (this.acknowledge.equalsIgnoreCase(data)) {
            this.scheduleTask(this::forceFlush, 3000L);
        }
    }

    static {
        MK1_NORMAL_LEDS.add(0);
        MK1_NORMAL_LEDS.add(2);
        MK1_NORMAL_LEDS.add(4);
        MK1_NORMAL_LEDS.add(7);
        MK1_NORMAL_LEDS.add(9);
        MK1_NORMAL_LEDS.add(10);
        MK1_NORMAL_LEDS.add(17);
        MK1_NORMAL_LEDS.add(13);
        MK1_NORMAL_LEDS.add(21);
        MK1_NORMAL_LEDS.add(12);
        MK1_NORMAL_LEDS.add(19);
        MK1_NORMAL_LEDS.add(27);
        MK1_NORMAL_LEDS.add(26);
        MK1_NORMAL_LEDS.add(29);
        MK1_NORMAL_LEDS.add(30);
        MK1_NORMAL_LEDS.add(33);
        MK1_NORMAL_LEDS.add(35);
        MK1_NORMAL_LEDS.add(37);
        MK1_NORMAL_LEDS.add(38);
        MK1_NORMAL_LEDS.add(40);
        MK1_NORMAL_LEDS.add(43);
        MK1_NORMAL_LEDS.add(45);
        MK1_NORMAL_LEDS.add(47);
        MK1_NORMAL_LEDS.add(49);
        MK1_NORMAL_LEDS.add(51);
        MK1_SHIFTED_LEDS.add(1);
        MK1_SHIFTED_LEDS.add(3);
        MK1_SHIFTED_LEDS.add(5);
        MK1_SHIFTED_LEDS.add(6);
        MK1_SHIFTED_LEDS.add(15);
        MK1_SHIFTED_LEDS.add(16);
        MK1_SHIFTED_LEDS.add(18);
        MK1_SHIFTED_LEDS.add(23);
        MK1_SHIFTED_LEDS.add(22);
        MK1_SHIFTED_LEDS.add(54);
        MK1_SHIFTED_LEDS.add(14);
        MK1_SHIFTED_LEDS.add(25);
        MK1_SHIFTED_LEDS.add(28);
        MK1_SHIFTED_LEDS.add(31);
        MK1_SHIFTED_LEDS.add(32);
        MK1_SHIFTED_LEDS.add(34);
        MK1_SHIFTED_LEDS.add(36);
        MK1_SHIFTED_LEDS.add(39);
        MK1_SHIFTED_LEDS.add(44);
        MK1_SHIFTED_LEDS.add(42);
        MK1_SHIFTED_LEDS.add(41);
        MK1_SHIFTED_LEDS.add(46);
        MK1_SHIFTED_LEDS.add(48);
        MK1_SHIFTED_LEDS.add(50);
        MK1_SHIFTED_LEDS.add(52);
        MK2_NORMAL_LEDS.add(0);
        MK2_NORMAL_LEDS.add(2);
        MK2_NORMAL_LEDS.add(4);
        MK2_NORMAL_LEDS.add(6);
        MK2_NORMAL_LEDS.add(8);
        MK2_NORMAL_LEDS.add(10);
        MK2_NORMAL_LEDS.add(12);
        MK2_NORMAL_LEDS.add(14);
        MK2_NORMAL_LEDS.add(16);
        MK2_NORMAL_LEDS.add(18);
        MK2_NORMAL_LEDS.add(20);
        MK2_NORMAL_LEDS.add(22);
        MK2_NORMAL_LEDS.add(24);
        MK2_NORMAL_LEDS.add(26);
        MK2_NORMAL_LEDS.add(28);
        MK2_NORMAL_LEDS.add(30);
        MK2_NORMAL_LEDS.add(32);
        MK2_NORMAL_LEDS.add(34);
        MK2_NORMAL_LEDS.add(36);
        MK2_NORMAL_LEDS.add(38);
        MK2_NORMAL_LEDS.add(40);
        MK2_NORMAL_LEDS.add(42);
        MK2_NORMAL_LEDS.add(44);
        MK2_NORMAL_LEDS.add(46);
        MK2_NORMAL_LEDS.add(48);
        MK2_NORMAL_LEDS.add(50);
        MK2_NORMAL_LEDS.add(52);
        MK2_NORMAL_LEDS.add(54);
        MK2_NORMAL_LEDS.add(56);
        MK2_NORMAL_LEDS.add(58);
        MK2_NORMAL_LEDS.add(59);
        MK2_NORMAL_LEDS.add(60);
        MK2_NORMAL_LEDS.add(61);
        MK2_NORMAL_LEDS.add(62);
        MK2_NORMAL_LEDS.add(63);
        MK2_NORMAL_LEDS.add(64);
        MK2_NORMAL_LEDS.add(65);
        MK2_SHIFTED_LEDS.add(1);
        MK2_SHIFTED_LEDS.add(3);
        MK2_SHIFTED_LEDS.add(5);
        MK2_SHIFTED_LEDS.add(7);
        MK2_SHIFTED_LEDS.add(9);
        MK2_SHIFTED_LEDS.add(11);
        MK2_SHIFTED_LEDS.add(13);
        MK2_SHIFTED_LEDS.add(15);
        MK2_SHIFTED_LEDS.add(17);
        MK2_SHIFTED_LEDS.add(19);
        MK2_SHIFTED_LEDS.add(21);
        MK2_SHIFTED_LEDS.add(23);
        MK2_SHIFTED_LEDS.add(25);
        MK2_SHIFTED_LEDS.add(27);
        MK2_SHIFTED_LEDS.add(29);
        MK2_SHIFTED_LEDS.add(31);
        MK2_SHIFTED_LEDS.add(33);
        MK2_SHIFTED_LEDS.add(35);
        MK2_SHIFTED_LEDS.add(37);
        MK2_SHIFTED_LEDS.add(39);
        MK2_SHIFTED_LEDS.add(41);
        MK2_SHIFTED_LEDS.add(43);
        MK2_SHIFTED_LEDS.add(45);
        MK2_SHIFTED_LEDS.add(47);
        MK2_SHIFTED_LEDS.add(49);
        MK2_SHIFTED_LEDS.add(51);
        MK2_SHIFTED_LEDS.add(53);
        MK2_SHIFTED_LEDS.add(55);
        MK2_SHIFTED_LEDS.add(57);
        MK2_SHIFTED_LEDS.add(66);
        MK2_SHIFTED_LEDS.add(67);
        MK2_SHIFTED_LEDS.add(68);
        MK2_SHIFTED_LEDS.add(69);
        MK2_SHIFTED_LEDS.add(70);
        MK2_SHIFTED_LEDS.add(71);
        MK2_SHIFTED_LEDS.add(72);
        MK2_SHIFTED_LEDS.add(73);
        MK1_BUTTON_LEDS.put(17, 8);
        MK1_BUTTON_LEDS.put(12, 0);
        MK1_BUTTON_LEDS.put(21, 9);
        MK1_BUTTON_LEDS.put(29, 11);
        MK1_BUTTON_LEDS.put(25, 12);
        MK1_BUTTON_LEDS.put(27, 29);
        MK1_BUTTON_LEDS.put(15, 20);
        MK1_BUTTON_LEDS.put(11, 24);
        MK1_BUTTON_LEDS.put(19, 28);
        MK1_BUTTON_LEDS.put(23, 27);
        MK1_BUTTON_LEDS.put(2, 45);
        MK1_BUTTON_LEDS.put(6, 47);
        MK1_BUTTON_LEDS.put(10, 49);
        MK1_BUTTON_LEDS.put(14, 51);
        MK1_BUTTON_LEDS.put(13, 10);
        MK1_BUTTON_LEDS.put(9, 17);
        MK1_BUTTON_LEDS.put(5, 13);
        MK1_BUTTON_LEDS.put(1, 21);
        MK1_BUTTON_LEDS.put(32, 19);
        MK1_BUTTON_LEDS.put(8, 2);
        MK1_BUTTON_LEDS.put(4, 4);
        MK1_BUTTON_LEDS.put(0, 6);
        MK1_BUTTON_LEDS.put(18, 37);
        MK1_BUTTON_LEDS.put(26, 40);
        MK1_BUTTON_LEDS.put(30, 43);
        MK1_BUTTON_LEDS.put(22, 38);
        MK1_BUTTON_LEDS.put(7, 33);
        MK1_BUTTON_LEDS.put(3, 35);
        MK1_BUTTON_LEDS.put(31, 30);
        MK1_SHIFTED_BUTTON_LEDS.put(17, 8);
        MK1_SHIFTED_BUTTON_LEDS.put(21, 15);
        MK1_SHIFTED_BUTTON_LEDS.put(29, 53);
        MK1_SHIFTED_BUTTON_LEDS.put(25, 54);
        MK1_SHIFTED_BUTTON_LEDS.put(27, 31);
        MK1_SHIFTED_BUTTON_LEDS.put(19, 26);
        MK1_SHIFTED_BUTTON_LEDS.put(2, 46);
        MK1_SHIFTED_BUTTON_LEDS.put(6, 48);
        MK1_SHIFTED_BUTTON_LEDS.put(10, 52);
        MK1_SHIFTED_BUTTON_LEDS.put(14, 50);
        MK1_SHIFTED_BUTTON_LEDS.put(13, 16);
        MK1_SHIFTED_BUTTON_LEDS.put(9, 18);
        MK1_SHIFTED_BUTTON_LEDS.put(5, 23);
        MK1_SHIFTED_BUTTON_LEDS.put(1, 22);
        MK1_SHIFTED_BUTTON_LEDS.put(32, 14);
        MK1_SHIFTED_BUTTON_LEDS.put(4, 5);
        MK1_SHIFTED_BUTTON_LEDS.put(0, 7);
        MK1_SHIFTED_BUTTON_LEDS.put(31, 32);
        MK2_BUTTON_LEDS.put(17, 9);
        MK2_BUTTON_LEDS.put(12, 0);
        MK2_BUTTON_LEDS.put(21, 10);
        MK2_BUTTON_LEDS.put(29, 12);
        MK2_BUTTON_LEDS.put(25, 14);
        MK2_BUTTON_LEDS.put(27, 26);
        MK2_BUTTON_LEDS.put(15, 30);
        MK2_BUTTON_LEDS.put(11, 32);
        MK2_BUTTON_LEDS.put(19, 28);
        MK2_BUTTON_LEDS.put(23, 34);
        MK2_BUTTON_LEDS.put(2, 56);
        MK2_BUTTON_LEDS.put(6, 54);
        MK2_BUTTON_LEDS.put(10, 52);
        MK2_BUTTON_LEDS.put(14, 50);
        MK2_BUTTON_LEDS.put(32, 16);
        MK2_BUTTON_LEDS.put(8, 2);
        MK2_BUTTON_LEDS.put(4, 4);
        MK2_BUTTON_LEDS.put(0, 6);
        MK2_BUTTON_LEDS.put(9, 22);
        MK2_BUTTON_LEDS.put(26, 38);
        MK2_BUTTON_LEDS.put(30, 48);
        MK2_BUTTON_LEDS.put(7, 42);
        MK2_BUTTON_LEDS.put(3, 44);
        MK2_BUTTON_LEDS.put(31, 36);
        MK2_BUTTON_LEDS.put(1, 18);
        MK2_BUTTON_LEDS.put(5, 20);
        MK2_BUTTON_LEDS.put(13, 24);
        MK2_BUTTON_LEDS.put(18, 40);
        MK2_BUTTON_LEDS.put(22, 46);
        MK2_BUTTON_LEDS.put(32, 16);
        MK2_BUTTON_LEDS.put(33, 58);
        MK2_BUTTON_LEDS.put(34, 59);
        MK2_BUTTON_LEDS.put(35, 60);
        MK2_BUTTON_LEDS.put(36, 61);
        MK2_BUTTON_LEDS.put(37, 62);
        MK2_BUTTON_LEDS.put(38, 63);
        MK2_BUTTON_LEDS.put(39, 64);
        MK2_BUTTON_LEDS.put(40, 65);
        MK2_SHIFTED_BUTTON_LEDS.put(17, 8);
        MK2_SHIFTED_BUTTON_LEDS.put(12, 1);
        MK2_SHIFTED_BUTTON_LEDS.put(21, 11);
        MK2_SHIFTED_BUTTON_LEDS.put(29, 13);
        MK2_SHIFTED_BUTTON_LEDS.put(25, 15);
        MK2_SHIFTED_BUTTON_LEDS.put(27, 27);
        MK2_SHIFTED_BUTTON_LEDS.put(15, 31);
        MK2_SHIFTED_BUTTON_LEDS.put(11, 33);
        MK2_SHIFTED_BUTTON_LEDS.put(19, 29);
        MK2_SHIFTED_BUTTON_LEDS.put(23, 35);
        MK2_SHIFTED_BUTTON_LEDS.put(2, 57);
        MK2_SHIFTED_BUTTON_LEDS.put(6, 55);
        MK2_SHIFTED_BUTTON_LEDS.put(10, 53);
        MK2_SHIFTED_BUTTON_LEDS.put(14, 51);
        MK2_SHIFTED_BUTTON_LEDS.put(32, 17);
        MK2_SHIFTED_BUTTON_LEDS.put(8, 3);
        MK2_SHIFTED_BUTTON_LEDS.put(4, 5);
        MK2_SHIFTED_BUTTON_LEDS.put(0, 7);
        MK2_SHIFTED_BUTTON_LEDS.put(9, 23);
        MK2_SHIFTED_BUTTON_LEDS.put(26, 39);
        MK2_SHIFTED_BUTTON_LEDS.put(30, 49);
        MK2_SHIFTED_BUTTON_LEDS.put(7, 43);
        MK2_SHIFTED_BUTTON_LEDS.put(3, 45);
        MK2_SHIFTED_BUTTON_LEDS.put(31, 37);
        MK2_SHIFTED_BUTTON_LEDS.put(1, 19);
        MK2_SHIFTED_BUTTON_LEDS.put(5, 21);
        MK2_SHIFTED_BUTTON_LEDS.put(13, 25);
        MK2_SHIFTED_BUTTON_LEDS.put(18, 41);
        MK2_SHIFTED_BUTTON_LEDS.put(22, 47);
        MK2_SHIFTED_BUTTON_LEDS.put(32, 17);
        MK2_SHIFTED_BUTTON_LEDS.put(33, 66);
        MK2_SHIFTED_BUTTON_LEDS.put(34, 67);
        MK2_SHIFTED_BUTTON_LEDS.put(35, 68);
        MK2_SHIFTED_BUTTON_LEDS.put(36, 69);
        MK2_SHIFTED_BUTTON_LEDS.put(37, 70);
        MK2_SHIFTED_BUTTON_LEDS.put(38, 71);
        MK2_SHIFTED_BUTTON_LEDS.put(39, 72);
        MK2_SHIFTED_BUTTON_LEDS.put(40, 73);
        ENTER_REMOTE_MODE = new byte[]{6, 85, -9};
        EXIT_REMOTE_MODE = new byte[]{0, -9};
    }
}

