/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.launchpad.view;

import de.mossgrabers.controller.novation.launchpad.LaunchpadConfiguration;
import de.mossgrabers.controller.novation.launchpad.controller.LaunchpadControlSurface;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.clip.INoteClip;
import de.mossgrabers.framework.daw.clip.NotePosition;
import de.mossgrabers.framework.featuregroup.IScrollableView;
import de.mossgrabers.framework.featuregroup.ViewManager;
import de.mossgrabers.framework.utils.ScrollStates;
import de.mossgrabers.framework.view.sequencer.AbstractNoteSequencerView;
import de.mossgrabers.framework.view.sequencer.AbstractSequencerView;

public class SequencerView
extends AbstractNoteSequencerView<LaunchpadControlSurface, LaunchpadConfiguration>
implements IScrollableView {
    private NotePosition noteEditPosition;

    public SequencerView(LaunchpadControlSurface surface, IModel model) {
        super("Sequencer", surface, model, true);
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        if (!this.isActive()) {
            return 0;
        }
        int ordinal = buttonID.ordinal();
        if (ordinal < ButtonID.SCENE1.ordinal() || ordinal > ButtonID.SCENE8.ordinal()) {
            return 0;
        }
        int scene = buttonID.ordinal() - ButtonID.SCENE1.ordinal();
        return scene == 7 - this.getResolutionIndex() ? 14 : 22;
    }

    @Override
    protected boolean handleSequencerAreaButtonCombinations(INoteClip clip, NotePosition notePosition, int row, int velocity) {
        boolean isUpPressed = ((LaunchpadControlSurface)this.surface).isPressed(ButtonID.UP);
        if (isUpPressed || ((LaunchpadControlSurface)this.surface).isPressed(ButtonID.DOWN)) {
            ((LaunchpadControlSurface)this.surface).setTriggerConsumed(isUpPressed ? ButtonID.UP : ButtonID.DOWN);
            if (velocity > 0) {
                this.handleSequencerAreaRepeatOperator(clip, notePosition, velocity, isUpPressed);
            }
            return true;
        }
        return super.handleSequencerAreaButtonCombinations(clip, notePosition, row, velocity);
    }

    @Override
    protected void handleSequencerArea(int index, int x, int y, int velocity) {
        if (velocity != 0) {
            this.noteEditPosition = null;
            return;
        }
        if (this.noteEditPosition != null) {
            this.editNote(this.getClip(), this.noteEditPosition, false);
        } else {
            super.handleSequencerArea(index, x, y, velocity);
        }
    }

    @Override
    public void onGridNoteLongPress(int note) {
        if (!this.isActive()) {
            return;
        }
        int index = note - 36;
        int y = index / 8;
        if (y >= this.numSequencerRows) {
            return;
        }
        this.noteEditPosition = new NotePosition(this.configuration.getMidiEditChannel(), index % 8, this.keyManager.map(y));
    }

    @Override
    public void updateScrollStates(ScrollStates scrollStates) {
        ViewManager viewManager = ((LaunchpadControlSurface)this.surface).getViewManager();
        INoteClip clip = ((AbstractSequencerView)AbstractSequencerView.class.cast(viewManager.getActive())).getClip();
        int seqOctave = this.scales.getOctave();
        scrollStates.setCanScrollLeft(clip.canScrollStepsBackwards());
        scrollStates.setCanScrollRight(clip.canScrollStepsForwards());
        scrollStates.setCanScrollUp(seqOctave < 4);
        scrollStates.setCanScrollDown(seqOctave > -4);
    }
}

