/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.launchpad.definition;

import de.mossgrabers.controller.novation.launchpad.controller.LaunchpadControlSurface;
import de.mossgrabers.controller.novation.launchpad.definition.ILaunchpadControllerDefinition;
import de.mossgrabers.controller.novation.launchpad.definition.button.ButtonSetup;
import de.mossgrabers.controller.novation.launchpad.definition.button.LaunchpadButton;
import de.mossgrabers.framework.controller.DefaultControllerDefinition;
import de.mossgrabers.framework.controller.grid.LightInfo;
import de.mossgrabers.framework.utils.StringUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

public abstract class AbstractLaunchpadDefinition
extends DefaultControllerDefinition
implements ILaunchpadControllerDefinition {
    protected final ButtonSetup buttonSetup = new ButtonSetup();

    protected AbstractLaunchpadDefinition(UUID uuid, String hardwareModel) {
        super(uuid, hardwareModel, "Novation", 1, 1);
        this.buttonSetup.setButton(LaunchpadButton.ARROW_UP, 91);
        this.buttonSetup.setButton(LaunchpadButton.ARROW_DOWN, 92);
        this.buttonSetup.setButton(LaunchpadButton.ARROW_LEFT, 93);
        this.buttonSetup.setButton(LaunchpadButton.ARROW_RIGHT, 94);
        this.buttonSetup.setButton(LaunchpadButton.SESSION, 95);
        this.buttonSetup.setButton(LaunchpadButton.NOTE, 96);
        this.buttonSetup.setButton(LaunchpadButton.DEVICE, 97);
        this.buttonSetup.setButton(LaunchpadButton.SHIFT, 98);
        this.buttonSetup.setButton(LaunchpadButton.SCENE1, 89);
        this.buttonSetup.setButton(LaunchpadButton.SCENE2, 79);
        this.buttonSetup.setButton(LaunchpadButton.SCENE3, 69);
        this.buttonSetup.setButton(LaunchpadButton.SCENE4, 59);
        this.buttonSetup.setButton(LaunchpadButton.SCENE5, 49);
        this.buttonSetup.setButton(LaunchpadButton.SCENE6, 39);
        this.buttonSetup.setButton(LaunchpadButton.SCENE7, 29);
        this.buttonSetup.setButton(LaunchpadButton.SCENE8, 19);
    }

    @Override
    public boolean isPro() {
        return false;
    }

    @Override
    public boolean hasTrackSelectionButtons() {
        return false;
    }

    @Override
    public void resetMode(LaunchpadControlSurface surface) {
        surface.sendLaunchpadSysEx("0E 00");
    }

    @Override
    public void setLogoColor(LaunchpadControlSurface surface, int color) {
        surface.setTrigger(99, color);
    }

    @Override
    public boolean sceneButtonsUseCC() {
        return true;
    }

    @Override
    public ButtonSetup getButtonSetup() {
        return this.buttonSetup;
    }

    @Override
    public List<String> buildLEDUpdate(Map<Integer, LightInfo> padInfos) {
        StringBuilder sb = new StringBuilder(this.getSysExHeader()).append("03 ");
        for (Map.Entry<Integer, LightInfo> e : padInfos.entrySet()) {
            int note = e.getKey();
            LightInfo info = e.getValue();
            if (info.getBlinkColor() <= 0) {
                sb.append("00 ").append(StringUtils.toHexStr(note)).append(' ').append(StringUtils.toHexStr(info.getColor())).append(' ');
                continue;
            }
            if (info.isFast()) {
                sb.append("01 ").append(StringUtils.toHexStr(note)).append(' ').append(StringUtils.toHexStr(info.getBlinkColor())).append(' ').append(StringUtils.toHexStr(info.getColor())).append(' ');
                continue;
            }
            sb.append("02 ").append(StringUtils.toHexStr(note)).append(' ').append(StringUtils.toHexStr(info.getColor())).append(' ');
        }
        return Collections.singletonList(sb.append("F7").toString());
    }

    @Override
    public Optional<String> getBrightnessSysex() {
        return Optional.empty();
    }
}

