/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.launchkey.mini.view;

import de.mossgrabers.controller.novation.launchkey.mini.LaunchkeyMiniMk3Configuration;
import de.mossgrabers.controller.novation.launchkey.mini.controller.LaunchkeyMiniMk3ControlSurface;
import de.mossgrabers.controller.novation.launchkey.mini.controller.LaunchkeyPadGrid;
import de.mossgrabers.controller.novation.launchkey.mini.view.SessionView;
import de.mossgrabers.framework.command.trigger.clip.QuantizeCommand;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.display.IDisplay;
import de.mossgrabers.framework.daw.IApplication;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.daw.data.IScene;
import de.mossgrabers.framework.daw.data.bank.ISceneBank;
import de.mossgrabers.framework.featuregroup.AbstractView;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.Views;

public class PadModeSelectView
extends AbstractView<LaunchkeyMiniMk3ControlSurface, LaunchkeyMiniMk3Configuration> {
    private static final String[] PAD_MODE_NAMES = new String[]{"Clips", "Record Arm", "Track Select", "Mute", "Solo", "Stop Clips"};
    private final QuantizeCommand<LaunchkeyMiniMk3ControlSurface, LaunchkeyMiniMk3Configuration> quantizeCommand;
    private boolean isConsumed = false;

    public PadModeSelectView(LaunchkeyMiniMk3ControlSurface surface, IModel model) {
        super("Pad Mode Select", surface, model);
        this.quantizeCommand = new QuantizeCommand(model, surface);
    }

    @Override
    public void drawGrid() {
        LaunchkeyPadGrid pads = ((LaunchkeyMiniMk3ControlSurface)this.surface).getPadGrid();
        ITransport transport = this.model.getTransport();
        pads.lightEx(0, 0, transport.isMetronomeOn() ? 21 : 23);
        pads.lightEx(1, 0, 47);
        pads.lightEx(2, 0, 7);
        pads.lightEx(3, 0, 7);
        pads.lightEx(4, 0, 3);
        pads.lightEx(5, 0, 12);
        pads.lightEx(6, 0, 12);
        pads.lightEx(7, 0, 12);
        SessionView view = (SessionView)((LaunchkeyMiniMk3ControlSurface)this.surface).getViewManager().get(Views.SESSION);
        Modes padMode = view.getPadMode();
        pads.lightEx(0, 1, padMode == null ? 21 : 23);
        pads.lightEx(1, 1, padMode == Modes.REC_ARM ? 5 : 7);
        pads.lightEx(2, 1, padMode == Modes.TRACK_SELECT ? 3 : 1);
        pads.lightEx(3, 1, padMode == Modes.MUTE ? 9 : 11);
        pads.lightEx(4, 1, padMode == Modes.SOLO ? 13 : 15);
        pads.lightEx(5, 1, padMode == Modes.STOP_CLIP ? 57 : 4);
        pads.lightEx(6, 1, 0);
        pads.lightEx(7, 1, 0);
    }

    @Override
    public void onGridNote(int note, int velocity) {
        if (velocity == 0) {
            return;
        }
        IDisplay display = ((LaunchkeyMiniMk3ControlSurface)this.surface).getDisplay();
        ITransport transport = this.model.getTransport();
        IApplication application = this.model.getApplication();
        int index = note - 36;
        switch (index) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                SessionView view = (SessionView)((LaunchkeyMiniMk3ControlSurface)this.surface).getViewManager().get(Views.SESSION);
                view.setPadMode(index == 0 ? null : SessionView.PAD_MODES.get(index - 1));
                display.notify(PAD_MODE_NAMES[index]);
                break;
            }
            case 8: {
                transport.toggleMetronome();
                this.mvHelper.delayDisplay(() -> transport.isMetronomeOn() ? "Metronome: On" : "Metronome: Off");
                break;
            }
            case 9: {
                transport.tapTempo();
                this.mvHelper.notifyTempo();
                break;
            }
            case 10: {
                application.undo();
                display.notify("Undo");
                break;
            }
            case 11: {
                application.redo();
                display.notify("Redo");
                break;
            }
            case 12: {
                this.quantizeCommand.executeNormal(ButtonEvent.UP);
                display.notify("Quantize");
                break;
            }
            case 13: {
                application.addInstrumentTrack();
                display.notify("Add Instrument Track");
                break;
            }
            case 14: {
                application.addAudioTrack();
                display.notify("Add Audio Track");
                break;
            }
            case 15: {
                application.addEffectTrack();
                display.notify("Add Effect Track");
                break;
            }
        }
        this.isConsumed = true;
    }

    @Override
    public void onButton(ButtonID buttonID, ButtonEvent event, int velocity) {
        if (!ButtonID.isSceneButton(buttonID)) {
            return;
        }
        if (event == ButtonEvent.UP) {
            ((LaunchkeyMiniMk3ControlSurface)this.surface).getViewManager().restore();
            if (this.isConsumed) {
                return;
            }
            ISceneBank sceneBank = this.model.getCurrentTrackBank().getSceneBank();
            int index = buttonID.ordinal() - ButtonID.SCENE1.ordinal();
            IScene scene = (IScene)sceneBank.getItem(index);
            scene.select();
            scene.launch(true, false);
        } else if (event == ButtonEvent.LONG) {
            this.isConsumed = true;
        }
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        if (buttonID == ButtonID.SCENE2) {
            return 3;
        }
        return 0;
    }

    @Override
    public void onActivate() {
        this.isConsumed = false;
    }
}

