/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.maschine.mk3.view;

import de.mossgrabers.controller.ni.maschine.mk3.controller.MaschineControlSurface;
import de.mossgrabers.controller.ni.maschine.mk3.view.BaseView;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.grid.IPadGrid;
import de.mossgrabers.framework.daw.DAWColor;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.utils.ButtonEvent;

public class MuteView
extends BaseView {
    public MuteView(MaschineControlSurface surface, IModel model) {
        super("Mute", surface, model);
    }

    @Override
    public void executeFunction(int padIndex, ButtonEvent buttonEvent) {
        if (buttonEvent != ButtonEvent.DOWN) {
            return;
        }
        ITrack track = (ITrack)this.model.getCurrentTrackBank().getItem(padIndex);
        if (this.isButtonCombination(ButtonID.DUPLICATE)) {
            track.duplicate();
            return;
        }
        if (this.isButtonCombination(ButtonID.DELETE)) {
            track.remove();
            return;
        }
        track.toggleMute();
    }

    @Override
    public void drawGrid() {
        IPadGrid padGrid = ((MaschineControlSurface)this.surface).getPadGrid();
        ITrackBank tb = this.model.getCurrentTrackBank();
        for (int i = 0; i < 16; ++i) {
            ITrack item = (ITrack)tb.getItem(i);
            int x = i % 4;
            int y = 3 - i / 4;
            if (item.doesExist()) {
                int colorIndex = this.colorManager.getColorIndex(DAWColor.getColorID(item.getColor()));
                if (item.isMute()) {
                    padGrid.lightEx(x, y, colorIndex, 76, false);
                    continue;
                }
                padGrid.lightEx(x, y, colorIndex);
                continue;
            }
            padGrid.lightEx(x, y, "BUTTON_COLOR_OFF");
        }
    }
}

