/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.kontrol.mki.mode;

import de.mossgrabers.controller.ni.kontrol.mki.Kontrol1Configuration;
import de.mossgrabers.controller.ni.kontrol.mki.controller.Kontrol1ControlSurface;
import de.mossgrabers.controller.ni.kontrol.mki.mode.IKontrol1Mode;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IItem;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.IBank;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.featuregroup.AbstractParameterMode;
import de.mossgrabers.framework.parameterprovider.IParameterProvider;
import java.util.Optional;

public abstract class AbstractKontrol1Mode<B extends IItem>
extends AbstractParameterMode<Kontrol1ControlSurface, Kontrol1Configuration, B>
implements IKontrol1Mode {
    protected AbstractKontrol1Mode(String name, Kontrol1ControlSurface surface, IModel model) {
        super(name, surface, model);
    }

    protected AbstractKontrol1Mode(String name, Kontrol1ControlSurface surface, IModel model, IBank<B> bank) {
        super(name, surface, model, false, bank, DEFAULT_KNOB_IDS);
    }

    @Override
    public void onKnobValue(int index, int value) {
        IParameterProvider parameterProvider = this.getParameterProvider();
        if (parameterProvider != null) {
            parameterProvider.get(index).changeValue(value);
        }
    }

    @Override
    public String getButtonColorID(ButtonID buttonID) {
        Optional t = this.model.getCurrentTrackBank().getSelectedItem();
        switch (buttonID) {
            case MUTE: {
                return t.isPresent() && ((ITrack)t.get()).isMute() ? "BUTTON_STATE_HI" : "BUTTON_STATE_ON";
            }
            case SOLO: {
                return t.isPresent() && ((ITrack)t.get()).isSolo() ? "BUTTON_STATE_HI" : "BUTTON_STATE_ON";
            }
            case BROWSE: {
                return "BUTTON_STATE_ON";
            }
        }
        return "BUTTON_STATE_OFF";
    }

    @Override
    public void onMainKnob(int value) {
        if (this.model.getValueChanger().isIncrease(value)) {
            this.selectNextItem();
        } else {
            this.selectPreviousItem();
        }
    }

    @Override
    public void onMainKnobPressed() {
        this.model.toggleCurrentTrackBank();
        ITrackBank tb = this.model.getCurrentTrackBank();
        Optional track = tb.getSelectedItem();
        if (track.isEmpty()) {
            ((ITrack)tb.getItem(0)).select();
        }
    }

    @Override
    public void onBack() {
        Optional selectedTrack = this.model.getCurrentTrackBank().getSelectedItem();
        if (selectedTrack.isEmpty()) {
            return;
        }
        if (((Kontrol1ControlSurface)this.surface).isShiftPressed()) {
            ((ITrack)selectedTrack.get()).toggleMonitor();
        } else {
            ((ITrack)selectedTrack.get()).toggleMute();
        }
    }

    @Override
    public void onEnter() {
        Optional selectedTrack = this.model.getCurrentTrackBank().getSelectedItem();
        if (selectedTrack.isEmpty()) {
            return;
        }
        if (((Kontrol1ControlSurface)this.surface).isShiftPressed()) {
            ((ITrack)selectedTrack.get()).toggleRecArm();
        } else {
            ((ITrack)selectedTrack.get()).toggleSolo();
        }
    }

    protected static String getSecondLineText(ITrack track) {
        if (track.isMute()) {
            return "-MUTED-";
        }
        return track.isSolo() ? "-SOLO-" : track.getVolumeStr(8);
    }
}

