/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.mackie.hui.mode.track;

import de.mossgrabers.controller.mackie.hui.HUIConfiguration;
import de.mossgrabers.controller.mackie.hui.controller.HUIControlSurface;
import de.mossgrabers.controller.mackie.hui.mode.HUIMode;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.mode.track.DefaultTrackMode;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.StringUtils;
import java.util.Optional;

public abstract class AbstractTrackMode
extends DefaultTrackMode<HUIControlSurface, HUIConfiguration>
implements HUIMode {
    protected AbstractTrackMode(String name, HUIControlSurface surface, IModel model) {
        super(name, surface, model, false);
    }

    protected ITextDisplay drawTrackHeader() {
        ITextDisplay d = ((HUIControlSurface)this.surface).getTextDisplay().clear();
        for (int i = 0; i < 8; ++i) {
            Optional<ITrack> track = this.getTrack(i);
            if (!track.isPresent()) continue;
            d.setCell(0, i, StringUtils.shortenAndFixASCII(track.get().getName(), 4));
        }
        return d;
    }

    @Override
    public void onButton(int row, int index, ButtonEvent event) {
        if (row == 0) {
            this.resetParameter(index);
        }
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        for (int i = 0; i < 8; ++i) {
            Optional<ITrack> track = this.getTrack(i);
            boolean exists = track.isPresent();
            if (buttonID == ButtonID.get(ButtonID.ROW_SELECT_1, i) || buttonID == ButtonID.get(ButtonID.ROW5_1, i)) {
                return exists && track.get().isSelected() ? 127 : 0;
            }
            if (buttonID == ButtonID.get(ButtonID.ROW2_1, i)) {
                return exists && track.get().isRecArm() ? 127 : 0;
            }
            if (buttonID == ButtonID.get(ButtonID.ROW3_1, i)) {
                return exists && track.get().isSolo() ? 127 : 0;
            }
            if (buttonID != ButtonID.get(ButtonID.ROW4_1, i)) continue;
            return exists && track.get().isMute() ? 127 : 0;
        }
        return 0;
    }

    @Override
    protected Optional<ITrack> getTrack(int index) {
        int extenderOffset = ((HUIControlSurface)this.surface).getExtenderOffset();
        return super.getTrack(extenderOffset + index);
    }
}

