/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.intuitiveinstruments.exquis.controller;

import de.mossgrabers.controller.intuitiveinstruments.exquis.ExquisConfiguration;
import de.mossgrabers.controller.intuitiveinstruments.exquis.controller.ExquisPadGrid;
import de.mossgrabers.controller.intuitiveinstruments.exquis.controller.ISysexCallback;
import de.mossgrabers.framework.controller.AbstractControlSurface;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.controller.grid.IPadGrid;
import de.mossgrabers.framework.controller.hardware.BindType;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.framework.utils.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class ExquisControlSurface
extends AbstractControlSurface<ExquisConfiguration> {
    public static final List<ContinuousID> KNOBS = ContinuousID.createSequentialList(ContinuousID.KNOB1, 4);
    private static final int CMD_START_POS = 5;
    private static final int[] SYSEX_HEADER = new int[]{240, 0, 33, 126, 127};
    public static final int TOUCHSTRIP_P1 = 80;
    public static final int TOUCHSTRIP_P2 = 81;
    public static final int TOUCHSTRIP_P3 = 82;
    public static final int TOUCHSTRIP_P4 = 83;
    public static final int TOUCHSTRIP_P5 = 84;
    public static final int TOUCHSTRIP_P6 = 85;
    public static final int TOUCHSTRIP = 90;
    public static final int BUTTON_RECORD = 102;
    public static final int BUTTON_REPEAT = 103;
    public static final int BUTTON_SESSION = 104;
    public static final int BUTTON_PLAY_STOP = 105;
    public static final int BUTTON_DOWN = 106;
    public static final int BUTTON_UP = 107;
    public static final int BUTTON_LEFT = 108;
    public static final int BUTTON_RIGHT = 109;
    public static final int FIRST_KNOB = 110;
    public static final int BUTTON_KNOB1 = 114;
    public static final int BUTTON_KNOB2 = 115;
    public static final int BUTTON_KNOB3 = 116;
    public static final int BUTTON_KNOB4 = 117;
    public static final int DEV_MODE_OFF = 0;
    public static final int DEV_MODE_PLAY_MODE = 34;
    public static final int DEV_MODE_FULL = 63;
    public static final int CMD_DEVELOPER_MODE = 0;
    public static final int CMD_USE_CUSTOM_SCALE_LIST = 1;
    public static final int CMD_COLOR_PALETTE = 2;
    public static final int CMD_REFRESH = 3;
    public static final int CMD_SET_LED_COLOR = 4;
    public static final int CMD_TEMPO = 5;
    public static final int CMD_ROOT_NOTE = 6;
    public static final int CMD_SCALE_NUMBER = 7;
    public static final int CMD_CUSTOM_SCALE = 8;
    public static final int CMD_SNAPSHOT = 9;
    public static final int CMD_ENCODERS_SNAPSHOT = 10;
    private final ISysexCallback callback;
    private int requestTrackSettings = -1;

    public ExquisControlSurface(IHost host, ColorManager colorManager, ExquisConfiguration configuration, IMidiOutput output, IMidiInput input, IPadGrid padGrid, ISysexCallback callback) {
        super(host, configuration, colorManager, output, input, padGrid, 100.0, 200.0);
        ((ExquisPadGrid)padGrid).setSurface(this);
        this.callback = callback;
        this.input.setSysexCallback(this::handleSysEx);
    }

    public void configureDeveloperMode(int configurationMask) {
        this.sendSysex(0, new byte[]{(byte)configurationMask});
    }

    public void setLED(int ledID, ColorEx color) {
        this.setLED(ledID, color, 0);
    }

    public void setLED(int ledID, ColorEx color, int fx) {
        int[] intRGB127 = color.toIntRGB127();
        byte[] params = new byte[]{(byte)ledID, (byte)intRGB127[0], (byte)intRGB127[1], (byte)intRGB127[2], (byte)fx};
        this.sendSysex(4, params);
    }

    public void updateTempo(int tempo) {
        byte[] params = new byte[]{(byte)(tempo >> 7), (byte)(tempo & 0x7F)};
        this.sendSysex(5, params);
    }

    public void updateRootNote(int scaleOffset) {
        this.sendSysex(6, new byte[]{(byte)scaleOffset});
    }

    public void updateScale(int scaleIndex) {
        this.sendSysex(7, new byte[]{(byte)scaleIndex});
    }

    public void sendTrackSettings(byte[] settings) {
        this.sendSysex(9, settings);
    }

    public void requestTrackSettings(int trackPosition) {
        this.requestTrackSettings = trackPosition;
        this.sendSysex(9, new byte[0]);
    }

    private void sendSysex(int command, byte[] content) {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            for (int element : SYSEX_HEADER) {
                out.write(element);
            }
            out.write(command);
            out.write(content);
            out.write(-9);
            this.output.sendSysex(new byte[][]{out.toByteArray()});
        }
        catch (IOException ex) {
            this.host.error("Could send sysex to Exquis.", ex);
        }
    }

    private void handleSysEx(String dataStr) {
        int[] data = StringUtils.fromHexStr(dataStr);
        if (Arrays.compareUnsigned(SYSEX_HEADER, 0, SYSEX_HEADER.length, data, 0, SYSEX_HEADER.length) != 0) {
            return;
        }
        switch (data[5]) {
            case 3: {
                this.forceFlush();
                break;
            }
            case 5: {
                int tempo = (data[6] << 7) + data[7];
                this.callback.updateTempo(tempo);
                break;
            }
            case 6: {
                String noteName = Scales.NOTE_NAMES.get(data[6]);
                ((ExquisConfiguration)this.configuration).setScaleBase(noteName);
                this.host.showNotification("Base Note: " + noteName);
                break;
            }
            case 7: {
                String scale = ExquisConfiguration.EXQUISE_SCALES[data[6]];
                ((ExquisConfiguration)this.configuration).setScale(scale);
                this.host.showNotification("Scale: " + scale);
                break;
            }
            case 9: {
                if (data.length != 262) break;
                byte[] settings = new byte[255];
                for (int i = 0; i < 255; ++i) {
                    settings[i] = (byte)data[6 + i];
                }
                this.callback.storeTrackSettings(this.requestTrackSettings, settings);
                this.requestTrackSettings = -1;
                break;
            }
        }
    }

    @Override
    public void setTrigger(BindType bindType, int channel, int cc, int value) {
        this.setLED(cc, this.colorManager.getColor(value, null));
    }

    @Override
    protected void handleMidi(int status, int data1, int data2) {
    }

    @Override
    protected void internalShutdown() {
        this.configureDeveloperMode(0);
    }

    @Override
    protected void flushHardware() {
        if (!this.isShuttingDown) {
            super.flushHardware();
        }
    }
}

