/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.generic.flexihandler;

import de.mossgrabers.controller.generic.GenericFlexiConfiguration;
import de.mossgrabers.controller.generic.command.trigger.ToggleKnobSpeedCommand;
import de.mossgrabers.controller.generic.controller.FlexiCommand;
import de.mossgrabers.controller.generic.controller.GenericFlexiControlSurface;
import de.mossgrabers.controller.generic.flexihandler.AbstractHandler;
import de.mossgrabers.controller.generic.flexihandler.utils.FlexiHandlerException;
import de.mossgrabers.controller.generic.flexihandler.utils.KnobMode;
import de.mossgrabers.controller.generic.flexihandler.utils.MidiValue;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.utils.ButtonEvent;

public class GlobalHandler
extends AbstractHandler {
    private final ToggleKnobSpeedCommand<GenericFlexiControlSurface, GenericFlexiConfiguration> knobSpeedCommand;

    public GlobalHandler(IModel model, GenericFlexiControlSurface surface, GenericFlexiConfiguration configuration, IValueChanger absoluteLowResValueChanger, IValueChanger signedBitRelativeValueChanger, IValueChanger signedBit2RelativeValueChanger, IValueChanger offsetBinaryRelativeValueChanger) {
        super(model, surface, configuration, absoluteLowResValueChanger, signedBitRelativeValueChanger, signedBit2RelativeValueChanger, offsetBinaryRelativeValueChanger);
        this.knobSpeedCommand = new ToggleKnobSpeedCommand(this.model, surface);
    }

    @Override
    public FlexiCommand[] getSupportedCommands() {
        return new FlexiCommand[]{FlexiCommand.GLOBAL_UNDO, FlexiCommand.GLOBAL_REDO, FlexiCommand.GLOBAL_PREVIOUS_PROJECT, FlexiCommand.GLOBAL_NEXT_PROJECT, FlexiCommand.GLOBAL_TOGGLE_AUDIO_ENGINE, FlexiCommand.GLOBAL_SHIFT_BUTTON};
    }

    @Override
    public int getCommandValue(FlexiCommand command) {
        switch (command) {
            case GLOBAL_TOGGLE_AUDIO_ENGINE: {
                return GlobalHandler.toMidiValue(this.model.getApplication().isEngineActive());
            }
            case GLOBAL_SHIFT_BUTTON: {
                return GlobalHandler.toMidiValue(this.surface.isShiftPressed());
            }
        }
        return -1;
    }

    @Override
    public void handle(FlexiCommand command, KnobMode knobMode, MidiValue value) {
        boolean isButtonPressed = this.isButtonPressed(knobMode, value);
        switch (command) {
            case GLOBAL_UNDO: {
                if (!isButtonPressed) break;
                this.model.getApplication().undo();
                break;
            }
            case GLOBAL_REDO: {
                if (!isButtonPressed) break;
                this.model.getApplication().redo();
                break;
            }
            case GLOBAL_PREVIOUS_PROJECT: {
                if (!isButtonPressed) break;
                this.model.getProject().previous();
                break;
            }
            case GLOBAL_NEXT_PROJECT: {
                if (!isButtonPressed) break;
                this.model.getProject().next();
                break;
            }
            case GLOBAL_TOGGLE_AUDIO_ENGINE: {
                if (!isButtonPressed) break;
                this.model.getApplication().toggleEngineActive();
                break;
            }
            case GLOBAL_SHIFT_BUTTON: {
                this.surface.setShiftPressed(isButtonPressed);
                this.knobSpeedCommand.execute(isButtonPressed ? ButtonEvent.DOWN : ButtonEvent.UP, isButtonPressed ? 127 : 0);
                break;
            }
            default: {
                throw new FlexiHandlerException(command);
            }
        }
    }
}

