/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.faderfox.ec4;

import de.mossgrabers.controller.faderfox.ec4.EC4Configuration;
import de.mossgrabers.controller.faderfox.ec4.controller.EC4ControlSurface;
import de.mossgrabers.controller.faderfox.ec4.controller.EC4Display;
import de.mossgrabers.controller.faderfox.ec4.mode.EC4ParametersMode;
import de.mossgrabers.controller.faderfox.ec4.mode.EC4TrackMode;
import de.mossgrabers.controller.faderfox.ec4.mode.EC4TwelveMode;
import de.mossgrabers.framework.command.trigger.mode.ButtonRowModeCommand;
import de.mossgrabers.framework.configuration.ISettingsUI;
import de.mossgrabers.framework.controller.AbstractControllerSetup;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.controller.ISetupFactory;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.controller.hardware.BindType;
import de.mossgrabers.framework.controller.hardware.IHwRelativeKnob;
import de.mossgrabers.framework.controller.valuechanger.TwosComplementValueChanger;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.ModelSetup;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.daw.midi.IMidiAccess;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.featuregroup.ViewManager;
import de.mossgrabers.framework.mode.DummyMode;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.DummyView;
import de.mossgrabers.framework.view.Views;

public class EC4ControllerSetup
extends AbstractControllerSetup<EC4ControlSurface, EC4Configuration> {
    public EC4ControllerSetup(IHost host, ISetupFactory factory, ISettingsUI globalSettings, ISettingsUI documentSettings) {
        super(factory, host, globalSettings, documentSettings);
        this.colorManager = new ColorManager();
        this.colorManager.registerColor(0, ColorEx.BLACK);
        this.colorManager.registerColor(1, ColorEx.DARK_RED);
        this.colorManager.registerColor(127, ColorEx.RED);
        this.colorManager.registerColorIndex("BUTTON_COLOR_OFF", 0);
        this.colorManager.registerColorIndex("BUTTON_COLOR_ON", 127);
        this.colorManager.registerColorIndex("BUTTON_STATE_OFF", 0);
        this.colorManager.registerColorIndex("BUTTON_STATE_ON", 1);
        this.colorManager.registerColorIndex("BUTTON_STATE_HI", 127);
        this.valueChanger = new TwosComplementValueChanger(1024, 10);
        this.configuration = new EC4Configuration(host, this.valueChanger, factory.getArpeggiatorModes());
    }

    @Override
    protected void createModel() {
        ModelSetup ms = new ModelSetup();
        ms.enableMainDrumDevice(false);
        ms.setNumTracks(12);
        ms.setHasFullFlatTrackList(true);
        ms.setNumScenes(12);
        ms.setNumFilterColumnEntries(0);
        ms.setNumResults(0);
        ms.setNumDeviceLayers(0);
        ms.setNumDrumPadLayers(0);
        this.model = this.factory.createModel(this.configuration, this.colorManager, this.valueChanger, this.scales, ms);
        ITrackBank trackBank = this.model.getTrackBank();
        trackBank.setIndication(true);
        trackBank.addSelectionObserver((index, isSelected) -> this.handleTrackChange(isSelected));
    }

    @Override
    protected void createSurface() {
        IMidiAccess midiAccess = this.factory.createMidiAccess();
        IMidiOutput output = midiAccess.createOutput(0);
        IMidiInput input = midiAccess.createInput(0, null, new String[0]);
        for (int i = 0; i < 15; ++i) {
            input.createNoteInput("Channel " + (i + 1), String.format("?%X????", i));
        }
        EC4ControlSurface surface = new EC4ControlSurface(this.host, this.colorManager, (EC4Configuration)this.configuration, output, input);
        this.surfaces.add(surface);
        surface.addTextDisplay(new EC4Display(this.host, output, 0));
        surface.addTextDisplay(new EC4Display(this.host, output, 3));
        surface.getModeManager().setDefaultID(Modes.VOLUME);
    }

    @Override
    protected void createModes() {
        EC4ControlSurface surface = (EC4ControlSurface)this.getSurface();
        ModeManager modeManager = surface.getModeManager();
        modeManager.register(Modes.TRACK, new EC4TrackMode(surface, this.model));
        modeManager.register(Modes.TRACK_DETAILS, new EC4TwelveMode(surface, this.model));
        modeManager.register(Modes.DEVICE_PARAMS, new EC4ParametersMode(surface, this.model));
        modeManager.register(Modes.DUMMY, new DummyMode(surface, this.model, EC4ControlSurface.KNOB_IDS));
    }

    @Override
    protected void createViews() {
        EC4ControlSurface surface = (EC4ControlSurface)this.getSurface();
        ViewManager viewManager = surface.getViewManager();
        viewManager.register(Views.DUMMY1, new DummyView("", surface, this.model));
    }

    @Override
    protected void createObservers() {
        super.createObservers();
        ((EC4Configuration)this.configuration).addSettingObserver(EC4Configuration.SETUP_SLOT, () -> ((EC4ControlSurface)this.getSurface()).setSetupSlot(((EC4Configuration)this.configuration).getSetupSlot()));
        ((EC4Configuration)this.configuration).registerDeactivatedItemsHandler(this.model);
    }

    @Override
    protected void registerTriggerCommands() {
        int i;
        EC4ControlSurface surface = (EC4ControlSurface)this.getSurface();
        for (i = 0; i < 16; ++i) {
            ButtonID buttonID = ButtonID.get(ButtonID.PAD1, i);
            int label = i + 1;
            int cc = 30 + i;
            ButtonRowModeCommand command = new ButtonRowModeCommand(i / 4, i % 4, this.model, surface);
            this.addButton(surface, buttonID, "Button " + label, command, 15, cc);
        }
        for (i = 0; i < 4; ++i) {
            int index = i;
            surface.createButton(ButtonID.get(ButtonID.FOOTSWITCH1, i), "Action " + (i + 1)).bind((event, velocity) -> {
                String assignableActionID;
                if (event == ButtonEvent.DOWN && (assignableActionID = ((EC4Configuration)this.configuration).getAssignableAction(index)) != null) {
                    this.model.getApplication().invokeAction(assignableActionID);
                }
            });
        }
    }

    @Override
    protected void registerContinuousCommands() {
        for (int i = 0; i < 16; ++i) {
            ContinuousID knobID = ContinuousID.get(ContinuousID.KNOB1, i);
            int label = i + 1;
            int cc = 10 + i;
            IHwRelativeKnob ctrl = this.addRelativeKnob(knobID, "Knob " + label, null, BindType.CC, 15, cc);
            if (i >= 12) continue;
            ctrl.setIndexInGroup(i);
        }
    }

    @Override
    protected void layoutControls() {
        EC4ControlSurface surface = (EC4ControlSurface)this.getSurface();
        double padding = 6.0;
        double width = 100.0;
        double height = 100.0;
        double offsetY = 100.0;
        surface.getTextDisplay().getHardwareDisplay().setBounds(6.0, 6.0, 848.0, 94.0);
        for (int i = 0; i < 16; ++i) {
            int col = i / 4;
            int row = i % 4;
            double x = 6.0 + (double)col * 106.0;
            double y = 106.0 + (double)(2 * row) * 106.0;
            ContinuousID knobID = ContinuousID.get(ContinuousID.KNOB1, i);
            surface.getContinuous(knobID).setBounds(x, y, 100.0, 100.0);
            ButtonID buttonID = ButtonID.get(ButtonID.PAD1, i);
            surface.getButton(buttonID).setBounds(x, y + 100.0 + 6.0, 100.0, 100.0);
        }
    }

    @Override
    public void startup() {
        EC4ControlSurface surface = (EC4ControlSurface)this.getSurface();
        surface.getViewManager().setActive(Views.DUMMY1);
        surface.getModeManager().setActive(Modes.DUMMY);
        surface.requestDeviceInfo();
    }
}

