/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.akai.fire.view;

import de.mossgrabers.controller.akai.fire.FireConfiguration;
import de.mossgrabers.controller.akai.fire.controller.FireControlSurface;
import de.mossgrabers.controller.akai.fire.view.IFireView;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.clip.INoteClip;
import de.mossgrabers.framework.daw.clip.NotePosition;
import de.mossgrabers.framework.daw.data.ICursorTrack;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.sequencer.AbstractNoteSequencerView;

public class SequencerView
extends AbstractNoteSequencerView<FireControlSurface, FireConfiguration>
implements IFireView {
    public SequencerView(FireControlSurface surface, IModel model) {
        super("Sequencer", surface, model, 16, 4, true);
        this.numDisplayRows = 4;
    }

    @Override
    public void onGridNoteLongPress(int note) {
        if (!this.isActive()) {
            return;
        }
        int index = note - 36;
        ((FireControlSurface)this.surface).getButton(ButtonID.get(ButtonID.PAD1, index)).setConsumed();
        int y = index / this.clipCols;
        if (y >= this.numSequencerRows) {
            return;
        }
        NotePosition notePosition = new NotePosition(this.configuration.getMidiEditChannel(), index % this.clipCols, this.keyManager.map(y));
        this.editNote(this.getClip(), notePosition, false);
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        switch (buttonID) {
            case SCENE1: 
            case SCENE2: 
            case SCENE3: 
            case SCENE4: {
                return 0;
            }
        }
        return super.getButtonColor(buttonID);
    }

    @Override
    public int getSoloButtonColor(int index) {
        ICursorTrack cursorTrack = this.model.getCursorTrack();
        switch (index) {
            case 0: {
                return 0;
            }
            case 1: {
                return cursorTrack.doesExist() && cursorTrack.isMute() ? 3 : 0;
            }
            case 2: {
                return cursorTrack.doesExist() && cursorTrack.isSolo() ? 4 : 0;
            }
            case 3: {
                return cursorTrack.doesExist() && cursorTrack.isRecArm() ? 1 : 0;
            }
        }
        return 0;
    }

    @Override
    public void onButton(ButtonID buttonID, ButtonEvent event, int velocity) {
        if (event != ButtonEvent.DOWN || !this.isActive()) {
            return;
        }
        boolean isShiftPressed = ((FireControlSurface)this.surface).isShiftPressed();
        boolean isAltPressed = ((FireControlSurface)this.surface).isPressed(ButtonID.ALT);
        ICursorTrack cursorTrack = this.model.getCursorTrack();
        switch (buttonID) {
            case ARROW_LEFT: {
                this.handleArrowLeft(isShiftPressed, isAltPressed);
                return;
            }
            case ARROW_RIGHT: {
                this.handleArrowRight(isShiftPressed, isAltPressed);
                return;
            }
            case SCENE1: {
                cursorTrack.stop(false);
                break;
            }
            case SCENE2: {
                cursorTrack.toggleMute();
                break;
            }
            case SCENE3: {
                cursorTrack.toggleSolo();
                break;
            }
            case SCENE4: {
                cursorTrack.toggleRecArm();
                break;
            }
        }
    }

    @Override
    public void onSelectKnobValue(int value) {
        if (this.model.getValueChanger().isIncrease(value)) {
            this.onOctaveUp(ButtonEvent.DOWN);
        } else {
            this.onOctaveDown(ButtonEvent.DOWN);
        }
        if (((FireControlSurface)this.surface).isSelectPressed()) {
            ((FireControlSurface)this.surface).setTriggerConsumed(ButtonID.SELECT);
        }
    }

    private void handleArrowLeft(boolean isShiftPressed, boolean isAltPressed) {
        if (isShiftPressed) {
            if (isAltPressed) {
                this.scales.prevScaleOffset();
                this.mvHelper.delayDisplay(() -> Scales.BASES.get(this.scales.getScaleOffsetIndex()));
            } else {
                this.scales.prevScale();
                this.mvHelper.delayDisplay(() -> this.scales.getScale().getName());
            }
            this.updateScale();
        } else if (isAltPressed) {
            this.setResolutionIndex(this.getResolutionIndex() - 1);
        } else {
            INoteClip clip = this.getClip();
            clip.scrollStepsPageBackwards();
            this.mvHelper.notifyEditPage(clip);
        }
    }

    private void handleArrowRight(boolean isShiftPressed, boolean isAltPressed) {
        if (isShiftPressed) {
            if (isAltPressed) {
                this.scales.nextScaleOffset();
                this.mvHelper.delayDisplay(() -> Scales.BASES.get(this.scales.getScaleOffsetIndex()));
            } else {
                this.scales.nextScale();
                this.mvHelper.delayDisplay(() -> this.scales.getScale().getName());
            }
            this.updateScale();
        } else if (isAltPressed) {
            this.setResolutionIndex(this.getResolutionIndex() + 1);
        } else {
            INoteClip clip = this.getClip();
            clip.scrollStepsPageForward();
            this.mvHelper.notifyEditPage(clip);
        }
    }

    @Override
    protected boolean handleSequencerAreaButtonCombinations(INoteClip clip, NotePosition notePosition, int row, int velocity) {
        boolean isUpPressed = ((FireControlSurface)this.surface).isPressed(ButtonID.ARROW_UP);
        if (isUpPressed || ((FireControlSurface)this.surface).isPressed(ButtonID.ARROW_DOWN)) {
            ((FireControlSurface)this.surface).setTriggerConsumed(isUpPressed ? ButtonID.ARROW_UP : ButtonID.ARROW_DOWN);
            if (velocity > 0) {
                this.handleSequencerAreaRepeatOperator(clip, notePosition, velocity, isUpPressed);
            }
            return true;
        }
        return super.handleSequencerAreaButtonCombinations(clip, notePosition, row, velocity);
    }
}

