/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.akai.fire.controller;

import de.mossgrabers.framework.controller.display.AbstractGraphicDisplay;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import de.mossgrabers.framework.graphics.ChromaticGraphicsConfiguration;
import de.mossgrabers.framework.graphics.DefaultGraphicsDimensions;
import de.mossgrabers.framework.graphics.IBitmap;
import java.util.Arrays;

public class FireDisplay
extends AbstractGraphicDisplay {
    private static final int[][] BIT_MUTATE = new int[][]{{13, 19, 25, 31, 37, 43, 49}, {0, 20, 26, 32, 38, 44, 50}, {1, 7, 27, 33, 39, 45, 51}, {2, 8, 14, 34, 40, 46, 52}, {3, 9, 15, 21, 41, 47, 53}, {4, 10, 16, 22, 28, 48, 54}, {5, 11, 17, 23, 29, 35, 55}, {6, 12, 18, 24, 30, 36, 42}};
    private static final int STRIPE_SIZE = 147;
    private static final int PACKET_SIZE = 151;
    private final IMidiOutput output;
    private final int[][] oledBitmap = new int[8][147];
    private final int[][] oldOledBitmap = new int[8][147];
    private final byte[] data = new byte[159];
    private long lastSend = System.currentTimeMillis();

    public FireDisplay(IHost host, IMidiOutput output, int maxParameterValue) {
        super(host, new ChromaticGraphicsConfiguration(), new DefaultGraphicsDimensions(128, 64, maxParameterValue), "Fire Display");
        this.output = output;
        this.data[0] = -16;
        this.data[1] = 71;
        this.data[2] = 127;
        this.data[3] = 67;
        this.data[4] = 14;
        this.data[5] = 1;
        this.data[6] = 23;
        this.data[9] = 0;
        this.data[10] = 127;
        this.data[this.data.length - 1] = -9;
    }

    @Override
    public void notify(String message) {
        if (message == null) {
            return;
        }
        this.host.showNotification(message);
        this.setNotificationMessage(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void send(IBitmap image) {
        byte[] byArray = this.data;
        synchronized (this.data) {
            image.encode((imageBuffer, width, height) -> {
                for (int stripe = 0; stripe < 8; ++stripe) {
                    for (int y = 0; y < height / 8; ++y) {
                        for (int x = 0; x < width; ++x) {
                            byte blue = imageBuffer.get();
                            byte green = imageBuffer.get();
                            byte red = imageBuffer.get();
                            imageBuffer.get();
                            int xpos = x + 128 * (y / 8);
                            int ypos = y % 8;
                            int remapBit = BIT_MUTATE[ypos][xpos % 7];
                            int idx = xpos / 7 * 8 + remapBit / 7;
                            if (blue + green + red < 0) {
                                int[] nArray = this.oledBitmap[stripe];
                                int n = idx;
                                nArray[n] = nArray[n] | 1 << remapBit % 7;
                                continue;
                            }
                            int[] nArray = this.oledBitmap[stripe];
                            int n = idx;
                            nArray[n] = nArray[n] & ~(1 << remapBit % 7);
                        }
                    }
                }
            });
            for (int stripe = 0; stripe < 8; ++stripe) {
                this.data[7] = (byte)stripe;
                this.data[8] = (byte)stripe;
                for (int i = 0; i < 147; ++i) {
                    this.data[11 + i] = (byte)this.oledBitmap[stripe][i];
                }
                long now = System.currentTimeMillis();
                if (Arrays.compare(this.oledBitmap[stripe], this.oldOledBitmap[stripe]) == 0 && now - this.lastSend < 3000L) continue;
                System.arraycopy(this.oledBitmap[stripe], 0, this.oldOledBitmap[stripe], 0, 147);
                this.lastSend = now;
                this.output.sendSysex(new byte[][]{this.data});
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }
}

