/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.akai.apcmini;

import de.mossgrabers.controller.akai.apcmini.APCminiConfiguration;
import de.mossgrabers.controller.akai.apcmini.command.trigger.TrackSelectCommand;
import de.mossgrabers.controller.akai.apcmini.controller.APCminiButton;
import de.mossgrabers.controller.akai.apcmini.controller.APCminiControlSurface;
import de.mossgrabers.controller.akai.apcmini.controller.APCminiScales;
import de.mossgrabers.controller.akai.apcmini.definition.IAPCminiControllerDefinition;
import de.mossgrabers.controller.akai.apcmini.view.APCMiniBrowserView;
import de.mossgrabers.controller.akai.apcmini.view.APCminiView;
import de.mossgrabers.controller.akai.apcmini.view.DrumView;
import de.mossgrabers.controller.akai.apcmini.view.PlayView;
import de.mossgrabers.controller.akai.apcmini.view.RaindropsView;
import de.mossgrabers.controller.akai.apcmini.view.SequencerView;
import de.mossgrabers.controller.akai.apcmini.view.SessionView;
import de.mossgrabers.controller.akai.apcmini.view.ShiftView;
import de.mossgrabers.controller.akai.apcmini.view.TrackButtons;
import de.mossgrabers.framework.command.continuous.KnobRowModeCommand;
import de.mossgrabers.framework.command.core.TriggerCommand;
import de.mossgrabers.framework.command.trigger.view.ToggleShiftViewCommand;
import de.mossgrabers.framework.command.trigger.view.ViewButtonCommand;
import de.mossgrabers.framework.configuration.ISettingsUI;
import de.mossgrabers.framework.controller.AbstractControllerSetup;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.controller.ISetupFactory;
import de.mossgrabers.framework.controller.hardware.BindType;
import de.mossgrabers.framework.controller.valuechanger.TwosComplementValueChanger;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.ModelSetup;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.daw.midi.IMidiAccess;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import de.mossgrabers.framework.featuregroup.IView;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.featuregroup.ViewManager;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.mode.device.ParameterMode;
import de.mossgrabers.framework.mode.track.TrackPanMode;
import de.mossgrabers.framework.mode.track.TrackSendMode;
import de.mossgrabers.framework.mode.track.TrackVolumeMode;
import de.mossgrabers.framework.view.Views;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class APCminiControllerSetup
extends AbstractControllerSetup<APCminiControlSurface, APCminiConfiguration> {
    private static final List<ContinuousID> FADER_IDS = ContinuousID.createSequentialList(ContinuousID.FADER1, 8);
    private static final String[] ROW_NAMES = new String[]{"Track 1\nUp", "Track 2\nDown", "Track 3\nLeft", "Track 4\nRight", "Track 5\nVolume", "Track 6\nPan", "Track 7\nSend", "Track 8\nDevice"};
    private static final String[] COL_NAMES = new String[]{"Scene 1\n Clip Stop", "Scene 2\nSolo", "Scene 3\nRec Arm", "Scene 4\nMute", "Scene 5\nSelect", "Scene 6\n-", "Scene 7\n-", "Scene 8\nStop All Clips"};
    private static final Map<String, Modes> FADER_CTRL_MODES = new HashMap<String, Modes>();
    private final IAPCminiControllerDefinition definition;

    public APCminiControllerSetup(IHost host, ISetupFactory factory, ISettingsUI globalSettings, ISettingsUI documentSettings, IAPCminiControllerDefinition definition) {
        super(factory, host, globalSettings, documentSettings);
        this.definition = definition;
        this.colorManager = definition.getColorManager();
        this.valueChanger = new TwosComplementValueChanger(128, 1);
        this.configuration = new APCminiConfiguration(host, this.valueChanger, factory.getArpeggiatorModes(), definition);
    }

    @Override
    protected void createScales() {
        this.scales = new APCminiScales(this.valueChanger);
    }

    @Override
    protected void createModel() {
        ModelSetup ms = new ModelSetup();
        this.model = this.factory.createModel(this.configuration, this.colorManager, this.valueChanger, this.scales, ms);
        ITrackBank trackBank = this.model.getTrackBank();
        trackBank.setIndication(true);
        trackBank.addSelectionObserver((index, value) -> this.handleTrackChange(value));
    }

    @Override
    protected void createSurface() {
        IMidiAccess midiAccess = this.factory.createMidiAccess();
        IMidiOutput output = midiAccess.createOutput();
        IMidiInput input = midiAccess.createInput("Akai APCmini", new String[0]);
        this.surfaces.add(new APCminiControlSurface(this.host, this.colorManager, (APCminiConfiguration)this.configuration, output, input, this.definition));
    }

    @Override
    protected void createModes() {
        APCminiControlSurface surface = (APCminiControlSurface)this.getSurface();
        ModeManager modeManager = surface.getModeManager();
        modeManager.register(Modes.VOLUME, new TrackVolumeMode(surface, this.model, true, FADER_IDS));
        modeManager.register(Modes.PAN, new TrackPanMode(surface, this.model, true, FADER_IDS));
        for (int i = 0; i < 8; ++i) {
            modeManager.register(Modes.get(Modes.SEND1, i), new TrackSendMode(i, surface, this.model, true, FADER_IDS));
        }
        modeManager.register(Modes.DEVICE_PARAMS, new ParameterMode(surface, this.model, true, FADER_IDS));
        modeManager.setDefaultID(Modes.VOLUME);
    }

    @Override
    protected void createViews() {
        APCminiControlSurface surface = (APCminiControlSurface)this.getSurface();
        ViewManager viewManager = surface.getViewManager();
        TrackButtons trackButtons = new TrackButtons(surface, this.model);
        boolean useDawColors = this.definition.hasRGBColors();
        viewManager.register(Views.PLAY, new PlayView(surface, this.model, trackButtons, useDawColors));
        viewManager.register(Views.SHIFT, new ShiftView(surface, this.model, this.definition));
        viewManager.register(Views.BROWSER, new APCMiniBrowserView(surface, this.model));
        viewManager.register(Views.SESSION, new SessionView(surface, this.model, trackButtons, useDawColors));
        viewManager.register(Views.SEQUENCER, new SequencerView(surface, this.model, useDawColors, this.definition));
        viewManager.register(Views.DRUM, new DrumView(surface, this.model, useDawColors, this.definition));
        viewManager.register(Views.RAINDROPS, new RaindropsView(surface, this.model, useDawColors, this.definition));
    }

    @Override
    protected void createObservers() {
        super.createObservers();
        APCminiControlSurface surface = (APCminiControlSurface)this.getSurface();
        this.createScaleObservers((APCminiConfiguration)this.configuration);
        ((APCminiConfiguration)this.configuration).addSettingObserver(APCminiConfiguration.FADER_CTRL, () -> {
            Modes modeID = FADER_CTRL_MODES.get(((APCminiConfiguration)this.configuration).getFaderCtrl());
            if (modeID != null) {
                surface.getModeManager().setActive(modeID);
            }
        });
        ((APCminiConfiguration)this.configuration).addSettingObserver(APCminiConfiguration.SOFT_KEYS, () -> {
            int index = APCminiConfiguration.SOFT_KEYS_OPTIONS.indexOf(((APCminiConfiguration)this.configuration).getSoftKeys());
            if (index >= 0) {
                surface.setTrackState(index);
            }
        });
        ((APCminiConfiguration)this.configuration).addSettingObserver(APCminiConfiguration.PAD_BRIGHTNESS, surface::forceFlush);
        ((APCminiConfiguration)this.configuration).registerDeactivatedItemsHandler(this.model);
        this.activateBrowserObserver(Views.BROWSER);
    }

    @Override
    protected void registerTriggerCommands() {
        APCminiControlSurface surface = (APCminiControlSurface)this.getSurface();
        ViewManager viewManager = surface.getViewManager();
        this.addButton(ButtonID.SHIFT, "Shift", new ToggleShiftViewCommand(this.model, surface), this.definition.getButtonID(APCminiButton.SHIFT));
        for (int i = 0; i < 8; ++i) {
            int index = i;
            ButtonID buttonID = ButtonID.get(ButtonID.SCENE1, i);
            this.addButton(buttonID, COL_NAMES[i], new ViewButtonCommand(buttonID, surface), this.definition.getButtonID(APCminiButton.SCENES.get(i)), () -> this.getButtonColorFromActiveView(buttonID));
            this.addButton(ButtonID.get(ButtonID.ROW_SELECT_1, i), ROW_NAMES[i], (TriggerCommand)new TrackSelectCommand(i, this.model, surface), this.definition.getButtonID(APCminiButton.TRACKS.get(i)), () -> {
                IView view = (IView)viewManager.getActive();
                if (view instanceof APCminiView) {
                    APCminiView miniView = (APCminiView)((Object)view);
                    int trackButtonColor = miniView.getTrackButtonColor(index);
                    return trackButtonColor > 0 ? 3 : 0;
                }
                return 0;
            });
        }
    }

    @Override
    protected BindType getTriggerBindType(ButtonID buttonID) {
        return BindType.NOTE;
    }

    @Override
    protected void registerContinuousCommands() {
        APCminiControlSurface surface = (APCminiControlSurface)this.getSurface();
        this.addFader(ContinuousID.FADER_MASTER, "Master", null, BindType.CC, 56);
        surface.getContinuous(ContinuousID.FADER_MASTER).bind(this.model.getMasterTrack().getVolumeParameter());
        for (int i = 0; i < 8; ++i) {
            this.addFader(ContinuousID.get(ContinuousID.FADER1, i), "Fader " + (i + 1), new KnobRowModeCommand(i, this.model, surface), BindType.CC, 48 + i).setIndexInGroup(i);
        }
    }

    @Override
    protected void layoutControls() {
        double width = 10.0;
        double height = 6.0;
        double space = 2.0;
        double stepX = 12.0;
        double stepY = 8.0;
        APCminiControlSurface surface = (APCminiControlSurface)this.getSurface();
        surface.getButton(ButtonID.SHIFT).setBounds(98.0, 66.0, 10.0, 6.0);
        surface.getContinuous(ContinuousID.FADER_MASTER).setBounds(98.0, 74.0, 10.0, 30.0);
        for (int i = 0; i < 8; ++i) {
            double x = (double)i * 12.0;
            double y = (double)i * 8.0;
            for (int k = 0; k < 8; ++k) {
                surface.getButton(ButtonID.get(ButtonID.PAD1, k * 8 + i)).setBounds(2.0 + x, 2.0 + (double)(7 - k) * 8.0, 10.0, 6.0);
            }
            surface.getButton(ButtonID.get(ButtonID.SCENE1, i)).setBounds(98.0, 2.0 + y, 10.0, 6.0);
            surface.getButton(ButtonID.get(ButtonID.ROW_SELECT_1, i)).setBounds(2.0 + x, 66.0, 10.0, 6.0);
            surface.getContinuous(ContinuousID.get(ContinuousID.FADER1, i)).setBounds(2.0 + x, 74.0, 10.0, 30.0);
        }
    }

    @Override
    public void startup() {
        APCminiControlSurface surface = (APCminiControlSurface)this.getSurface();
        surface.getModeManager().setActive(Modes.VOLUME);
        surface.getViewManager().setActive(((APCminiConfiguration)this.configuration).shouldStartWithSessionView() ? Views.SESSION : ((APCminiConfiguration)this.configuration).getStartupView());
        this.host.scheduleTask(surface.getPadGrid()::forceFlush, 1000L);
    }

    static {
        FADER_CTRL_MODES.put("Volume", Modes.VOLUME);
        FADER_CTRL_MODES.put("Pan", Modes.PAN);
        FADER_CTRL_MODES.put("Send 1", Modes.SEND1);
        FADER_CTRL_MODES.put("Send 2", Modes.SEND2);
        FADER_CTRL_MODES.put("Send 3", Modes.SEND3);
        FADER_CTRL_MODES.put("Send 4", Modes.SEND4);
        FADER_CTRL_MODES.put("Send 5", Modes.SEND5);
        FADER_CTRL_MODES.put("Send 6", Modes.SEND6);
        FADER_CTRL_MODES.put("Send 7", Modes.SEND7);
        FADER_CTRL_MODES.put("Send 8", Modes.SEND8);
        FADER_CTRL_MODES.put("Device", Modes.DEVICE_PARAMS);
    }
}

