/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.view;

import de.mossgrabers.controller.ableton.push.PushConfiguration;
import de.mossgrabers.controller.ableton.push.controller.PushControlSurface;
import de.mossgrabers.controller.ableton.push.view.NoteRepeatSceneHelper;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ICursorDevice;
import de.mossgrabers.framework.daw.data.IDrumDevice;
import de.mossgrabers.framework.daw.data.IDrumPad;
import de.mossgrabers.framework.daw.data.IScene;
import de.mossgrabers.framework.daw.data.bank.IDrumPadBank;
import de.mossgrabers.framework.daw.data.bank.ISceneBank;
import de.mossgrabers.framework.featuregroup.IExpressionView;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.AbstractDrum64View;

public class Drum64View
extends AbstractDrum64View<PushControlSurface, PushConfiguration>
implements IExpressionView {
    public Drum64View(PushControlSurface surface, IModel model) {
        super(surface, model);
    }

    @Override
    protected void handleButtonCombinations(int playedPad) {
        if (this.isButtonCombination(ButtonID.BROWSE)) {
            IDrumDevice primary = this.model.getDrumDevice(64);
            if (primary.hasDrumPads()) {
                this.model.getBrowser().replace(primary.getDrumPadBank().getItem(playedPad));
            }
            return;
        }
        super.handleButtonCombinations(playedPad);
    }

    @Override
    protected void handleDeleteButton(int playedPad) {
        ((PushControlSurface)this.surface).setTriggerConsumed(ButtonID.DELETE);
        int editMidiChannel = ((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).getMidiEditChannel();
        this.model.getNoteClip(8, 128).clearRow(editMidiChannel, this.offsetY + playedPad);
    }

    @Override
    protected void handleSelectButton(int playedPad) {
        IDrumDevice primary = this.model.getDrumDevice(64);
        if (!primary.hasDrumPads()) {
            return;
        }
        ICursorDevice cd = this.model.getCursorDevice();
        boolean isNested = cd.isNested();
        if (isNested) {
            cd.selectParent();
        }
        if (primary.getPosition() != cd.getPosition()) {
            return;
        }
        IDrumPadBank drumPadBank = primary.getDrumPadBank();
        int scrollPos = drumPadBank.getScrollPosition();
        IDrumPadBank cdDrumPadBank = cd.getDrumPadBank();
        int pageSize = cdDrumPadBank.getPageSize();
        int adjustedPage = playedPad / pageSize * pageSize;
        cdDrumPadBank.scrollTo(scrollPos + adjustedPage, false);
        IDrumPad drumPad = drumPadBank.getItem(playedPad);
        if (drumPad.isSelected()) {
            IDrumPad selectedItem;
            if (isNested && (selectedItem = cdDrumPadBank.getItem(playedPad % pageSize)) != null) {
                selectedItem.enter();
            }
            return;
        }
        ModeManager modeManager = ((PushControlSurface)this.surface).getModeManager();
        if (!Modes.isLayerMode((Modes)((Object)modeManager.getActiveID()))) {
            modeManager.setActive(Modes.DEVICE_LAYER);
        }
        drumPad.select();
    }

    @Override
    public String getButtonColorID(ButtonID buttonID) {
        int scene;
        if (!ButtonID.isSceneButton(buttonID)) {
            return "BUTTON_COLOR_OFF";
        }
        if (((PushControlSurface)this.surface).isPressed(ButtonID.REPEAT)) {
            return NoteRepeatSceneHelper.getButtonColorID((PushControlSurface)this.surface, buttonID);
        }
        ISceneBank sceneBank = this.model.getSceneBank();
        IScene s = (IScene)sceneBank.getItem(scene = buttonID.ordinal() - ButtonID.SCENE1.ordinal());
        if (s.doesExist()) {
            return s.isSelected() ? "COLOR_SELECTED_SCENE" : "COLOR_SCENE";
        }
        return "COLOR_SELECTED_OFF";
    }

    @Override
    public void onButton(ButtonID buttonID, ButtonEvent event, int velocity) {
        if (ButtonID.isSceneButton(buttonID)) {
            this.onSceneButton(buttonID, event);
        }
    }

    @Override
    protected boolean handleSceneButtonCombinations(int index, IScene scene) {
        if (((PushControlSurface)this.surface).isPressed(ButtonID.REPEAT)) {
            NoteRepeatSceneHelper.handleNoteRepeatSelection((PushControlSurface)this.surface, 7 - index);
            return true;
        }
        return super.handleSceneButtonCombinations(index, scene);
    }
}

