/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.nativefiledialogs;

import de.mossgrabers.nativefiledialogs.FileFilter;
import de.mossgrabers.nativefiledialogs.NativeFileDialogs;
import de.mossgrabers.nativefiledialogs.ProcessResult;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public abstract class AbstractNativeFileDialogs
implements NativeFileDialogs {
    protected File currentDirectory;

    protected AbstractNativeFileDialogs(File currentDirectory) {
        if (currentDirectory != null) {
            this.currentDirectory = currentDirectory.isDirectory() ? currentDirectory : currentDirectory.getParentFile();
        }
    }

    @Override
    public void setCurrentDirectory(File currentDirectory) {
        this.currentDirectory = currentDirectory;
    }

    @Override
    public File selectFile() throws IOException {
        return this.selectFile((String)null, new FileFilter[0]);
    }

    @Override
    public File selectFile(FileFilter ... filters) throws IOException {
        return this.selectFile((String)null, filters);
    }

    @Override
    public File selectNewFile() throws IOException {
        return this.selectNewFile((String)null, new FileFilter[0]);
    }

    @Override
    public File selectNewFile(FileFilter ... filters) throws IOException {
        return this.selectNewFile((String)null, filters);
    }

    @Override
    public File selectFolder() throws IOException {
        return this.selectFolder(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ProcessResult executeProcess(String[] args) throws IOException {
        ProcessBuilder pb = new ProcessBuilder(Arrays.asList(args));
        String osName = System.getProperty("os.name");
        if (osName != null && osName.toLowerCase(Locale.ENGLISH).contains("linux")) {
            Map<String, String> environment = pb.environment();
            environment.put("LD_LIBRARY_PATH", "");
        }
        Process proc = pb.start();
        StringBuilder error = new StringBuilder();
        StringBuilder result = new StringBuilder();
        try {
            String line;
            try (BufferedReader in = new BufferedReader(new InputStreamReader(proc.getErrorStream()));){
                while ((line = in.readLine()) != null) {
                    error.append(line);
                }
            }
            in = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            try {
                while ((line = in.readLine()) != null) {
                    result.append(line);
                }
            }
            finally {
                in.close();
            }
        }
        finally {
            proc.destroy();
        }
        try {
            proc.waitFor(5L, TimeUnit.SECONDS);
            return new ProcessResult(result.toString().trim(), error.toString().trim(), proc.exitValue());
        }
        catch (InterruptedException ex) {
            throw new IOException(ex);
        }
    }
}

