/*
 * Decompiled with CFR 0.152.
 */
package com.illposed.osc.argument.handler;

import com.illposed.osc.BytesReceiver;
import com.illposed.osc.OSCParseException;
import com.illposed.osc.OSCParser;
import com.illposed.osc.OSCSerializer;
import com.illposed.osc.argument.ArgumentHandler;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.util.Map;

public class StringArgumentHandler
implements ArgumentHandler<String>,
Cloneable {
    public static final char DEFAULT_IDENTIFIER = 's';
    public static final String PROP_NAME_CHARSET = "charset";
    private Charset charset;

    public StringArgumentHandler(Charset charset) {
        this.charset = charset;
    }

    public StringArgumentHandler() {
        this(Charset.defaultCharset());
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    @Override
    public char getDefaultIdentifier() {
        return 's';
    }

    @Override
    public Class<String> getJavaClass() {
        return String.class;
    }

    @Override
    public void setProperties(Map<String, Object> properties) {
        Charset newCharset = (Charset)properties.get(PROP_NAME_CHARSET);
        if (newCharset != null) {
            this.setCharset(newCharset);
        }
    }

    @Override
    public boolean isMarkerOnly() {
        return false;
    }

    public StringArgumentHandler clone() throws CloneNotSupportedException {
        return (StringArgumentHandler)super.clone();
    }

    private int lengthOfCurrentString(ByteBuffer rawInput) {
        int len = 0;
        while (rawInput.get(rawInput.position() + len) != 0) {
            ++len;
        }
        return len;
    }

    @Override
    public String parse(ByteBuffer input) throws OSCParseException {
        String res;
        int strLen = this.lengthOfCurrentString(input);
        ByteBuffer strBuffer = input.slice();
        ((Buffer)strBuffer).limit(strLen);
        try {
            res = this.charset.newDecoder().decode(strBuffer).toString();
        }
        catch (CharacterCodingException ex) {
            throw new OSCParseException("Failed decoding a string argument", ex, input);
        }
        ((Buffer)input).position(input.position() + strLen);
        input.get();
        OSCParser.align(input);
        return res;
    }

    @Override
    public void serialize(BytesReceiver output, String value) {
        byte[] stringBytes = value.getBytes(this.charset);
        output.put(stringBytes);
        OSCSerializer.terminateAndAlign(output);
    }
}

