/*
 * Decompiled with CFR 0.152.
 */
package com.illposed.osc.argument.handler;

import com.illposed.osc.BytesReceiver;
import com.illposed.osc.OSCParseException;
import com.illposed.osc.OSCSerializeException;
import com.illposed.osc.argument.ArgumentHandler;
import com.illposed.osc.argument.handler.IntegerArgumentHandler;
import java.nio.ByteBuffer;
import java.util.Map;

public class FloatArgumentHandler
implements ArgumentHandler<Float>,
Cloneable {
    public static final ArgumentHandler<Float> INSTANCE = new FloatArgumentHandler();

    protected FloatArgumentHandler() {
    }

    @Override
    public char getDefaultIdentifier() {
        return 'f';
    }

    @Override
    public Class<Float> getJavaClass() {
        return Float.class;
    }

    @Override
    public void setProperties(Map<String, Object> properties) {
    }

    @Override
    public boolean isMarkerOnly() {
        return false;
    }

    public FloatArgumentHandler clone() throws CloneNotSupportedException {
        return (FloatArgumentHandler)super.clone();
    }

    @Override
    public Float parse(ByteBuffer input) throws OSCParseException {
        return Float.valueOf(Float.intBitsToFloat(IntegerArgumentHandler.INSTANCE.parse(input)));
    }

    @Override
    public void serialize(BytesReceiver output, Float value) throws OSCSerializeException {
        IntegerArgumentHandler.INSTANCE.serialize(output, Float.floatToRawIntBits(value.floatValue()));
    }
}

