/*
 * Decompiled with CFR 0.152.
 */
package com.illposed.osc.argument;

import java.io.Serializable;

public class OSCColor
implements Cloneable,
Serializable,
Comparable<OSCColor> {
    public static final int NUM_CONTENT_BYTES = 4;
    public static final byte DEFAULT_ALPHA = 1;
    public static final OSCColor BLACK = new OSCColor(0, 0, 0);
    public static final OSCColor BLUE = new OSCColor(0, 0, -1);
    public static final OSCColor CYAN = new OSCColor(0, -1, -1);
    public static final OSCColor DARK_GRAY = new OSCColor(64, 64, 64);
    public static final OSCColor GRAY = new OSCColor(-128, -128, -128);
    public static final OSCColor GREEN = new OSCColor(0, -1, 0);
    public static final OSCColor LIGHT_GRAY = new OSCColor(-64, -64, -64);
    public static final OSCColor MAGENTA = new OSCColor(-1, 0, -1);
    public static final OSCColor ORANGE = new OSCColor(-1, -56, 0);
    public static final OSCColor PINK = new OSCColor(-1, -81, -81);
    public static final OSCColor RED = new OSCColor(-1, 0, 0);
    public static final OSCColor WHITE = new OSCColor(-1, -1, -1);
    public static final OSCColor YELLOW = new OSCColor(-1, -1, 0);
    private static final long serialVersionUID = 1L;
    private final byte red;
    private final byte green;
    private final byte blue;
    private final byte alpha;

    public static int toUnsignedInt(byte signedByte) {
        return signedByte & 0xFF;
    }

    public static byte toSignedByte(int unsignedInt) {
        return (byte)unsignedInt;
    }

    public OSCColor(byte red, byte green, byte blue, byte alpha) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
    }

    public OSCColor(byte red, byte green, byte blue) {
        this(red, green, blue, 1);
    }

    public OSCColor(int red, int green, int blue, int alpha) {
        this(OSCColor.toSignedByte(red), OSCColor.toSignedByte(green), OSCColor.toSignedByte(blue), OSCColor.toSignedByte(alpha));
    }

    public byte[] toContentArray() {
        return new byte[]{this.getRed(), this.getGreen(), this.getBlue(), this.getAlpha()};
    }

    public byte getRed() {
        return this.red;
    }

    public byte getGreen() {
        return this.green;
    }

    public byte getBlue() {
        return this.blue;
    }

    public byte getAlpha() {
        return this.alpha;
    }

    public int getRedInt() {
        return OSCColor.toUnsignedInt(this.getRed());
    }

    public int getGreenInt() {
        return OSCColor.toUnsignedInt(this.getGreen());
    }

    public int getBlueInt() {
        return OSCColor.toUnsignedInt(this.getBlue());
    }

    public int getAlphaInt() {
        return OSCColor.toUnsignedInt(this.getAlpha());
    }

    public boolean equals(Object other) {
        boolean equal = false;
        if (other instanceof OSCColor) {
            OSCColor otherColor = (OSCColor)other;
            if (this.getRed() == otherColor.getRed() && this.getGreen() == otherColor.getGreen() && this.getBlue() == otherColor.getBlue() && this.getAlpha() == otherColor.getAlpha()) {
                equal = true;
            }
        }
        return equal;
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + this.getRed();
        hash = 97 * hash + this.getGreen();
        hash = 97 * hash + this.getBlue();
        hash = 97 * hash + this.getAlpha();
        return hash;
    }

    @Override
    public int compareTo(OSCColor other) {
        return Integer.compare(this.hashCode(), other.hashCode());
    }

    public OSCColor clone() throws CloneNotSupportedException {
        return (OSCColor)super.clone();
    }

    public static OSCColor valueOf(byte[] content) {
        if (content.length != 4) {
            throw new IllegalArgumentException("The content has to be exactly 4 bytes");
        }
        int contentByteIndex = 0;
        return new OSCColor(content[contentByteIndex++], content[contentByteIndex++], content[contentByteIndex++], content[contentByteIndex]);
    }
}

