/*
 * Decompiled with CFR 0.152.
 */
package purejavahidapi.macosx;

import com.sun.jna.Callback;
import com.sun.jna.Memory;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Hashtable;
import purejavahidapi.DeviceRemovalListener;
import purejavahidapi.HidDeviceInfo;
import purejavahidapi.InputReportListener;
import purejavahidapi.macosx.CoreFoundationLibrary;
import purejavahidapi.macosx.IOHIDManagerLibrary;
import purejavahidapi.macosx.MacOsXBackend;
import purejavahidapi.shared.SyncPoint;

public class HidDevice
extends purejavahidapi.HidDevice {
    private MacOsXBackend m_Backend;
    private static int m_InternalIdGenerator = 0;
    int m_InternalId = m_InternalIdGenerator++;
    private IOHIDManagerLibrary.IOHIDDeviceRef m_IOHIDDeviceRef;
    private boolean m_Disconnected;
    private CoreFoundationLibrary.CFStringRef m_CFRunLoopMode;
    private CoreFoundationLibrary.CFRunLoopRef m_CFRunLoopRef;
    private CoreFoundationLibrary.CFRunLoopSourceRef m_CFRunLoopSourceRef;
    private Pointer m_InputReportBuffer;
    private byte[] m_InputReportData;
    private int m_MaxInputReportLength;
    private Thread m_Thread;
    private SyncPoint m_SyncStart;
    private SyncPoint m_SyncShutdown;
    private boolean m_StopThread;
    private HidReportCallback m_HidReportCallBack;
    private HidDeviceRemovalCallback m_HidDeviceRemovalCallback;
    private PerformSignalCallback m_PerformSignalCallback;
    private static Hashtable<Callback, HidDevice> m_DevFromCallback = new Hashtable();

    Pointer asPointerForPassingToCallback() {
        return new Pointer((long)this.m_InternalId);
    }

    HidDevice(purejavahidapi.macosx.HidDeviceInfo hidDeviceInfo, MacOsXBackend backend) {
        this.m_Backend = backend;
        this.m_HidDeviceInfo = hidDeviceInfo;
        this.m_IOHIDDeviceRef = this.m_Backend.getIOHIDDeviceRef(hidDeviceInfo.getPath());
        this.m_PerformSignalCallback = new PerformSignalCallback();
        m_DevFromCallback.put(this.m_PerformSignalCallback, this);
        this.m_HidReportCallBack = new HidReportCallback();
        m_DevFromCallback.put(this.m_HidReportCallBack, this);
        this.m_HidDeviceRemovalCallback = new HidDeviceRemovalCallback();
        m_DevFromCallback.put(this.m_HidDeviceRemovalCallback, this);
        this.m_SyncStart = new SyncPoint(2);
        this.m_SyncShutdown = new SyncPoint(2);
        this.m_MaxInputReportLength = HidDevice.getIntProperty(this.m_IOHIDDeviceRef, CoreFoundationLibrary.CFSTR("MaxInputReportSize"));
        if (this.m_MaxInputReportLength > 0) {
            this.m_InputReportBuffer = new Memory((long)this.m_MaxInputReportLength);
            this.m_InputReportData = new byte[this.m_MaxInputReportLength];
        }
        String str = String.format("HIDAPI_0x%08x", Pointer.nativeValue((Pointer)this.m_IOHIDDeviceRef.getPointer()));
        this.m_CFRunLoopMode = CoreFoundationLibrary.CFStringCreateWithCString(null, str, 1536);
        if (this.m_MaxInputReportLength > 0) {
            IOHIDManagerLibrary.IOHIDDeviceRegisterInputReportCallback(this.m_IOHIDDeviceRef, this.m_InputReportBuffer, this.m_MaxInputReportLength, this.m_HidReportCallBack, this.asPointerForPassingToCallback());
        }
        IOHIDManagerLibrary.IOHIDManagerRegisterDeviceRemovalCallback(MacOsXBackend.m_HidManager, this.m_HidDeviceRemovalCallback, this.asPointerForPassingToCallback());
        this.m_Thread = new Thread(new Runnable(){

            @Override
            public void run() {
                IOHIDManagerLibrary.IOHIDDeviceScheduleWithRunLoop(HidDevice.this.m_IOHIDDeviceRef, CoreFoundationLibrary.CFRunLoopGetCurrent(), HidDevice.this.m_CFRunLoopMode);
                CoreFoundationLibrary.CFRunLoopSourceContext ctx = new CoreFoundationLibrary.CFRunLoopSourceContext();
                ctx.perform = HidDevice.this.m_PerformSignalCallback;
                HidDevice.this.m_CFRunLoopSourceRef = CoreFoundationLibrary.CFRunLoopSourceCreate(CoreFoundationLibrary.kCFAllocatorDefault, 0L, ctx);
                CoreFoundationLibrary.CFRunLoopAddSource(CoreFoundationLibrary.CFRunLoopGetCurrent(), HidDevice.this.m_CFRunLoopSourceRef, HidDevice.this.m_CFRunLoopMode);
                HidDevice.this.m_CFRunLoopRef = CoreFoundationLibrary.CFRunLoopGetCurrent();
                HidDevice.this.m_SyncStart.waitAndSync();
                while (!HidDevice.this.m_StopThread && !HidDevice.this.m_Disconnected) {
                    int code = CoreFoundationLibrary.CFRunLoopRunInMode(HidDevice.this.m_CFRunLoopMode, 1000.0, false);
                    if (code == 1) {
                        HidDevice.this.m_Disconnected = true;
                        break;
                    }
                    if (code == 3 || code == 4) continue;
                    HidDevice.this.m_StopThread = true;
                    break;
                }
                if (!HidDevice.this.m_Disconnected) {
                    HidDevice.this.m_SyncShutdown.waitAndSync();
                }
            }
        }, this.m_HidDeviceInfo.getPath());
        this.m_Backend.addDevice(this.m_HidDeviceInfo.getDeviceId(), this);
        this.m_Open = true;
        this.m_Thread.start();
        this.m_SyncStart.waitAndSync();
    }

    @Override
    public synchronized void setInputReportListener(InputReportListener listener) {
        if (!this.m_Open) {
            throw new IllegalStateException("device not open");
        }
        this.m_InputReportListener = listener;
    }

    @Override
    public synchronized void setDeviceRemovalListener(DeviceRemovalListener listener) {
        if (!this.m_Open) {
            throw new IllegalStateException("device not open");
        }
        this.m_DeviceRemovalListener = listener;
    }

    static void processPendingEvents() {
        int res;
        while ((res = CoreFoundationLibrary.CFRunLoopRunInMode(CoreFoundationLibrary.kCFRunLoopDefaultMode, 0.001, false)) != 1 && res != 3) {
        }
    }

    static int getIntProperty(IOHIDManagerLibrary.IOHIDDeviceRef device, CoreFoundationLibrary.CFStringRef key) {
        int[] value = new int[1];
        CoreFoundationLibrary.CFTypeRef ref = IOHIDManagerLibrary.IOHIDDeviceGetProperty(device, key);
        if (ref != null && CoreFoundationLibrary.CFGetTypeID(ref.getPointer()) == CoreFoundationLibrary.CFNumberGetTypeID()) {
            CoreFoundationLibrary.CFNumberGetValue(new CoreFoundationLibrary.CFNumber(ref.getPointer()), 3, value);
            return value[0];
        }
        return 0;
    }

    static int getIntProperty(IOHIDManagerLibrary.IOHIDElementRef element, CoreFoundationLibrary.CFStringRef key) {
        int[] value = new int[1];
        CoreFoundationLibrary.CFTypeRef ref = IOHIDManagerLibrary.IOHIDElementGetProperty(element, key);
        if (ref != null && CoreFoundationLibrary.CFGetTypeID(ref.getPointer()) == CoreFoundationLibrary.CFNumberGetTypeID()) {
            CoreFoundationLibrary.CFNumberGetValue(new CoreFoundationLibrary.CFNumber(ref.getPointer()), 3, value);
            return value[0];
        }
        return 0;
    }

    static String getStringProperty(IOHIDManagerLibrary.IOHIDDeviceRef device, CoreFoundationLibrary.CFStringRef prop) {
        try {
            CoreFoundationLibrary.CFTypeRef t = IOHIDManagerLibrary.IOHIDDeviceGetProperty(device, prop);
            CoreFoundationLibrary.CFStringRef str = null;
            if (t != null) {
                str = new CoreFoundationLibrary.CFStringRef(t.getPointer());
            }
            if (str != null) {
                long str_len = CoreFoundationLibrary.CFStringGetLength(str);
                CoreFoundationLibrary.CFRange range = new CoreFoundationLibrary.CFRange(0L, str_len);
                long[] used_buf_len = new long[1];
                CoreFoundationLibrary.CFStringGetBytes(str, range, 0x8000100, (byte)63, false, null, 0L, used_buf_len);
                byte[] buf = new byte[(int)used_buf_len[0]];
                CoreFoundationLibrary.CFStringGetBytes(str, range, 0x8000100, (byte)63, false, buf, buf.length, used_buf_len);
                return new String(buf, "utf-8");
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return null;
    }

    static String createPathForDevide(IOHIDManagerLibrary.IOHIDDeviceRef dev) {
        String transport = HidDevice.getStringProperty(dev, CoreFoundationLibrary.CFSTR("Transport"));
        if (transport == null) {
            return null;
        }
        short vid = (short)HidDevice.getIntProperty(dev, CoreFoundationLibrary.CFSTR("VendorID"));
        short pid = (short)HidDevice.getIntProperty(dev, CoreFoundationLibrary.CFSTR("ProductID"));
        return String.format("%s_%04x_%04x_0x%08x", transport, vid, pid, Pointer.nativeValue((Pointer)dev.getPointer()));
    }

    @Override
    public synchronized int getFeatureReport(byte[] data, int length) {
        if (!this.m_Open) {
            throw new IllegalStateException("device not open");
        }
        int[] len = new int[]{length};
        int res = IOHIDManagerLibrary.IOHIDDeviceGetReport(this.m_IOHIDDeviceRef, 2, 0xFF & data[0], ByteBuffer.wrap(data), len);
        if (res == 0) {
            return len[0];
        }
        return -1;
    }

    private int setReport(int type, byte reportID, byte[] data, int length) {
        int length_to_send;
        ByteBuffer data_to_send = ByteBuffer.wrap(data);
        int res = IOHIDManagerLibrary.IOHIDDeviceSetReport(this.m_IOHIDDeviceRef, type, 0xFF & reportID, data_to_send, length_to_send = length);
        if (res == 0) {
            return length;
        }
        return -1;
    }

    @Override
    public synchronized int setOutputReport(byte reportID, byte[] data, int length) {
        if (!this.m_Open) {
            throw new IllegalStateException("device not open");
        }
        return this.setReport(1, reportID, data, length);
    }

    @Override
    public synchronized int setFeatureReport(byte reportId, byte[] data, int length) {
        if (!this.m_Open) {
            throw new IllegalStateException("device not open");
        }
        return this.setReport(2, reportId, data, length);
    }

    @Override
    public synchronized int setFeatureReport(byte[] data, int length) {
        if (!this.m_Open) {
            throw new IllegalStateException("device not open");
        }
        return this.setReport(2, (byte)0, data, length);
    }

    @Override
    public synchronized void close() {
        if (!this.m_Open) {
            throw new IllegalStateException("device not open");
        }
        IOHIDManagerLibrary.IOHIDDeviceRegisterInputReportCallback(this.m_IOHIDDeviceRef, this.m_InputReportBuffer, this.m_MaxInputReportLength, null, null);
        IOHIDManagerLibrary.IOHIDManagerRegisterDeviceRemovalCallback(MacOsXBackend.m_HidManager, null, null);
        IOHIDManagerLibrary.IOHIDDeviceUnscheduleFromRunLoop(this.m_IOHIDDeviceRef, this.m_CFRunLoopRef, this.m_CFRunLoopMode);
        IOHIDManagerLibrary.IOHIDDeviceScheduleWithRunLoop(this.m_IOHIDDeviceRef, CoreFoundationLibrary.CFRunLoopGetMain(), CoreFoundationLibrary.kCFRunLoopDefaultMode);
        this.m_StopThread = true;
        CoreFoundationLibrary.CFRunLoopSourceSignal(this.m_CFRunLoopSourceRef);
        CoreFoundationLibrary.CFRunLoopWakeUp(this.m_CFRunLoopRef);
        if (Thread.currentThread() != this.m_Thread) {
            this.m_SyncShutdown.waitAndSync();
            try {
                this.m_Thread.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        IOHIDManagerLibrary.IOHIDDeviceClose(this.m_IOHIDDeviceRef, 1);
        if (this.m_CFRunLoopMode != null) {
            CoreFoundationLibrary.CFRelease(this.m_CFRunLoopMode);
        }
        if (this.m_CFRunLoopSourceRef != null) {
            CoreFoundationLibrary.CFRelease(this.m_CFRunLoopSourceRef);
        }
        CoreFoundationLibrary.CFRelease(this.m_IOHIDDeviceRef);
        m_DevFromCallback.remove(this.m_PerformSignalCallback);
        m_DevFromCallback.remove(this.m_HidReportCallBack);
        m_DevFromCallback.remove(this.m_HidDeviceRemovalCallback);
        this.m_Backend.removeDevice(this.m_HidDeviceInfo.getDeviceId());
        this.m_Open = false;
    }

    @Override
    public synchronized HidDeviceInfo getHidDeviceInfo() {
        return this.m_HidDeviceInfo;
    }

    static class HidDeviceRemovalCallback
    implements IOHIDManagerLibrary.IOHIDDeviceCallback {
        HidDeviceRemovalCallback() {
        }

        @Override
        public void hid_device_removal_callback(Pointer context, int result, Pointer sender, IOHIDManagerLibrary.IOHIDDeviceRef dev_ref) {
            HidDevice dev = m_DevFromCallback.get(this);
            if (dev != null) {
                dev.m_Disconnected = true;
                dev.close();
                if (dev.m_DeviceRemovalListener != null) {
                    dev.m_DeviceRemovalListener.onDeviceRemoval(dev);
                }
            } else {
                System.err.println("HidDeviceRemovalCallback could not get the HidDevice object");
            }
        }
    }

    static class HidReportCallback
    implements IOHIDManagerLibrary.IOHIDReportCallback {
        HidReportCallback() {
        }

        @Override
        public void callback(Pointer context, int result, Pointer sender, int reportType, int reportID, Pointer report, NativeLong report_length) {
            HidDevice dev = m_DevFromCallback.get(this);
            if (dev != null) {
                if (dev.m_InputReportListener != null) {
                    int length = report_length.intValue();
                    report.read(0L, dev.m_InputReportData, 0, length);
                    dev.m_InputReportListener.onInputReport(dev, (byte)reportID, dev.m_InputReportData, length);
                }
            } else {
                System.err.println("HidReportCallback could not get the HidDevice object");
            }
        }
    }

    private static class PerformSignalCallback
    implements CoreFoundationLibrary.CFRunLoopPerformCallBack {
        private PerformSignalCallback() {
        }

        @Override
        public void callback(Pointer context) {
            CoreFoundationLibrary.CFRunLoopStop(CoreFoundationLibrary.CFRunLoopGetCurrent());
        }
    }
}

