/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.ui;

import de.mossgrabers.framework.controller.IControllerDefinition;
import de.mossgrabers.reaper.AppCallback;
import de.mossgrabers.reaper.controller.ControllerInstanceManager;
import de.mossgrabers.reaper.controller.IControllerInstance;
import de.mossgrabers.reaper.ui.dialog.BrowserDialog;
import de.mossgrabers.reaper.ui.dialog.DebugDialog;
import de.mossgrabers.reaper.ui.utils.LogModel;
import de.mossgrabers.reaper.ui.utils.SafeRunLater;
import de.mossgrabers.reaper.ui.widget.CheckboxListRenderer;
import de.mossgrabers.reaper.ui.widget.ControllerCheckboxListItem;
import de.mossgrabers.reaper.ui.widget.Functions;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;

public class MainFrame
extends JFrame {
    private static final long serialVersionUID = 4251131641194938848L;
    private static final int GAP = 14;
    private final transient AppCallback callback;
    private final JTextPane loggingTextArea = new JTextPane();
    private final JButton removeButton;
    private final JButton configButton;
    private final JButton enableButton;
    private final JButton detectButton;
    private final JButton addButton;
    private final JButton projectButton;
    private final JButton parameterButton;
    private final JButton debugButton;
    private final DefaultListModel<ControllerCheckboxListItem> listModel = new DefaultListModel();
    private final JList<ControllerCheckboxListItem> controllerList = new JList<ControllerCheckboxListItem>(this.listModel);
    private final DebugDialog debugDialog;
    private final BrowserDialog browserDialog;
    private final LogModel logModel;
    private ControllerInstanceManager instanceManager;

    public MainFrame(AppCallback callback, ControllerInstanceManager instanceManager, LogModel logModel) {
        this.callback = callback;
        logModel.setTextArea(this.loggingTextArea);
        this.logModel = logModel;
        Class<?> clazz = this.getClass();
        URL resource = clazz.getResource("/images/AppIcon.gif");
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Image image = toolkit.getImage(resource);
        if (image != null) {
            this.setIconImage(image);
        }
        this.setTitle();
        this.debugDialog = new DebugDialog((Window)this, callback);
        this.browserDialog = new BrowserDialog(this, this.getCallback());
        ImageIcon configureIcon = Functions.getIcon("Configure");
        this.configButton = new JButton("Configuration");
        MainFrame.addIcon(this.configButton, configureIcon);
        this.configButton.addActionListener(event -> this.editController());
        this.configButton.setToolTipText("Open the configuration dialog of the selected controller.");
        ImageIcon addIcon = Functions.getIcon("Add");
        this.addButton = new JButton("Add");
        MainFrame.addIcon(this.addButton, addIcon);
        this.addButton.setToolTipText("Not all controllers can be detected automatically. Use the Add button and select the controller to add from the appearing menu.");
        this.configureAddButton(this.addButton, instanceManager.getDefinitions());
        this.detectButton = new JButton("Detect");
        MainFrame.addIcon(this.detectButton, addIcon);
        this.detectButton.setToolTipText("Automatically adds connected controllers.");
        this.detectButton.addActionListener(event -> this.detectControllers());
        ImageIcon removeIcon = Functions.getIcon("Remove");
        this.removeButton = new JButton("Remove");
        MainFrame.addIcon(this.removeButton, removeIcon);
        this.removeButton.addActionListener(event -> this.removeController());
        this.removeButton.setToolTipText("Removes the controller which is selected in the list.");
        this.projectButton = new JButton("Project");
        MainFrame.addIcon(this.projectButton, configureIcon);
        this.projectButton.setToolTipText("Configure the controller settings which are stored individually with each Reaper project, e.g. Scale settings.");
        this.projectButton.addActionListener(event -> this.projectSettings());
        this.parameterButton = new JButton("Parameters");
        MainFrame.addIcon(this.parameterButton, configureIcon);
        this.parameterButton.setToolTipText("Arrange the parameters of the currently selected device into pages.");
        this.parameterButton.addActionListener(event -> this.parameterMapping());
        ImageIcon enableIcon = Functions.getIcon("OnOff");
        this.enableButton = new JButton("Dis-/enable");
        MainFrame.addIcon(this.enableButton, enableIcon);
        this.enableButton.setToolTipText("Disable a controller to save performance if you do not use it (or it is not connected).");
        this.enableButton.addActionListener(event -> this.toggleEnableController());
        ImageIcon debugIcon = Functions.getIcon("Debug");
        this.debugButton = new JButton("Debug");
        MainFrame.addIcon(this.debugButton, debugIcon);
        this.configureDebugButton(this.debugButton);
        JPanel deviceButtonContainer = new JPanel();
        deviceButtonContainer.setBorder(new EmptyBorder(0, 14, 0, 0));
        deviceButtonContainer.setLayout(new GridLayout(8, 1, 0, 14));
        deviceButtonContainer.add(this.detectButton);
        deviceButtonContainer.add(this.addButton);
        deviceButtonContainer.add(this.removeButton);
        deviceButtonContainer.add(this.configButton);
        deviceButtonContainer.add(this.projectButton);
        deviceButtonContainer.add(this.parameterButton);
        deviceButtonContainer.add(this.enableButton);
        deviceButtonContainer.add(this.debugButton);
        this.controllerList.setMinimumSize(new Dimension(300, 200));
        this.controllerList.setCellRenderer(new CheckboxListRenderer());
        this.controllerList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2) {
                    return;
                }
                int index = MainFrame.this.controllerList.locationToIndex(e.getPoint());
                if (index < 0) {
                    return;
                }
                ControllerCheckboxListItem item = MainFrame.this.listModel.getElementAt(index);
                item.setSelected(true);
                MainFrame.this.editController();
            }
        });
        JScrollPane controllerListPane = new JScrollPane(this.controllerList);
        JPanel controllerConfigurationPane = new JPanel(new BorderLayout());
        controllerConfigurationPane.add((Component)controllerListPane, "Center");
        controllerConfigurationPane.add((Component)new JLabel("Controller:"), "North");
        controllerConfigurationPane.add((Component)deviceButtonContainer, "East");
        JScrollPane loggingTextAreaPane = new JScrollPane(this.loggingTextArea);
        JLabel loggingAreaLabel = new JLabel("Logging:");
        this.createDefaultMenuItems(this.loggingTextArea);
        JPanel loggingPane = new JPanel(new BorderLayout());
        loggingPane.setBorder(new EmptyBorder(14, 0, 0, 0));
        loggingPane.add((Component)loggingTextAreaPane, "Center");
        loggingPane.add((Component)loggingAreaLabel, "North");
        JPanel root = new JPanel(new BorderLayout());
        root.setBorder(new EmptyBorder(14, 14, 14, 14));
        root.add((Component)loggingPane, "Center");
        root.add((Component)controllerConfigurationPane, "North");
        this.add(root);
        this.pack();
        this.getRootPane().registerKeyboardAction(e -> this.setVisible(false), KeyStroke.getKeyStroke(27, 0), 2);
        this.configureFrame(this);
        this.instanceManager = instanceManager;
        this.fillControllerList();
    }

    public void fillControllerList() {
        this.listModel.clear();
        for (IControllerInstance instance : this.instanceManager.getInstances()) {
            this.listModel.addElement(new ControllerCheckboxListItem(instance));
        }
        this.updateWidgetStates();
    }

    private void detectControllers() {
        List<IControllerInstance> detectedControllers = this.getCallback().detectControllers();
        if (detectedControllers.isEmpty()) {
            return;
        }
        for (IControllerInstance controllerInstance : detectedControllers) {
            this.listModel.addElement(new ControllerCheckboxListItem(controllerInstance));
        }
        this.controllerList.setSelectedValue(detectedControllers.get(0), true);
        this.updateWidgetStates();
    }

    private void editController() {
        int selectedIndex = this.getSelectedController();
        if (selectedIndex >= 0) {
            this.getCallback().editController(selectedIndex);
            this.forceRedraw(selectedIndex);
        }
    }

    public void forceRedrawControllerList() {
        int selIndex = this.getSelectedController();
        DefaultListModel<ControllerCheckboxListItem> newListModel = new DefaultListModel<ControllerCheckboxListItem>();
        for (int i = 0; i < this.listModel.getSize(); ++i) {
            newListModel.addElement(this.listModel.getElementAt(i));
            this.controllerList.setModel(newListModel);
        }
        if (selIndex >= 0) {
            this.controllerList.setSelectedIndex(selIndex);
        }
    }

    void forceRedraw(int selectedIndex) {
        ControllerCheckboxListItem item = this.listModel.getElementAt(selectedIndex);
        this.listModel.setElementAt(item, selectedIndex);
    }

    private void removeController() {
        int selectedIndex = this.getSelectedController();
        if (selectedIndex < 0) {
            return;
        }
        this.listModel.remove(selectedIndex);
        this.getCallback().removeController(selectedIndex);
        this.updateWidgetStates();
    }

    public void projectSettings() {
        this.getCallback().projectSettings();
    }

    public void parameterMapping() {
        int selectedIndex = this.getSelectedController();
        if (selectedIndex >= 0) {
            this.getCallback().parameterSettings(selectedIndex);
        }
    }

    public BrowserDialog getBrowserDialog() {
        return this.browserDialog;
    }

    private void toggleEnableController() {
        ControllerCheckboxListItem item;
        int selectedIndex = this.getSelectedController();
        if (selectedIndex < 0) {
            return;
        }
        item.setSelected(!(item = this.listModel.getElementAt(selectedIndex)).isSelected());
        this.getCallback().toggleEnableController(selectedIndex);
        this.forceRedraw(selectedIndex);
    }

    protected void setTitle() {
        String implementationVersion;
        StringBuilder sb = new StringBuilder("DrivenByMoss 4 Reaper");
        Package p = this.getClass().getClassLoader().getDefinedPackage("de.mossgrabers.reaper");
        if (p != null && (implementationVersion = p.getImplementationVersion()) != null) {
            sb.append(" v").append(implementationVersion);
        }
        this.setTitle(sb.toString());
    }

    protected void configureFrame(JFrame frame) {
        frame.setMinimumSize(new Dimension(840, 500));
        URL url = ClassLoader.getSystemResource("images/AppIcon.gif");
        if (url != null) {
            ImageIcon imageIcon = new ImageIcon(url);
            this.setIconImage(imageIcon.getImage());
        }
    }

    private void createDefaultMenuItems(JTextPane t) {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem copy = new JMenuItem("Copy");
        copy.addActionListener(e -> t.copy());
        popup.add(copy);
        JMenuItem clear = new JMenuItem("Clear");
        clear.addActionListener(e -> this.getCallback().clearLogMessage());
        popup.add(clear);
        popup.addSeparator();
        JMenuItem selectAll = new JMenuItem("Select All");
        selectAll.addActionListener(e -> t.selectAll());
        popup.add(selectAll);
        t.setComponentPopupMenu(popup);
    }

    private void configureAddButton(JButton addButton, Set<IControllerDefinition> definitions) {
        TreeMap<String, Map> menus = new TreeMap<String, Map>();
        for (IControllerDefinition definition : definitions) {
            String vendor = definition.getHardwareVendor();
            Map menuItems = menus.computeIfAbsent(vendor, v -> new TreeMap());
            String hardwareModel = definition.getHardwareModel();
            JMenuItem item = new JMenuItem(hardwareModel);
            item.addActionListener(event -> this.addController(definition));
            menuItems.put(hardwareModel, item);
        }
        JPopupMenu popup = new JPopupMenu();
        for (Map.Entry menuItems : menus.entrySet()) {
            JMenu menu = new JMenu((String)menuItems.getKey());
            for (JMenuItem subMenus : ((Map)menuItems.getValue()).values()) {
                menu.add(subMenus);
            }
            popup.add(menu);
        }
        addButton.addActionListener(event -> popup.show(addButton, 0, addButton.getHeight()));
    }

    private void configureDebugButton(JButton debugButton) {
        JPopupMenu popup = new JPopupMenu();
        JCheckBoxMenuItem popupNotificationsItem = new JCheckBoxMenuItem("Display popup notifications");
        popupNotificationsItem.addActionListener(event -> this.getCallback().setPopupWindowNotification(popupNotificationsItem.isSelected()));
        popup.add(popupNotificationsItem);
        popupNotificationsItem.setSelected(this.getCallback().getPopupWindowNotification());
        JMenuItem refreshMIDIPortsItem = new JMenuItem("Refresh MIDI Ports");
        refreshMIDIPortsItem.addActionListener(event -> this.getCallback().sendMIDIPortRefreshCommand());
        popup.add(refreshMIDIPortsItem);
        JMenuItem refreshItem = new JMenuItem("Data Refresh");
        refreshItem.addActionListener(event -> this.getCallback().sendRefreshCommand());
        popup.add(refreshItem);
        JMenuItem dataItem = new JMenuItem("Data Updates");
        dataItem.addActionListener(event -> this.displayDebugDialog());
        popup.add(dataItem);
        JMenuItem simItem = new JMenuItem("Device Simulator");
        simItem.addActionListener(event -> this.displaySimulatorWindow());
        popup.add(simItem);
        JMenuItem testItem = new JMenuItem("Test all views/modes");
        testItem.addActionListener(event -> this.testAllControllers());
        popup.add(testItem);
        debugButton.addActionListener(event -> popup.show(debugButton, 0, debugButton.getHeight()));
    }

    private void displaySimulatorWindow() {
        int selectedIndex = this.getSelectedController();
        if (selectedIndex < 0) {
            return;
        }
        ControllerCheckboxListItem checkboxListItem = this.listModel.get(selectedIndex);
        if (checkboxListItem == null) {
            return;
        }
        IControllerInstance controllerInstance = checkboxListItem.item();
        if (controllerInstance != null) {
            controllerInstance.simulateUI();
        }
    }

    private void testAllControllers() {
        int selectedIndex = this.getSelectedController();
        if (selectedIndex < 0) {
            return;
        }
        ControllerCheckboxListItem checkboxListItem = this.listModel.get(selectedIndex);
        if (checkboxListItem == null) {
            return;
        }
        IControllerInstance controllerInstance = checkboxListItem.item();
        if (controllerInstance != null) {
            controllerInstance.testUI();
        }
    }

    private void addController(IControllerDefinition definition) {
        IControllerInstance controllerInstance = this.getCallback().addController(definition);
        if (controllerInstance == null) {
            return;
        }
        ControllerCheckboxListItem inst = new ControllerCheckboxListItem(controllerInstance);
        this.listModel.addElement(inst);
        this.controllerList.setSelectedValue(inst, true);
        this.updateWidgetStates();
        SafeRunLater.execute(this.logModel, this.controllerList::repaint);
    }

    private void displayDebugDialog() {
        this.debugDialog.setVisible(true);
    }

    public void updateWidgetStates() {
        boolean fullyInitialised;
        boolean hasSelection;
        boolean isEmpty = this.controllerList.getModel().getSize() == 0;
        boolean bl = hasSelection = this.getSelectedController() != -1;
        if (!hasSelection && !isEmpty) {
            this.controllerList.setSelectedIndex(0);
            hasSelection = true;
        }
        if (!(fullyInitialised = this.callback.isFullyInitialised())) {
            this.logModel.info("");
            this.logModel.error("Close all Reaper configuration dialogs to enable the DrivenByMoss window!", null);
        }
        boolean isEnabled = hasSelection && fullyInitialised;
        this.configButton.setEnabled(isEnabled);
        this.removeButton.setEnabled(isEnabled);
        this.enableButton.setEnabled(isEnabled);
        this.projectButton.setEnabled(isEnabled);
        this.parameterButton.setEnabled(isEnabled);
        this.detectButton.setEnabled(fullyInitialised);
        this.addButton.setEnabled(fullyInitialised);
        this.debugButton.setEnabled(fullyInitialised);
    }

    private static void addIcon(JButton button, ImageIcon icon) {
        button.setIcon(icon);
        button.setHorizontalAlignment(2);
        button.setIconTextGap(10);
    }

    public AppCallback getCallback() {
        return this.callback;
    }

    private int getSelectedController() {
        return this.controllerList.getSelectedIndex();
    }
}

