/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.hardware;

import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.controller.hardware.IHwPianoKeyboard;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.graphics.IGraphicsContext;
import de.mossgrabers.reaper.framework.hardware.Bounds;
import de.mossgrabers.reaper.framework.hardware.HwControlLayout;
import de.mossgrabers.reaper.framework.hardware.IReaperHwControl;

public class HwPianoKeyboardImpl
implements IHwPianoKeyboard,
IReaperHwControl {
    private static final int NOTE_START = 36;
    private static final int[] KEYS_WHITE = new int[]{0, 2, 4, 5, 7, 9, 11};
    private static final int[] KEYS_BLACK = new int[]{1, 3, -1, 6, 8, 10, -1};
    private static final int[] WHITE_KEYS_DETECT = new int[]{-1, 0, 2, 4, 5, 7, 9, 11, 12};
    private final int numKeys;
    private final HwControlLayout layout;
    private IMidiInput midiInput;
    private boolean isPressed;
    private double pressedX;
    private double pressedY;
    private int pressedKey = -1;
    private int currentValue = 0;
    private double keyHeightWhite;
    private double keyWidthWhite;
    private double keyHeightBlack;
    private double keyWidthBlack;
    private double offset;
    private int steps;
    private double oldWidth;
    private double oldHeight;

    public HwPianoKeyboardImpl(String id, int numKeys, int octave, int startKeyInOctave) {
        this.numKeys = numKeys;
        this.layout = new HwControlLayout(id);
    }

    @Override
    public void bind(IMidiInput input) {
        this.midiInput = input;
    }

    @Override
    public void update() {
    }

    @Override
    public String getLabel() {
        return "Keyboard";
    }

    @Override
    public void setBounds(double x, double y, double width, double height) {
        this.layout.setBounds(x, y, width, height);
    }

    @Override
    public void draw(IGraphicsContext gc, double scale) {
        int i;
        Bounds bounds = this.layout.getBounds();
        if (bounds == null) {
            return;
        }
        double width = bounds.width() * scale;
        double height = bounds.height() * scale;
        if (width != this.oldWidth || height != this.oldHeight) {
            this.oldWidth = width;
            this.oldHeight = height;
            this.steps = this.numKeys / 12 * 7 + 1;
            this.keyHeightWhite = height;
            this.keyWidthWhite = width / (double)this.steps;
            this.keyHeightBlack = this.keyHeightWhite / 1.6;
            this.keyWidthBlack = this.keyWidthWhite / 1.6;
            this.offset = this.keyWidthWhite - this.keyWidthBlack / 2.0;
        }
        double x = bounds.x() * scale;
        double y = bounds.y() * scale;
        int activeKey = this.pressedKey - 36;
        for (i = 0; i < this.steps; ++i) {
            ColorEx color = KEYS_WHITE[i % 7] + 12 * (i / 7) == activeKey ? ColorEx.BLUE : ColorEx.WHITE;
            double left = x + (double)i * this.keyWidthWhite;
            gc.fillRectangle(left, y, this.keyWidthWhite, this.keyHeightWhite, color);
            gc.strokeRectangle(left, y, this.keyWidthWhite, this.keyHeightWhite, ColorEx.BLACK);
        }
        for (i = 0; i < this.steps - 1; ++i) {
            int scalePos = i % 7;
            if (KEYS_BLACK[scalePos] == -1) continue;
            ColorEx color = KEYS_BLACK[scalePos] + 12 * (i / 7) == activeKey ? ColorEx.BLUE : ColorEx.BLACK;
            gc.fillRectangle(x + (double)i * this.keyWidthWhite + this.offset, y, this.keyWidthBlack, this.keyHeightBlack, color);
        }
    }

    @Override
    public void mouse(int mouseEvent, double x, double y, double scale) {
        if (this.midiInput == null) {
            return;
        }
        Bounds bounds = this.layout.getBounds();
        if (bounds == null) {
            return;
        }
        double scaleX = x / scale;
        double scaleY = y / scale;
        if (mouseEvent == 501 && bounds.contains(scaleX, scaleY)) {
            this.isPressed = true;
            this.pressedX = scaleX - bounds.x();
            this.pressedY = scaleY - bounds.y();
            this.pressedKey = 36 + this.getKey(this.pressedX, this.pressedY, scale);
            this.currentValue = 0;
            this.midiInput.sendRawMidiEvent(144, this.pressedKey, 127);
            return;
        }
        if (!this.isPressed) {
            return;
        }
        if (mouseEvent == 502) {
            this.midiInput.sendRawMidiEvent(128, this.pressedKey, 0);
            this.isPressed = false;
            this.pressedKey = -1;
            return;
        }
        if (mouseEvent == 506) {
            double change = Math.min(3.0, Math.max(-3.0, this.pressedX - scaleX + (this.pressedY - scaleY)));
            this.pressedX = scaleX;
            this.pressedY = scaleY;
            this.currentValue = (int)Math.max(0.0, Math.min(127.0, (double)this.currentValue + change));
            this.midiInput.sendRawMidiEvent(160, this.pressedKey, this.currentValue);
        }
    }

    public void sendNoteEvent(boolean isDown, int note, int velocity) {
        if (this.midiInput != null) {
            this.midiInput.sendRawMidiEvent(isDown ? 144 : 128, note, velocity);
        }
    }

    private int getKey(double x, double y, double scale) {
        double kww = this.keyWidthWhite / scale;
        double kwb = this.keyWidthBlack / scale;
        double khb = this.keyHeightBlack / scale;
        int num = (int)(x / kww);
        int pos = num % 7 + 1;
        int whiteKey = 12 * (num / 7) + WHITE_KEYS_DETECT[pos];
        if (y > khb) {
            return whiteKey;
        }
        int transNumX = (int)(x - (double)num * kww);
        if ((double)transNumX <= kwb / 2.0) {
            if (WHITE_KEYS_DETECT[pos] - WHITE_KEYS_DETECT[pos - 1] == 1) {
                return whiteKey;
            }
            return 12 * (num / 7) + WHITE_KEYS_DETECT[pos] - 1;
        }
        if ((double)transNumX >= kww - kwb / 2.0) {
            if (WHITE_KEYS_DETECT[pos + 1] - WHITE_KEYS_DETECT[pos] == 1) {
                return whiteKey;
            }
            return 12 * (num / 7) + WHITE_KEYS_DETECT[pos] + 1;
        }
        return whiteKey;
    }
}

