/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.device.column;

import de.mossgrabers.framework.daw.data.IBrowserColumn;
import de.mossgrabers.framework.daw.data.IBrowserColumnItem;
import de.mossgrabers.framework.utils.StringUtils;
import de.mossgrabers.reaper.communication.Processor;
import de.mossgrabers.reaper.framework.daw.data.ItemImpl;
import de.mossgrabers.reaper.framework.device.column.FilterListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class BaseColumn
extends ItemImpl
implements IBrowserColumn {
    public static final String WILDCARD = "All";
    protected final IBrowserColumnItem[] items;
    private final Set<FilterListener> listeners = new HashSet<FilterListener>(1);
    final int numItemsPerPage;
    int selectedRow = 0;

    protected BaseColumn(int columnIndex, String name, int numItemsPerPage) {
        super(null, columnIndex);
        this.name = name;
        this.numItemsPerPage = numItemsPerPage;
        this.items = new IBrowserColumnItem[numItemsPerPage];
    }

    @Override
    public boolean doesExist() {
        return true;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getName(int limit) {
        return StringUtils.optimizeName(this.getName(), limit);
    }

    @Override
    public String getWildcard() {
        return WILDCARD;
    }

    @Override
    public boolean doesCursorExist() {
        return true;
    }

    @Override
    public String getCursorName() {
        return this.items[this.selectedRow % this.numItemsPerPage].getName();
    }

    @Override
    public String getCursorName(int limit) {
        return StringUtils.optimizeName(this.getCursorName(), limit);
    }

    @Override
    public IBrowserColumnItem[] getItems() {
        return this.items;
    }

    @Override
    public void scrollItemPageUp() {
        this.setCursorIndex(this.selectedRow - this.numItemsPerPage);
    }

    @Override
    public void scrollItemPageDown() {
        this.setCursorIndex(this.selectedRow + this.numItemsPerPage);
    }

    @Override
    public void resetFilter() {
        this.setCursorIndex(0);
    }

    @Override
    public void selectPreviousItem() {
        this.setCursorIndex(this.selectedRow - 1);
    }

    @Override
    public void selectNextItem() {
        this.setCursorIndex(this.selectedRow + 1);
    }

    @Override
    public int getCursorIndex() {
        return this.selectedRow;
    }

    @Override
    public void setCursorIndex(int index) {
        this.selectedRow = Math.max(0, Math.min(index, this.getMaxNumItems()));
        this.notifyListeners();
    }

    protected int getMaxNumItems() {
        return this.getAllItems().size();
    }

    public abstract List<String> getAllItems();

    public void addSelectionListener(FilterListener listener) {
        this.listeners.add(listener);
    }

    protected int calcPosition(int pageIndex) {
        return this.selectedRow / this.numItemsPerPage * this.numItemsPerPage + pageIndex;
    }

    private void notifyListeners() {
        for (FilterListener listener : this.listeners) {
            listener.hasChanged();
        }
    }

    @Override
    protected Processor getProcessor() {
        return null;
    }
}

