/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.daw;

import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.daw.clip.INoteClip;
import de.mossgrabers.framework.daw.clip.IStepInfo;
import de.mossgrabers.framework.daw.clip.NoteOccurrenceType;
import de.mossgrabers.framework.daw.clip.NotePosition;
import de.mossgrabers.framework.daw.clip.StepState;
import de.mossgrabers.framework.daw.constants.Resolution;
import de.mossgrabers.reaper.communication.Processor;
import de.mossgrabers.reaper.framework.daw.BaseImpl;
import de.mossgrabers.reaper.framework.daw.DataSetupEx;
import de.mossgrabers.reaper.framework.daw.Note;
import de.mossgrabers.reaper.framework.daw.StepInfoImpl;
import java.util.ArrayList;
import java.util.List;

public class CursorClipImpl
extends BaseImpl
implements INoteClip {
    private static final String PATH_NOTE = "note/";
    private static final StepInfoImpl EMPTY_STEP = new StepInfoImpl();
    private boolean exists = false;
    private double clipStart = -1.0;
    private double clipEnd = -1.0;
    private boolean isLooped = false;
    private ColorEx color;
    private double playPosition = -1.0;
    private final int numSteps;
    private final int numRows;
    private double stepLength;
    private final List<Note> notes = new ArrayList<Note>();
    private final StepInfoImpl[][][] data;
    private int editPage = 0;
    private int maxPage = 1;
    private final List<NotePosition> editSteps = new ArrayList<NotePosition>();

    public CursorClipImpl(DataSetupEx dataSetup, int numSteps, int numRows) {
        super(dataSetup);
        this.numSteps = numSteps;
        this.numRows = numRows;
        this.stepLength = 0.25;
        this.data = new StepInfoImpl[16][this.numSteps][];
        for (int channel = 0; channel < 16; ++channel) {
            for (int step = 0; step < this.numSteps; ++step) {
                this.data[channel][step] = new StepInfoImpl[this.numRows];
                for (int row = 0; row < this.numRows; ++row) {
                    this.data[channel][step][row] = new StepInfoImpl();
                }
            }
        }
    }

    @Override
    public void enableObservers(boolean enable) {
        this.sender.enableUpdates(Processor.CLIP, enable);
    }

    @Override
    public boolean doesExist() {
        return this.exists;
    }

    public void setExistsValue(boolean exists) {
        this.exists = exists;
    }

    @Override
    public void setName(String name) {
        this.sendOSC("name", name);
    }

    @Override
    public void setColor(ColorEx color) {
        int[] rgb = color.toIntRGB255();
        this.sendOSC("color", "RGB(" + rgb[0] + "," + rgb[1] + "," + rgb[2] + ")");
    }

    public void setColorValue(double[] color) {
        this.color = new ColorEx(color);
    }

    @Override
    public ColorEx getColor() {
        return this.color;
    }

    @Override
    public double getPlayStart() {
        return this.clipStart;
    }

    @Override
    public void setPlayStart(double start) {
        this.clipStart = start;
        this.sendOSC("start", this.clipStart);
        this.updateNoteData();
    }

    @Override
    public void changePlayStart(int control, boolean slow) {
        if (this.clipStart == -1.0) {
            return;
        }
        boolean increase = this.valueChanger.isIncrease(control);
        double frac = slow ? 1.0 : 4.0;
        this.setPlayStart(increase ? this.clipStart + frac : Math.max(this.clipStart - frac, 0.0));
    }

    @Override
    public double getPlayEnd() {
        return this.clipEnd;
    }

    @Override
    public void setPlayEnd(double end) {
        this.clipEnd = end;
        this.sendOSC("end", this.clipEnd);
        this.updateNoteData();
    }

    @Override
    public void changePlayEnd(int control, boolean slow) {
        if (this.clipEnd == -1.0) {
            return;
        }
        boolean increase = this.valueChanger.isIncrease(control);
        double frac = slow ? 1.0 : 4.0;
        this.setPlayEnd(increase ? this.clipEnd + frac : Math.max(this.clipEnd - frac, 0.0));
    }

    @Override
    public void setPlayRange(double start, double end) {
        double playStart = this.getPlayStart();
        this.setPlayStart(playStart + start);
        this.setPlayEnd(playStart + end);
    }

    private void calcPages() {
        double length = this.clipEnd - this.clipStart;
        double pageLength = (double)this.numSteps * this.stepLength;
        this.maxPage = (int)Math.ceil(length / pageLength);
        this.editPage = Math.max(0, Math.min(this.editPage, this.maxPage - 1));
    }

    @Override
    public double getLoopStart() {
        return 0.0;
    }

    @Override
    public void setLoopStart(double start) {
        this.setPlayStart(this.getPlayStart() + start);
    }

    @Override
    public void changeLoopStart(int control, boolean slow) {
        this.changePlayStart(control, slow);
    }

    @Override
    public double getLoopLength() {
        return this.getPlayEnd() - this.getPlayStart();
    }

    @Override
    public void setLoopLength(double length) {
        this.setPlayEnd(this.getPlayStart() + length);
    }

    @Override
    public void changeLoopLength(int control, boolean slow) {
        this.changePlayEnd(control, slow);
    }

    @Override
    public boolean isLoopEnabled() {
        return this.isLooped;
    }

    @Override
    public void setLoopEnabled(boolean enable) {
        this.sendOSC("loop", enable);
    }

    public void setLoopEnabledState(boolean isLoopEnabled) {
        this.isLooped = isLoopEnabled;
    }

    @Override
    public boolean isShuffleEnabled() {
        return false;
    }

    @Override
    public void setShuffleEnabled(boolean enable) {
    }

    @Override
    public String getFormattedAccent() {
        return Math.round(this.getAccent() * 10000.0) / 100L + "%";
    }

    @Override
    public double getAccent() {
        return 1.0;
    }

    @Override
    public void resetAccent() {
    }

    @Override
    public void changeAccent(int control, boolean slow) {
    }

    @Override
    public int getNumSteps() {
        return this.numSteps;
    }

    @Override
    public int getNumRows() {
        return this.numRows;
    }

    @Override
    public int getCurrentStep() {
        if (this.playPosition == -1.0) {
            return -1;
        }
        double offset = this.playPosition - this.clipStart;
        if (offset < 0.0) {
            return -1;
        }
        return (int)Math.floor(offset / this.stepLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StepInfoImpl getStep(NotePosition notePosition) {
        int channel = notePosition.getChannel();
        int step = notePosition.getStep();
        int row = notePosition.getNote();
        List<Note> list = this.notes;
        synchronized (list) {
            if (step < 0 || row < 0 || step >= this.data[channel].length || row >= this.data[channel][step].length) {
                return EMPTY_STEP;
            }
            return this.data[channel][step][row];
        }
    }

    @Override
    public void toggleStep(NotePosition notePosition, int velocity) {
        int step = notePosition.getStep();
        int row = notePosition.getNote();
        double pos = (double)(step + this.editPage * this.numSteps) * this.stepLength;
        this.sendOSC(PATH_NOTE + row + "/toggle", pos + " " + this.stepLength + " " + velocity + " " + notePosition.getChannel() + " 0");
    }

    @Override
    public void setStep(NotePosition notePosition, IStepInfo noteStep) {
        this.setStep(notePosition, (int)(noteStep.getVelocity() * 127.0), noteStep.getDuration());
    }

    @Override
    public void setStep(NotePosition notePosition, int velocity, double duration) {
        int step = notePosition.getStep();
        int row = notePosition.getNote();
        double pos = (double)(step + this.editPage * this.numSteps) * this.stepLength;
        this.sendOSC(PATH_NOTE + row + "/set", pos + " " + duration + " " + velocity + " " + notePosition.getChannel() + " 0");
    }

    public void updateStep(NotePosition notePosition, int velocity, double duration, boolean isMuted) {
        int step = notePosition.getStep();
        int row = notePosition.getNote();
        double pos = (double)(step + this.editPage * this.numSteps) * this.stepLength;
        this.sendOSC(PATH_NOTE + row + "/update", pos + " " + duration + " " + velocity + " " + notePosition.getChannel() + " " + (isMuted ? "1" : "0"));
    }

    @Override
    public void changeStepMuteState(NotePosition notePosition, int control) {
        this.updateStepMuteState(notePosition, this.valueChanger.isIncrease(control));
    }

    @Override
    public void updateStepMuteState(NotePosition notePosition, boolean isMuted) {
        StepInfoImpl stepInfo = this.getStep(notePosition);
        if (stepInfo.getState() == StepState.OFF) {
            return;
        }
        stepInfo.setMuted(isMuted);
        if (this.editSteps.isEmpty()) {
            double velocity = stepInfo.getVelocity();
            this.updateStep(notePosition, (int)(velocity * 127.0), stepInfo.getDuration(), isMuted);
        }
    }

    @Override
    public void changeStepDuration(NotePosition notePosition, int control) {
        StepInfoImpl info = this.getStep(notePosition);
        boolean increase = this.valueChanger.isIncrease(control);
        double res = Resolution.RES_1_32.getValue();
        this.updateStepDuration(notePosition, Math.max(0.0, info.getDuration() + (increase ? res : -res)));
    }

    @Override
    public void updateStepDuration(NotePosition notePosition, double duration) {
        if (duration == 0.0) {
            return;
        }
        StepInfoImpl stepInfo = this.getStep(notePosition);
        if (stepInfo.getState() == StepState.OFF) {
            return;
        }
        stepInfo.setDuration(duration);
        if (this.editSteps.isEmpty()) {
            double velocity = stepInfo.getVelocity();
            this.updateStep(notePosition, (int)(velocity * 127.0), duration, stepInfo.isMuted());
        }
    }

    @Override
    public void changeStepVelocity(NotePosition notePosition, int control) {
        StepInfoImpl info = this.getStep(notePosition);
        double velocity = info.getVelocity() + this.valueChanger.toNormalizedValue((int)this.valueChanger.calcKnobChange(control));
        this.updateStepVelocity(notePosition, Math.min(1.0, Math.max(0.0, velocity)));
    }

    @Override
    public void updateStepVelocity(NotePosition notePosition, double velocity) {
        int midiVelocity = (int)(velocity * 127.0);
        if (midiVelocity == 0) {
            return;
        }
        StepInfoImpl stepInfo = this.getStep(notePosition);
        if (stepInfo.getState() == StepState.OFF) {
            return;
        }
        stepInfo.setVelocity(velocity);
        if (this.editSteps.isEmpty()) {
            double duration = stepInfo.getDuration();
            this.updateStep(notePosition, midiVelocity, duration, stepInfo.isMuted());
        }
    }

    @Override
    public void changeStepReleaseVelocity(NotePosition notePosition, int control) {
    }

    @Override
    public void updateStepReleaseVelocity(NotePosition notePosition, double releaseVelocity) {
    }

    @Override
    public void changeStepPressure(NotePosition notePosition, int control) {
    }

    @Override
    public void updateStepPressure(NotePosition notePosition, double pressure) {
    }

    @Override
    public void changeStepTimbre(NotePosition notePosition, int control) {
    }

    @Override
    public void updateStepTimbre(NotePosition notePosition, double timbre) {
    }

    @Override
    public void changeStepPan(NotePosition notePosition, int control) {
    }

    @Override
    public void updateStepPan(NotePosition notePosition, double panning) {
    }

    @Override
    public void changeStepTranspose(NotePosition notePosition, int control) {
    }

    @Override
    public void updateStepTranspose(NotePosition notePosition, double semitones) {
    }

    @Override
    public double getStepTransposeRange() {
        return 96.0;
    }

    @Override
    public void updateStepGain(NotePosition notePosition, double gain) {
    }

    @Override
    public void changeStepGain(NotePosition notePosition, int control) {
    }

    @Override
    public void updateStepVelocitySpread(NotePosition notePosition, double velocitySpread) {
    }

    @Override
    public void changeStepVelocitySpread(NotePosition notePosition, int control) {
    }

    @Override
    public void updateStepIsChanceEnabled(NotePosition notePosition, boolean isEnabled) {
    }

    @Override
    public void updateStepChance(NotePosition notePosition, double chance) {
    }

    @Override
    public void changeStepChance(NotePosition notePosition, int control) {
    }

    @Override
    public void updateStepIsOccurrenceEnabled(NotePosition notePosition, boolean isEnabled) {
    }

    @Override
    public void setStepPrevNextOccurrence(NotePosition notePosition, boolean increase) {
    }

    @Override
    public void setStepOccurrence(NotePosition notePosition, NoteOccurrenceType occurrence) {
    }

    @Override
    public void updateStepIsRecurrenceEnabled(NotePosition notePosition, boolean isEnabled) {
    }

    @Override
    public void updateStepRecurrenceLength(NotePosition notePosition, int recurrenceLength) {
    }

    @Override
    public void updateStepRecurrenceMask(NotePosition notePosition, int mask) {
    }

    @Override
    public void changeStepRecurrenceLength(NotePosition notePosition, int control) {
    }

    @Override
    public void updateStepIsRepeatEnabled(NotePosition notePosition, boolean isEnabled) {
    }

    @Override
    public void updateStepRepeatCount(NotePosition notePosition, int value) {
    }

    @Override
    public void changeStepRepeatCount(NotePosition notePosition, int control) {
    }

    @Override
    public void updateStepRepeatCurve(NotePosition notePosition, double value) {
    }

    @Override
    public void changeStepRepeatCurve(NotePosition notePosition, int control) {
    }

    @Override
    public void updateStepRepeatVelocityCurve(NotePosition notePosition, double value) {
    }

    @Override
    public void changeStepRepeatVelocityCurve(NotePosition notePosition, int control) {
    }

    @Override
    public void updateStepRepeatVelocityEnd(NotePosition notePosition, double value) {
    }

    @Override
    public void changeStepRepeatVelocityEnd(NotePosition notePosition, int control) {
    }

    @Override
    public void startEdit(List<NotePosition> editSteps) {
        this.stopEdit();
        this.editSteps.addAll(editSteps);
        for (NotePosition step : this.editSteps) {
            this.delayedUpdate(step);
        }
    }

    @Override
    public void stopEdit() {
        if (this.editSteps.isEmpty()) {
            return;
        }
        for (NotePosition editStep : this.editSteps) {
            this.sendClipData(editStep);
        }
        this.editSteps.clear();
        this.updateNoteData();
    }

    private void delayedUpdate(NotePosition editStep) {
        if (this.editSteps.isEmpty()) {
            return;
        }
        this.sendClipData(editStep);
        this.host.scheduleTask(() -> this.delayedUpdate(new NotePosition(editStep.getChannel(), editStep.getStep(), editStep.getNote())), 100L);
    }

    private void sendClipData(NotePosition notePosition) {
        StepInfoImpl stepInfo = this.data[notePosition.getChannel()][notePosition.getStep()][notePosition.getNote()];
        double velocity = stepInfo.getVelocity();
        this.updateStep(notePosition, (int)(velocity * 127.0), stepInfo.getDuration(), stepInfo.isMuted());
    }

    @Override
    public void clearAll() {
        this.sendOSC("clear");
    }

    @Override
    public void clearStep(NotePosition notePosition) {
        int channel = notePosition.getChannel();
        int step = notePosition.getStep();
        int row = notePosition.getNote();
        this.sendOSC(PATH_NOTE + row + "/clear/" + channel, (double)(step + this.editPage * this.numSteps) * this.stepLength);
    }

    @Override
    public void moveStepY(NotePosition notePosition, int newRow) {
        int channel = notePosition.getChannel();
        int step = notePosition.getStep();
        int row = notePosition.getNote();
        this.sendOSC(PATH_NOTE + row + "/moveY/" + channel + "/" + newRow, (double)(step + this.editPage * this.numSteps) * this.stepLength);
    }

    @Override
    public void clearRow(int channel, int row) {
        this.sendOSC(PATH_NOTE + row + "/clear/" + channel);
    }

    @Override
    public void clearColumn(int channel, int column) {
        this.sendOSC("note/0/clearPosition/" + channel, (double)(column + this.editPage * this.numSteps) * this.stepLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasRowData(int channel, int row) {
        List<Note> list = this.notes;
        synchronized (list) {
            for (int step = 0; step < this.numSteps; ++step) {
                if (this.data[channel][step][row].getState() == StepState.OFF) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasColumnData(int channel, int column) {
        List<Note> list = this.notes;
        synchronized (list) {
            for (int row = 0; row < 128; ++row) {
                if (this.data[channel][column][row].getState() == StepState.OFF) continue;
                return true;
            }
            return false;
        }
    }

    @Override
    public int getLowestRowWithData() {
        int min = 128;
        for (int channel = 0; channel < 16; ++channel) {
            int lower = this.getLowestRowWithData(channel);
            if (lower < 0 || lower >= min) continue;
            min = lower;
        }
        return min == 128 ? -1 : min;
    }

    @Override
    public int getHighestRowWithData() {
        int max = -1;
        for (int channel = 0; channel < 16; ++channel) {
            int upper = this.getHighestRowWithData(channel);
            if (upper < 0 || upper <= max) continue;
            max = upper;
        }
        return max;
    }

    @Override
    public int getLowestRowWithData(int channel) {
        for (int row = 0; row < this.numRows; ++row) {
            if (!this.hasRowData(channel, row)) continue;
            return row;
        }
        return -1;
    }

    @Override
    public int getHighestRowWithData(int channel) {
        for (int row = this.numRows - 1; row >= 0; --row) {
            if (!this.hasRowData(channel, row)) continue;
            return row;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getHighestRow(int channel, int step) {
        List<Note> list = this.notes;
        synchronized (list) {
            for (int row = this.numRows - 1; row >= 0; --row) {
                if (this.data[channel] == null || this.data[channel][step] == null || this.data[channel][step][row] == null || this.data[channel][step][row].getState() == StepState.OFF) continue;
                return row;
            }
        }
        return -1;
    }

    @Override
    public void setStepLength(double length) {
        this.stepLength = length;
        this.updateNoteData();
    }

    @Override
    public double getStepLength() {
        return this.stepLength;
    }

    @Override
    public void scrollToPage(int page) {
        this.editPage = Math.max(0, Math.min(page, this.maxPage - 1));
        this.updateNoteData();
    }

    @Override
    public int getEditPage() {
        return this.editPage;
    }

    @Override
    public void scrollStepsPageBackwards() {
        this.scrollToPage(this.editPage - 1);
    }

    @Override
    public void scrollStepsPageForward() {
        this.scrollToPage(this.editPage + 1);
    }

    @Override
    public boolean canScrollStepsBackwards() {
        return this.getEditPage() > 0;
    }

    @Override
    public boolean canScrollStepsForwards() {
        return this.editPage < this.maxPage - 1;
    }

    @Override
    public void duplicate() {
        this.sendOSC("duplicate");
    }

    @Override
    public void duplicateContent() {
        this.sendOSC("duplicateContent");
    }

    @Override
    public void quantize(double amount) {
        this.sender.processDoubleArg(Processor.QUANTIZE, amount);
    }

    @Override
    public void transpose(int semitones) {
        this.sendOSC("transpose", semitones);
    }

    public void setPlayPosition(double playPosition) {
        this.playPosition = playPosition;
    }

    public void setPlayStartIntern(double start) {
        this.clipStart = start;
        this.updateNoteData();
    }

    public void setPlayEndIntern(double end) {
        this.clipEnd = end;
        this.updateNoteData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNotes(List<Note> notes) {
        List<Note> list = this.notes;
        synchronized (list) {
            this.notes.clear();
            this.notes.addAll(notes);
            this.updateNoteData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNoteData() {
        List<Note> list = this.notes;
        synchronized (list) {
            for (int channel = 0; channel < 16; ++channel) {
                for (int row = 0; row < this.numRows; ++row) {
                    for (int step = 0; step < this.numSteps; ++step) {
                        StepInfoImpl stepInfo = this.data[channel][step][row];
                        if (!this.editSteps.isEmpty()) continue;
                        stepInfo.setState(StepState.OFF);
                    }
                }
            }
            this.notes.forEach(this::updateNote);
            this.calcPages();
        }
    }

    private void updateNote(Note note) {
        int pageOffset;
        int row = note.getPitch();
        if (row < 0 || row >= this.numRows) {
            return;
        }
        int step = (int)Math.floor(note.getStart() / this.stepLength);
        int relToPage = step - (pageOffset = this.editPage * this.numSteps);
        if (relToPage < 0 || relToPage >= this.numSteps) {
            return;
        }
        int channel = note.getChannel();
        StepInfoImpl stepInfo = this.data[channel][relToPage][row];
        if (!this.editSteps.isEmpty()) {
            return;
        }
        stepInfo.setSelected(note.isSelected());
        stepInfo.setMuted(note.isMuted());
        stepInfo.setState(StepState.START);
        stepInfo.setDuration(note.getEnd() - note.getStart());
        stepInfo.setVelocity((double)note.getVelocity() / 127.0);
        int endStep = Math.min((int)Math.floor(note.getEnd() / this.stepLength) - pageOffset, this.numSteps);
        for (int i = relToPage + 1; i < endStep; ++i) {
            StepInfoImpl stepInfoEx = this.data[channel][i][row];
            stepInfoEx.setState(StepState.CONTINUE);
            stepInfoEx.setSelected(note.isSelected());
            stepInfoEx.setMuted(note.isMuted());
        }
    }

    @Override
    protected Processor getProcessor() {
        return Processor.CLIP;
    }

    @Override
    public boolean isPinned() {
        return false;
    }

    @Override
    public void togglePinned() {
    }

    @Override
    public void setPinned(boolean isPinned) {
    }

    @Override
    public NotePosition getNextNote(NotePosition activeNotePosition, boolean ignoreChannel) {
        NotePosition pos = activeNotePosition == null ? new NotePosition(0, 0, 128) : activeNotePosition;
        int channel = pos.getChannel();
        int channelStart = ignoreChannel ? 0 : channel;
        int channelEnd = ignoreChannel ? 16 : channel + 1;
        for (int step = pos.getStep(); step < this.numSteps; ++step) {
            int startNote;
            for (int row = startNote = step == pos.getStep() ? pos.getNote() - 1 : 127; row >= 0; --row) {
                for (int chn = channelStart; chn < channelEnd; ++chn) {
                    if (this.data[chn] == null || this.data[chn][step] == null || this.data[chn][step][row] == null || this.data[chn][step][row].getState() != StepState.START) continue;
                    return new NotePosition(channel, step, row);
                }
            }
        }
        return null;
    }

    @Override
    public NotePosition getPreviousNote(NotePosition activeNotePosition, boolean ignoreChannel) {
        NotePosition pos = activeNotePosition == null ? new NotePosition(0, this.numSteps - 1, -1) : activeNotePosition;
        int channel = pos.getChannel();
        int channelStart = ignoreChannel ? 0 : channel;
        int channelEnd = ignoreChannel ? 16 : channel + 1;
        for (int step = pos.getStep(); step >= 0; --step) {
            int startNote;
            for (int row = startNote = step == pos.getStep() ? pos.getNote() + 1 : 0; row < 128; ++row) {
                for (int chn = channelStart; chn < channelEnd; ++chn) {
                    if (this.data[chn] == null || this.data[chn][step] == null || this.data[chn][step][row] == null || this.data[chn][step][row].getState() != StepState.START) continue;
                    return new NotePosition(channel, step, row);
                }
            }
        }
        return null;
    }
}

