/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper;

import de.mossgrabers.framework.controller.IControllerDefinition;
import de.mossgrabers.framework.utils.OperatingSystem;
import de.mossgrabers.framework.utils.Pair;
import de.mossgrabers.reaper.AppCallback;
import de.mossgrabers.reaper.MainConfiguration;
import de.mossgrabers.reaper.communication.BackendExchange;
import de.mossgrabers.reaper.communication.Processor;
import de.mossgrabers.reaper.controller.ControllerInstanceManager;
import de.mossgrabers.reaper.controller.IControllerInstance;
import de.mossgrabers.reaper.framework.Actions;
import de.mossgrabers.reaper.framework.IniFiles;
import de.mossgrabers.reaper.framework.configuration.DocumentSettingsUI;
import de.mossgrabers.reaper.framework.configuration.IfxSetting;
import de.mossgrabers.reaper.framework.daw.BrowserContentType;
import de.mossgrabers.reaper.framework.device.DeviceManager;
import de.mossgrabers.reaper.framework.graphics.SVGImage;
import de.mossgrabers.reaper.framework.midi.MidiAccessImpl;
import de.mossgrabers.reaper.framework.midi.MidiConnection;
import de.mossgrabers.reaper.framework.midi.ReaperMidiDevice;
import de.mossgrabers.reaper.ui.MainFrame;
import de.mossgrabers.reaper.ui.WindowManager;
import de.mossgrabers.reaper.ui.utils.LogModel;
import de.mossgrabers.reaper.ui.utils.PropertiesEx;
import de.mossgrabers.reaper.ui.utils.SafeRunLater;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.SysexMessage;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.usb4java.LibUsb;
import org.usb4java.LibUsbException;

public class MainApp
implements BackendExchange,
AppCallback,
WindowManager {
    private static final int DEVICE_UPDATE_RATE = 30;
    private static final Pattern TAG_PATTERN = Pattern.compile("(.*?)=\"(.*?)\"\\s*");
    private final LogModel logModel = new LogModel();
    private final MainConfiguration mainConfiguration = new MainConfiguration();
    private final Object mainFrameLock = new Object();
    private MainFrame mainFrame;
    private final ControllerInstanceManager instanceManager;
    private Timer animationTimer = null;
    private final String iniPath;
    private final IniFiles iniFiles = new IniFiles();
    private final Object startupLock = new Object();
    private final Map<String, String> instanceSettings = new HashMap<String, String>();

    public MainApp(String iniPath, int majorVersion, int minorVersion) {
        this.iniPath = iniPath;
        Thread.setDefaultUncaughtExceptionHandler((thread, throwable) -> {
            StringWriter writer = new StringWriter();
            throwable.printStackTrace(new PrintWriter(writer));
            this.logModel.info(writer.toString());
        });
        this.instanceManager = new ControllerInstanceManager(this.logModel, this, this, this.iniFiles, majorVersion, minorVersion);
        if (this.iniPath == null || this.iniPath.isEmpty()) {
            this.logModel.info("Missing INI path parameter! Cannot start the application.");
            return;
        }
        this.loadConfig();
        this.loadINIFiles(this.iniPath);
    }

    protected void initUSB() {
        try {
            int result = LibUsb.init(null);
            if (result != 0) {
                throw new LibUsbException("Unable to initialize libusb.", result);
            }
            LibUsb.setOption(null, (int)0, (int)2);
        }
        catch (LibUsbException ex) {
            this.logModel.error("Could not initialise LibUsb.", ex);
        }
    }

    public void exit() {
        this.logModel.info("Exiting platform...");
        this.logModel.info("Stopping flush timer...");
        if (this.animationTimer != null) {
            this.animationTimer.stop();
        }
        this.instanceManager.stopAll();
        SVGImage.clearCache();
        this.logModel.info("Storing configuration...");
        this.instanceManager.save(this.mainConfiguration);
        this.saveConfig();
        MidiConnection.cleanupUnusedDevices();
        this.logModel.info("Shutting down USB...");
        if (OperatingSystem.get() == OperatingSystem.WINDOWS) {
            LibUsb.exit(null);
        }
    }

    protected void loadConfig() {
        try {
            this.mainConfiguration.load(this.iniPath);
        }
        catch (IOException ex) {
            this.logModel.error("Could not load main configuration.", ex);
        }
        SVGImage.clearCache();
    }

    protected void saveConfig() {
        if (this.iniPath == null) {
            return;
        }
        try {
            if (this.mainFrame != null) {
                this.mainConfiguration.storeStagePlacement(this.mainFrame);
            }
            this.mainConfiguration.save(this.iniPath);
        }
        catch (IOException ex) {
            this.logModel.error("Could not store configuration file.", ex);
        }
    }

    public void addDevice(String name, String identifier) {
        DeviceManager.get().addDeviceInfo(name, identifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startupInfrastructure() {
        Object object = this.startupLock;
        synchronized (object) {
            MidiAccessImpl.init(this);
            DeviceManager.get().applyDeviceInfo(this.iniFiles, this.logModel);
            if (this.animationTimer != null) {
                return;
            }
            this.animationTimer = new Timer(30, event -> {
                try {
                    this.flushToController();
                }
                catch (RuntimeException ex) {
                    this.logModel.error("Crash in flush timer.", ex);
                }
            });
            this.initUSB();
            this.startFlushTimer();
            MidiAccessImpl.readDeviceMetadata();
            this.instanceManager.load(this.mainConfiguration);
            this.startControllers();
            if (this.mainFrame != null) {
                this.mainFrame.fillControllerList();
            }
            SwingUtilities.invokeLater(() -> {
                Timer timer = new Timer(2000, e -> this.processInstanceSettings());
                timer.setRepeats(false);
                timer.start();
            });
        }
    }

    private void startControllers() {
        this.instanceManager.startAll();
        SafeRunLater.execute(this.logModel, this::sendRefreshCommand);
    }

    public void restartControllers() {
        this.instanceManager.stopAll();
        this.startControllers();
    }

    void flushToController() {
        this.instanceManager.flushAll();
    }

    private void startFlushTimer() {
        if (this.animationTimer != null) {
            this.animationTimer.start();
        }
    }

    public void closeSocket(Socket socket) {
        if (socket == null) {
            return;
        }
        try {
            socket.close();
        }
        catch (IOException ex) {
            this.logModel.error("Could not close socket.", ex);
        }
    }

    private void handleReceiveOSC(String address, String argument) {
        this.instanceManager.parseAll(address, argument);
    }

    @Override
    public void invokeAction(int actionID) {
        if (Actions.isBlocked(actionID)) {
            return;
        }
        this.processIntArg("action", "", actionID);
    }

    @Override
    public void processNoArg(Processor processor, String command) {
        this.processNoArg(processor.name().toLowerCase(Locale.US), command);
    }

    public native void processNoArg(String var1, String var2);

    @Override
    public void processStringArg(Processor processor, String command, String value) {
        this.processStringArg(processor.name().toLowerCase(Locale.US), command, value);
    }

    public native void processStringArg(String var1, String var2, String var3);

    @Override
    public void processStringArgs(Processor processor, String command, String[] values) {
        this.processStringArgs(processor.name().toLowerCase(Locale.US), command, values);
    }

    public native void processStringArgs(String var1, String var2, String[] var3);

    @Override
    public void processIntArg(Processor processor, String command, int value) {
        this.processIntArg(processor.name().toLowerCase(Locale.US), command, value);
    }

    public native void processIntArg(String var1, String var2, int var3);

    @Override
    public void processDoubleArg(Processor processor, String command, double value) {
        this.processDoubleArg(processor.name().toLowerCase(Locale.US), command, value);
    }

    public native void processDoubleArg(String var1, String var2, double var3);

    @Override
    public void delayUpdates(Processor processor) {
        this.delayUpdates(processor.name().toLowerCase(Locale.US));
    }

    public native void delayUpdates(String var1);

    @Override
    public void enableUpdates(Processor processor, boolean enable) {
        this.enableUpdates(processor.name().toLowerCase(Locale.US), enable);
    }

    public native void enableUpdates(String var1, boolean var2);

    @Override
    public native void processMidiArg(int var1, int var2, int var3, int var4);

    @Override
    public native Map<Integer, String> getMidiInputs();

    @Override
    public native Map<Integer, String> getMidiOutputs();

    @Override
    public IControllerInstance addController(IControllerDefinition definition) {
        if (this.instanceManager.isInstantiated(definition)) {
            this.logModel.info("Only one instance of a controller type is supported!");
            return null;
        }
        IControllerInstance controllerInstance = this.instanceManager.instantiate(definition);
        controllerInstance.start();
        this.sendRefreshCommand();
        return controllerInstance;
    }

    @Override
    public List<IControllerInstance> detectControllers() {
        MidiAccessImpl.readDeviceMetadata();
        ArrayList<IControllerInstance> addedControllers = new ArrayList<IControllerInstance>();
        for (IControllerDefinition definition : this.instanceManager.getDefinitions()) {
            if (this.instanceManager.isInstantiated(definition)) continue;
            for (Pair<String[], String[]> pair : definition.getMidiDiscoveryPairs(OperatingSystem.get())) {
                IControllerInstance c;
                if (!this.matchPorts(pair.getKey(), pair.getValue()) || (c = this.addController(definition)) == null) continue;
                addedControllers.add(c);
            }
        }
        return addedControllers;
    }

    private boolean matchPorts(String[] ins, String[] outs) {
        if (ins.length == 0 && outs.length == 0) {
            return false;
        }
        List<MidiDevice> inputDevices = MainApp.lookupInputs(ins);
        if (ins.length != inputDevices.size()) {
            return false;
        }
        List<MidiDevice> outputDevices = MainApp.lookupOutputs(outs);
        if (outs.length != outputDevices.size()) {
            return false;
        }
        return !this.instanceManager.areInUse(inputDevices, outputDevices);
    }

    private static List<MidiDevice> lookupOutputs(String[] outs) {
        ArrayList<MidiDevice> outputDevices = new ArrayList<MidiDevice>();
        for (String outputName : outs) {
            MidiDevice outputDevice = MidiAccessImpl.getOutputDevice(outputName);
            if (outputDevice == null) continue;
            outputDevices.add(outputDevice);
        }
        return outputDevices;
    }

    private static List<MidiDevice> lookupInputs(String[] ins) {
        ArrayList<MidiDevice> inputDevices = new ArrayList<MidiDevice>();
        for (String inputName : ins) {
            MidiDevice inputDevice = MidiAccessImpl.getInputDevice(inputName);
            if (inputDevice == null) continue;
            inputDevices.add(inputDevice);
        }
        return inputDevices;
    }

    @Override
    public void editController(int controllerIndex) {
        this.instanceManager.edit(controllerIndex);
        this.instanceManager.getInstances().get(controllerIndex).restart();
        this.sendRefreshCommand();
    }

    @Override
    public void removeController(int controllerIndex) {
        this.instanceManager.remove(controllerIndex);
    }

    @Override
    public void toggleEnableController(int controllerIndex) {
        IControllerInstance controller = this.instanceManager.getInstances().get(controllerIndex);
        controller.storeConfiguration();
        if (controller.isEnabled()) {
            controller.start();
            this.sendRefreshCommand();
        } else {
            controller.stop();
        }
    }

    @Override
    public void projectSettings() {
        this.instanceManager.projectSettings();
    }

    @Override
    public void parameterSettings(int controllerIndex) {
        this.instanceManager.parameterSettings(controllerIndex);
    }

    @Override
    public void sendRefreshCommand() {
        this.processNoArg(Processor.REFRESH);
    }

    @Override
    public void sendMIDIPortRefreshCommand() {
        this.instanceManager.refreshMIDIAll();
        this.restartControllers();
        SafeRunLater.execute(this.logModel, () -> this.mainFrame.forceRedrawControllerList());
    }

    @Override
    public void clearLogMessage() {
        this.logModel.clearLogMessage();
    }

    public void updateModel(String data) {
        if (data == null || data.isEmpty()) {
            return;
        }
        SafeRunLater.execute(this.logModel, () -> {
            for (String command : data.split("\n")) {
                String[] split = command.split(" ");
                String params = split.length == 1 ? null : command.substring(split[0].length() + 1);
                try {
                    this.handleReceiveOSC(split[0], params);
                }
                catch (IllegalArgumentException ex) {
                    StringWriter sw = new StringWriter();
                    ex.printStackTrace(new PrintWriter(sw));
                    this.logModel.info(sw.toString());
                }
            }
        });
    }

    public void setDefaultDocumentSettings() {
        for (IControllerInstance instance : this.instanceManager.getInstances()) {
            instance.getDocumentSettingsUI().getSettings().forEach(IfxSetting::reset);
        }
    }

    public String getFormattedDocumentSettings() {
        StringBuilder data = new StringBuilder();
        for (IControllerInstance instance : this.instanceManager.getInstances()) {
            IControllerDefinition definition = instance.getDefinition();
            DocumentSettingsUI documentSettingsUI = instance.getDocumentSettingsUI();
            documentSettingsUI.store();
            PropertiesEx properties = documentSettingsUI.store();
            StringWriter writer = new StringWriter();
            Base64.Encoder encoder = Base64.getEncoder();
            try {
                properties.store(writer, "");
                String str = writer.toString();
                String encodedString = encoder.encodeToString(str.getBytes(StandardCharsets.UTF_8));
                String tag = definition.getHardwareModel().replace(' ', '_').replace('/', '_').toUpperCase(Locale.US);
                data.append(tag).append("=\"").append(encodedString).append("\"\n");
            }
            catch (IOException ex) {
                StringWriter sw = new StringWriter();
                ex.printStackTrace(new PrintWriter(sw));
                this.logModel.info(sw.toString());
            }
        }
        return data.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFormattedDocumentSettings(String data) {
        Matcher matcher = TAG_PATTERN.matcher(data);
        Base64.Decoder decoder = Base64.getDecoder();
        Map<String, String> map = this.instanceSettings;
        synchronized (map) {
            this.instanceSettings.clear();
            while (matcher.find() && matcher.groupCount() == 2) {
                String tag = matcher.group(1);
                String propertiesText = new String(decoder.decode(matcher.group(2)), StandardCharsets.UTF_8);
                this.instanceSettings.put(tag, propertiesText);
            }
            if (this.isFullyInitialised()) {
                this.processInstanceSettings();
            }
        }
    }

    public void onMIDIMessage(int deviceID, byte[] data) {
        MidiMessage midiMessage;
        block6: {
            try {
                int statusInt = data[0] & 0xFF;
                if (statusInt == 240) {
                    midiMessage = new SysexMessage(data, data.length);
                    break block6;
                }
                if (data.length == 3) {
                    midiMessage = new ShortMessage(statusInt, data[1] & 0xFF, data[2] & 0xFF);
                    break block6;
                }
                if (data.length == 1 && statusInt == 254) {
                    return;
                }
                throw new InvalidMidiDataException("Unknown MIDI data of length " + data.length);
            }
            catch (InvalidMidiDataException ex) {
                this.logModel.info(ex.getMessage());
                return;
            }
        }
        for (ReaperMidiDevice input : MidiAccessImpl.getInputDevices()) {
            if (input.getDeviceID() != deviceID) continue;
            input.handleMidiMessageFromBackend(midiMessage);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processInstanceSettings() {
        Map<String, String> map = this.instanceSettings;
        synchronized (map) {
            if (this.instanceSettings.isEmpty()) {
                return;
            }
            for (IControllerInstance instance : this.instanceManager.getInstances()) {
                IControllerDefinition definition = instance.getDefinition();
                String tag = definition.getHardwareModel().replace(' ', '_').replace('/', '_').toUpperCase(Locale.US);
                String propertiesText = this.instanceSettings.get(tag);
                if (propertiesText == null) continue;
                instance.getDocumentSettingsUI().parse(propertiesText);
            }
            this.instanceSettings.clear();
        }
    }

    private final void loadINIFiles(String path) {
        this.logModel.info("Loading device INI files from " + path + " ...");
        this.iniFiles.init(path, this.logModel);
    }

    public void showStage() {
        SafeRunLater.execute(this.logModel, () -> {
            try {
                MainFrame win = this.getMainFrame();
                win.setVisible(true);
                win.toFront();
            }
            catch (RuntimeException ex) {
                StringWriter sw = new StringWriter();
                ex.printStackTrace(new PrintWriter(sw));
                this.logModel.info(sw.toString());
            }
        });
    }

    public void showProjectWindow() {
        SafeRunLater.execute(this.logModel, () -> {
            try {
                MainFrame win = this.getMainFrame();
                win.setVisible(true);
                win.toFront();
                win.projectSettings();
            }
            catch (RuntimeException ex) {
                StringWriter sw = new StringWriter();
                ex.printStackTrace(new PrintWriter(sw));
                this.logModel.info(sw.toString());
            }
        });
    }

    public void showParameterWindow() {
        SafeRunLater.execute(this.logModel, () -> {
            try {
                MainFrame win = this.getMainFrame();
                win.setVisible(true);
                win.toFront();
                win.parameterMapping();
            }
            catch (RuntimeException ex) {
                StringWriter sw = new StringWriter();
                ex.printStackTrace(new PrintWriter(sw));
                this.logModel.info(sw.toString());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MainFrame getMainFrame() {
        Object object = this.mainFrameLock;
        synchronized (object) {
            if (this.mainFrame == null) {
                this.setSystemLF();
                this.mainFrame = new MainFrame(this, this.instanceManager, this.logModel);
                this.mainConfiguration.restoreStagePlacement(this.mainFrame);
            }
            return this.mainFrame;
        }
    }

    private void setSystemLF() {
        try {
            String systemLookAndFeelClassName = OperatingSystem.get() == OperatingSystem.LINUX ? UIManager.getCrossPlatformLookAndFeelClassName() : UIManager.getSystemLookAndFeelClassName();
            UIManager.setLookAndFeel(systemLookAndFeelClassName);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
            this.logModel.error("Could not set System Look&Feel.", ex);
        }
    }

    @Override
    public boolean[] getBrowserColumnsVisibility(BrowserContentType browserContentType) {
        boolean[] visibilities = new boolean[8];
        String key = "BROWSER_FILTER_COLUMN_" + browserContentType.name();
        for (int i = 0; i < visibilities.length; ++i) {
            visibilities[i] = this.mainConfiguration.getBoolean(key + i, browserContentType != BrowserContentType.PRESET);
        }
        return visibilities;
    }

    @Override
    public void setBrowserColumnsVisibility(BrowserContentType browserContentType, boolean[] visibilities) {
        String key = "BROWSER_FILTER_COLUMN_" + browserContentType.name();
        for (int i = 0; i < visibilities.length; ++i) {
            this.mainConfiguration.putBoolean(key + i, visibilities[i]);
        }
    }

    @Override
    public boolean getPopupWindowNotification() {
        return this.mainConfiguration.getBoolean("ENABLE_POPUP_WINDOW_NOTIFICATION", true);
    }

    @Override
    public void setPopupWindowNotification(boolean enabled) {
        this.mainConfiguration.putBoolean("ENABLE_POPUP_WINDOW_NOTIFICATION", enabled);
    }

    @Override
    public boolean isFullyInitialised() {
        return this.animationTimer != null;
    }

    @Override
    public native boolean openMidiInput(int var1);

    @Override
    public native boolean openMidiOutput(int var1);

    @Override
    public native void closeMidiInput(int var1);

    @Override
    public native void closeMidiOutput(int var1);

    @Override
    public native void sendMidiData(int var1, byte[] var2);

    @Override
    public native void setNoteInputFilters(int var1, int var2, String[] var3);

    @Override
    public native void setNoteInputKeyTranslationTable(int var1, int var2, int[] var3);

    @Override
    public native void setNoteInputVelocityTranslationTable(int var1, int var2, int[] var3);
}

