/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.mode.sequencer;

import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.clip.INoteClip;
import de.mossgrabers.framework.daw.constants.Resolution;
import de.mossgrabers.framework.featuregroup.AbstractMode;

public abstract class AbstractSequencerMode<S extends IControlSurface<C>, C extends Configuration>
extends AbstractMode<S, C> {
    protected final int clipRows;
    protected final int clipCols;
    protected final boolean useDawColors;
    protected int selectedResolutionIndex;

    protected AbstractSequencerMode(String name, S surface, IModel model, boolean isAbsolute, int clipRows, int clipCols, boolean useDawColors) {
        super(name, surface, model, isAbsolute);
        this.clipRows = clipRows;
        this.clipCols = clipCols;
        this.useDawColors = useDawColors;
        this.selectedResolutionIndex = 4;
        this.getClip();
    }

    @Override
    public void onActivate() {
        super.onActivate();
        this.getClip().setStepLength(Resolution.getValueAt(this.selectedResolutionIndex));
    }

    public final INoteClip getClip() {
        return this.model.getNoteClip(this.clipCols, this.clipRows);
    }

    public int getSelectedResolutionIndex() {
        return this.selectedResolutionIndex;
    }

    public void setSelectedResolutionIndex(int selectedResolutionIndex) {
        this.selectedResolutionIndex = selectedResolutionIndex;
    }
}

