/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.graphics.canvas.component;

import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.daw.resource.ChannelType;
import de.mossgrabers.framework.graphics.canvas.component.MenuComponent;
import java.util.EnumMap;

public class ChannelSelectComponent
extends MenuComponent {
    private static final EnumMap<ChannelType, String> ICONS = new EnumMap(ChannelType.class);

    public ChannelSelectComponent(ChannelType type, String menuName, boolean isMenuSelected, String name, ColorEx color, boolean isSelected, boolean isActive) {
        super(menuName, isMenuSelected, name, ChannelSelectComponent.getIcon(type, false), color, isSelected, isActive);
    }

    public ChannelSelectComponent(ChannelType type, String menuName, boolean isMenuSelected, String name, ColorEx color, boolean isSelected, boolean isActive, boolean isPinned) {
        super(menuName, isMenuSelected, name, ChannelSelectComponent.getIcon(type, isPinned), color, isSelected, isActive);
    }

    protected static String getIcon(ChannelType type, boolean isPinned) {
        if (isPinned) {
            return "pin.svg";
        }
        return type == null ? null : ICONS.get((Object)type);
    }

    static {
        ICONS.put(ChannelType.AUDIO, "track/audio_track.svg");
        ICONS.put(ChannelType.INSTRUMENT, "track/instrument_track.svg");
        ICONS.put(ChannelType.GROUP, "track/group_track.svg");
        ICONS.put(ChannelType.GROUP_OPEN, "track/group_track_open.svg");
        ICONS.put(ChannelType.EFFECT, "track/return_track.svg");
        ICONS.put(ChannelType.HYBRID, "track/hybrid_track.svg");
        ICONS.put(ChannelType.MASTER, "track/master_track.svg");
        ICONS.put(ChannelType.LAYER, "track/multi_layer.svg");
    }
}

