/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.daw.constants;

import java.util.Locale;

public enum AutomationMode {
    TRIM_READ("Trim/Read"),
    READ("Read"),
    TOUCH("Touch"),
    LATCH("Latch"),
    LATCH_PREVIEW("Latch Preview"),
    WRITE("Write");

    private final String label;

    private AutomationMode(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public String getIdentifier() {
        return this.name().toLowerCase(Locale.US);
    }

    public static AutomationMode lookup(String identifier) {
        for (AutomationMode mode : AutomationMode.values()) {
            if (!mode.name().equalsIgnoreCase(identifier)) continue;
            return mode;
        }
        return TRIM_READ;
    }
}

